/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.handler;

import com.mojang.blaze3d.shaders.FogShape;
import fuzs.pixelshot.Pixelshot;
import fuzs.pixelshot.client.gui.screens.AbstractCameraScreen;
import fuzs.pixelshot.client.handler.OrthoOverlayHandler;
import fuzs.pixelshot.client.helper.DirectionHelper;
import fuzs.pixelshot.config.ClientConfig;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationContext;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableValue;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.FogType;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class OrthoViewHandler {
    public static final OrthoViewHandler INSTANCE = new OrthoViewHandler();
    public static final float ZOOM_DEFAULT = 8.0f;
    public static final float ZOOM_MIN = 0.1f;
    public static final float ZOOM_MAX = 500.0f;
    public static final float ZOOM_STEP = 0.5f;
    public static final float X_ROTATION_DEFAULT = 30.0f;
    public static final float X_ROTATION_MIN = -90.0f;
    public static final float X_ROTATION_MAX = 90.0f;
    public static final float Y_ROTATION_DEFAULT = 135.0f;
    public static final float Y_ROTATION_MIN = -180.0f;
    public static final float Y_ROTATION_MAX = 180.0f;
    private static final float ROTATION_STEP_MIN = 8.0f;
    private static final float ROTATION_STEP_MAX = 24.0f;
    public static final float NEAR_CLIPPING_DISTANCE = 10.0f;
    public static final float FAR_CLIPPING_DISTANCE = 1000.0f;
    private static final float STEP_MULTIPLIER = 0.25f;
    static final int DECIMAL_PLACES = 1;
    public static final KeyMapping KEY_TOGGLE_VIEW = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("orthographic_camera"), (int)296);
    public static final KeyMapping KEY_OPEN_MENU = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("open_menu"), (int)297);
    public static final KeyMapping KEY_ZOOM_IN = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("zoom_in"), (int)93);
    public static final KeyMapping KEY_ZOOM_OUT = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("zoom_out"), (int)92);
    public static final KeyMapping KEY_ROTATE_LEFT = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("rotate_left"), (int)263);
    public static final KeyMapping KEY_ROTATE_RIGHT = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("rotate_right"), (int)262);
    public static final KeyMapping KEY_ROTATE_UP = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("rotate_up"), (int)265);
    public static final KeyMapping KEY_ROTATE_DOWN = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("rotate_down"), (int)264);
    public static final KeyMapping KEY_SWITCH_PRESET = KeyMappingHelper.registerUnboundKeyMapping((ResourceLocation)Pixelshot.id("switch_preset"));
    private float zoom;
    private float xRot;
    private float yRot;
    private float oldZoom;
    private float oldXRot;
    private float oldYRot;
    private boolean isActive;
    private boolean followPlayerView;
    private boolean nearClipping;
    private boolean renderSky;
    private boolean renderPlayerEntity;
    private boolean freezeControls;
    private boolean tmpHideGui;
    private CameraType tmpCameraType;

    public static void onRegisterKeyMappings(KeyMappingsContext context) {
        context.registerKeyMapping(KEY_TOGGLE_VIEW, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_OPEN_MENU, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ZOOM_IN, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ZOOM_OUT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ROTATE_LEFT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ROTATE_RIGHT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ROTATE_UP, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_ROTATE_DOWN, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_SWITCH_PRESET, KeyActivationContext.GAME);
    }

    public void onStartClientTick(Minecraft minecraft) {
        if (this.oldZoom != this.zoom) {
            OrthoOverlayHandler.INSTANCE.setZoomOverlay(this.zoom, this.oldZoom);
            if (this.oldZoom < this.zoom) {
                Minecraft.m_91087_().f_91060_.m_109826_();
            }
        }
        if (this.oldXRot != this.xRot) {
            OrthoOverlayHandler.INSTANCE.setXRotOverlay(this.xRot, this.oldXRot);
        } else {
            this.setXRot(Mth.m_14177_((float)this.xRot));
        }
        if (this.oldYRot != this.yRot) {
            OrthoOverlayHandler.INSTANCE.setYRotOverlay(this.yRot, this.oldYRot);
        } else {
            this.setYRot(Mth.m_14177_((float)this.yRot));
        }
        this.setOldValues();
        if (this.freezeControls) {
            return;
        }
        while (KEY_TOGGLE_VIEW.m_90859_()) {
            if (Screen.m_96639_()) {
                this.reloadCameraSettings(true);
                continue;
            }
            this.isActive = !this.isActive;
        }
        while (KEY_SWITCH_PRESET.m_90859_()) {
            if (!this.isActive || this.followPlayerView) continue;
            Vector3f vector3f = DirectionHelper.cycle(this.xRot, this.yRot, !Screen.m_96639_());
            this.setXRot(vector3f.x());
            this.setYRot(vector3f.z());
        }
        while (KEY_OPEN_MENU.m_90859_()) {
            if (!this.isActive) continue;
            minecraft.m_91152_(AbstractCameraScreen.openScreen());
        }
        this.updateZoomAndRotation();
    }

    private void updateZoomAndRotation() {
        if (!this.isActive) {
            return;
        }
        if (KEY_ZOOM_IN.m_90857_()) {
            this.setZoom(this.zoom / 1.125f);
        }
        if (KEY_ZOOM_OUT.m_90857_()) {
            this.setZoom(this.zoom * 1.125f);
        }
        if (this.followPlayerView) {
            return;
        }
        float rotationStep = Mth.m_14036_((float)this.zoom, (float)8.0f, (float)24.0f) * 0.25f;
        if (KEY_ROTATE_LEFT.m_90857_()) {
            this.setYRot(this.yRot + rotationStep);
        }
        if (KEY_ROTATE_RIGHT.m_90857_()) {
            this.setYRot(this.yRot - rotationStep);
        }
        if (KEY_ROTATE_UP.m_90857_()) {
            this.setXRot(this.xRot + rotationStep);
        }
        if (KEY_ROTATE_DOWN.m_90857_()) {
            this.setXRot(this.xRot - rotationStep);
        }
    }

    public void onBeforeGameRender(Minecraft minecraft, GameRenderer gameRenderer, float partialTick) {
        if (this.isActive) {
            this.tmpHideGui = minecraft.f_91066_.f_92062_;
            minecraft.f_91066_.f_92062_ = true;
            this.tmpCameraType = minecraft.f_91066_.m_92176_();
            minecraft.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
    }

    public void onAfterGameRender(Minecraft minecraft, GameRenderer gameRenderer, float partialTick) {
        if (this.isActive) {
            minecraft.f_91066_.f_92062_ = this.tmpHideGui;
            minecraft.f_91066_.m_92157_(this.tmpCameraType);
        }
    }

    public void onRenderFog(GameRenderer gameRenderer, Camera camera, float partialTick, FogRenderer.FogMode fogMode, FogType fogType, MutableFloat fogStart, MutableFloat fogEnd, MutableValue<FogShape> fogShape) {
        if (this.isActive && !this.renderSky) {
            fogStart.accept(Float.MAX_VALUE);
            fogEnd.accept(Float.MAX_VALUE);
        }
    }

    public void onComputeFieldOfView(GameRenderer renderer, Camera camera, float partialTick, MutableDouble fieldOfView) {
        if (this.isActive) {
            if (!this.followPlayerView) {
                camera.m_90572_(this.getYRot(partialTick), this.getXRot(partialTick));
            }
            if (this.renderPlayerEntity) {
                camera.f_90560_ = true;
            }
        }
    }

    public void onLoggedIn(LocalPlayer player, MultiPlayerGameMode multiPlayerGameMode, Connection connection) {
        this.reloadCameraSettings(false);
    }

    public void reloadCameraSettings(boolean isActive) {
        this.isActive = isActive;
        this.renderSky = false;
        this.nearClipping = false;
        this.followPlayerView = false;
        this.renderPlayerEntity = true;
        this.setZoom((float)((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialZoomLevel);
        this.setXRot((float)((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialXRotation);
        this.setYRot((float)((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).orthographicCamera.initialYRotation);
        this.setOldValues();
    }

    private void setOldValues() {
        this.oldZoom = this.zoom;
        this.oldXRot = this.xRot;
        this.oldYRot = this.yRot;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean followPlayerView() {
        return this.followPlayerView;
    }

    public boolean nearClipping() {
        return this.nearClipping;
    }

    public boolean renderSky() {
        return this.renderSky;
    }

    public boolean renderPlayerEntity() {
        return this.renderPlayerEntity;
    }

    public void flipFollowPlayerView() {
        this.followPlayerView = !this.followPlayerView;
    }

    public void flipNearClipping() {
        this.nearClipping = !this.nearClipping;
    }

    public void flipRenderSky() {
        this.renderSky = !this.renderSky;
    }

    public void flipRenderPlayerEntity() {
        this.renderPlayerEntity = !this.renderPlayerEntity;
    }

    public void freezeControls(boolean freezeControls) {
        this.freezeControls = freezeControls;
    }

    public void setZoom(float zoom) {
        this.zoom = Mth.m_14036_((float)zoom, (float)0.1f, (float)500.0f);
    }

    public void setXRot(float xRot) {
        this.xRot = Mth.m_14036_((float)xRot, (float)-90.0f, (float)90.0f);
    }

    public void setYRot(float yRot) {
        this.yRot = yRot;
    }

    public float getZoom() {
        return this.getZoom(1.0f);
    }

    public float getXRot() {
        return this.getXRot(1.0f);
    }

    public float getYRot() {
        return this.getYRot(1.0f);
    }

    public float getZoom(float partialTick) {
        return partialTick == 1.0f ? this.zoom : Mth.m_14179_((float)partialTick, (float)this.oldZoom, (float)this.zoom);
    }

    public float getXRot(float partialTick) {
        return Mth.m_14177_((float)(partialTick == 1.0f ? this.xRot : Mth.m_14179_((float)partialTick, (float)this.oldXRot, (float)this.xRot)));
    }

    public float getYRot(float partialTick) {
        return Mth.m_14177_((float)(partialTick == 1.0f ? this.yRot : Mth.m_14179_((float)partialTick, (float)this.oldYRot, (float)this.yRot)));
    }

    public Matrix4f getProjectionMatrix(Minecraft minecraft, float partialTick, boolean forFrustum) {
        float height = this.getZoom(partialTick) + (forFrustum ? 20.0f : 0.0f);
        float width = height * ((float)minecraft.m_91268_().m_85441_() / (float)minecraft.m_91268_().m_85442_());
        return new Matrix4f().setOrtho(-width, width, -height, height, !forFrustum && this.nearClipping ? -10.0f : -1000.0f, 1000.0f);
    }

    public static float roundValue(float value) {
        float roundingPrecision = (float)Math.pow(10.0, 1.0);
        return (float)Math.round(value * roundingPrecision) / roundingPrecision;
    }
}

