/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.handler;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.pixelshot.Pixelshot;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.pixelshot.config.ClientConfig;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationContext;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ScreenshotHandler {
    public static final ScreenshotHandler INSTANCE = new ScreenshotHandler();
    public static final MutableComponent COMPONENT_SCREENSHOT_TAKE = Component.m_237115_((String)"screenshot.take");
    public static final KeyMapping KEY_HIGH_RESOLUTION_SCREENSHOT = KeyMappingHelper.registerKeyMapping((ResourceLocation)Pixelshot.id("high_resolution_screenshot"), (int)298);
    public static final KeyMapping KEY_PANORAMIC_SCREENSHOT = KeyMappingHelper.registerUnboundKeyMapping((ResourceLocation)Pixelshot.id("panoramic_screenshot"));
    private boolean hugeScreenshotMode;

    public static void onRegisterKeyMappings(KeyMappingsContext context) {
        context.registerKeyMapping(KEY_HIGH_RESOLUTION_SCREENSHOT, KeyActivationContext.GAME);
        context.registerKeyMapping(KEY_PANORAMIC_SCREENSHOT, KeyActivationContext.GAME);
    }

    public boolean isHugeScreenshotMode() {
        return this.hugeScreenshotMode;
    }

    private void setHugeScreenshotMode(boolean hugeScreenshotMode) {
        this.hugeScreenshotMode = hugeScreenshotMode;
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        gameRenderer.m_172775_(!hugeScreenshotMode);
        gameRenderer.m_172736_(!hugeScreenshotMode);
    }

    public void onAfterKeyAction(int key, int scanCode, int action, int modifiers) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (action == 1 && minecraft.f_91080_ == null) {
            if (KEY_HIGH_RESOLUTION_SCREENSHOT.m_90832_(key, scanCode)) {
                int windowWidth = minecraft.m_91268_().m_85441_();
                int windowHeight = minecraft.m_91268_().m_85442_();
                int imageWidth = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.imageWidth;
                int imageHeight = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.imageHeight;
                Consumer<Component> consumer = component -> minecraft.execute(() -> minecraft.f_91065_.m_93076_().m_93785_(component));
                this.setHugeScreenshotMode(true);
                if (((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.tiledRendering) {
                    consumer.accept(minecraft.m_167903_(minecraft.f_91069_, windowWidth, windowHeight, imageWidth, imageHeight));
                } else {
                    this.grabHugeScreenshot(minecraft, windowWidth, windowHeight, imageWidth, imageHeight, consumer);
                }
                this.setHugeScreenshotMode(false);
            }
            if (KEY_PANORAMIC_SCREENSHOT.m_90832_(key, scanCode) && !OrthoViewHandler.INSTANCE.isActive()) {
                int panoramicResolution = ((ClientConfig)Pixelshot.CONFIG.get(ClientConfig.class)).highResolutionScreenshots.panoramicResolution;
                Component component2 = this.grabPanoramicScreenshot(minecraft, minecraft.f_91069_, panoramicResolution, panoramicResolution);
                minecraft.execute(() -> minecraft.f_91065_.m_93076_().m_93785_(component2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabHugeScreenshot(Minecraft minecraft, int windowWidth, int windowHeight, int imageWidth, int imageHeight, Consumer<Component> consumer) {
        Window window = minecraft.m_91268_();
        TextureTarget renderTarget = new TextureTarget(imageWidth, imageHeight, true, Minecraft.f_91002_);
        try {
            minecraft.f_91060_.m_173014_();
            window.m_166450_(imageWidth);
            window.m_166452_(imageHeight);
            renderTarget.m_83947_(true);
            minecraft.f_91063_.m_109089_(1.0f, 0L, new PoseStack());
            String screenshotName = ScreenshotHandler.getFile(minecraft.f_91069_, "huge_", ".png").getName();
            Screenshot.m_92295_((File)minecraft.f_91069_, (String)screenshotName, (RenderTarget)renderTarget, consumer);
            consumer.accept((Component)COMPONENT_SCREENSHOT_TAKE);
        }
        finally {
            window.m_166450_(windowWidth);
            window.m_166452_(windowHeight);
            renderTarget.m_83930_();
            minecraft.f_91060_.m_173014_();
            minecraft.m_91385_().m_83947_(true);
        }
    }

    private void setPanoramicMode(boolean panoramicMode) {
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        gameRenderer.m_172775_(!panoramicMode);
        gameRenderer.m_172779_(panoramicMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component grabPanoramicScreenshot(Minecraft minecraft, File gameDirectory, int width, int height) {
        Window window = minecraft.m_91268_();
        LocalPlayer player = minecraft.f_91074_;
        int windowWidth = window.m_85441_();
        int windowHeight = window.m_85442_();
        TextureTarget renderTarget = new TextureTarget(width, height, true, Minecraft.f_91002_);
        float xRot = player.m_146909_();
        float yRot = player.m_146908_();
        float xRotO = player.f_19860_;
        float yRotO = player.f_19859_;
        this.setPanoramicMode(true);
        try {
            minecraft.f_91060_.m_173014_();
            window.m_166450_(width);
            window.m_166452_(height);
            File file = ScreenshotHandler.getFile(new File(minecraft.f_91069_, "screenshots"), "", "");
            file.mkdirs();
            String fileName = file.getName();
            for (int i = 0; i < 6; ++i) {
                switch (i) {
                    case 0: {
                        player.m_146922_(yRot);
                        player.m_146926_(0.0f);
                        break;
                    }
                    case 1: {
                        player.m_146922_((yRot + 90.0f) % 360.0f);
                        player.m_146926_(0.0f);
                        break;
                    }
                    case 2: {
                        player.m_146922_((yRot + 180.0f) % 360.0f);
                        player.m_146926_(0.0f);
                        break;
                    }
                    case 3: {
                        player.m_146922_((yRot - 90.0f) % 360.0f);
                        player.m_146926_(0.0f);
                        break;
                    }
                    case 4: {
                        player.m_146922_(yRot);
                        player.m_146926_(-90.0f);
                        break;
                    }
                    case 5: {
                        player.m_146922_(yRot);
                        player.m_146926_(90.0f);
                    }
                }
                player.f_19859_ = player.m_146908_();
                player.f_19860_ = player.m_146909_();
                renderTarget.m_83947_(true);
                minecraft.f_91063_.m_109089_(1.0f, 0L, new PoseStack());
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Screenshot.m_92295_((File)gameDirectory, (String)(fileName + File.separator + "panorama_" + i + ".png"), (RenderTarget)renderTarget, component -> {});
            }
            MutableComponent component2 = Component.m_237113_((String)fileName).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
            MutableComponent mutableComponent = Component.m_237110_((String)"screenshot.success", (Object[])new Object[]{component2});
            return mutableComponent;
        }
        catch (Exception exception) {
            Pixelshot.LOGGER.error("Couldn't save image", (Throwable)exception);
            MutableComponent mutableComponent = Component.m_237110_((String)"screenshot.failure", (Object[])new Object[]{exception.getMessage()});
            return mutableComponent;
        }
        finally {
            player.m_146926_(xRot);
            player.m_146922_(yRot);
            player.f_19860_ = xRotO;
            player.f_19859_ = yRotO;
            this.setPanoramicMode(false);
            window.m_166450_(windowWidth);
            window.m_166452_(windowHeight);
            renderTarget.m_83930_();
            minecraft.f_91060_.m_173014_();
            minecraft.m_91385_().m_83947_(true);
        }
    }

    private static File getFile(File gameDirectory, String filePrefix, String filePostfix) {
        String fileName = filePrefix + Util.m_241986_();
        int i = 1;
        File file;
        while ((file = new File(gameDirectory, fileName + (String)(i == 1 ? "" : "_" + i) + filePostfix)).exists()) {
            ++i;
        }
        return file;
    }
}

