/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.helper;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class DirectionHelper {
    static final Map<Direction, Vector3f> VALUES = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), DirectionHelper::getAnglesFromRotation));

    static Vector3f getAnglesFromRotation(Direction direction) {
        Vector3f vector3f = direction.m_253075_().getEulerAnglesXYZ(new Vector3f()).mul(57.295776f).sub(90.0f, 0.0f, 0.0f);
        return vector3f.set(Mth.m_14177_((float)vector3f.x()), Mth.m_14177_((float)vector3f.y()), Mth.m_14177_((float)vector3f.z())).round();
    }

    public static Direction cycleForward(Direction direction) {
        return Direction.m_122376_((int)(direction.m_122411_() + 1));
    }

    public static Direction cycleBackward(Direction direction) {
        return Direction.m_122376_((int)(direction.m_122411_() + 5));
    }

    public static Vector3f getAngles(Direction direction) {
        return VALUES.get(direction);
    }

    public static Vector3f cycle(float xRot, float yRot, boolean forward) {
        Direction direction = DirectionHelper.getNearest(xRot, yRot);
        Vector3f angles = DirectionHelper.getAngles(direction);
        if (angles.x() == xRot && angles.z() == yRot) {
            direction = forward ? DirectionHelper.cycleForward(direction) : DirectionHelper.cycleBackward(direction);
            return DirectionHelper.getAngles(direction);
        }
        return angles;
    }

    public static Vector3f getDirectionVector(float pitch, float yaw) {
        float x = Mth.m_14089_((float)yaw) * Mth.m_14089_((float)pitch);
        float y = Mth.m_14031_((float)yaw) * Mth.m_14089_((float)pitch);
        float z = Mth.m_14031_((float)pitch);
        return new Vector3f(-y, -z, x);
    }

    public static Direction getNearest(float xRot, float yRot) {
        Vector3f vector3f = DirectionHelper.getDirectionVector(xRot * ((float)Math.PI / 180), yRot * ((float)Math.PI / 180));
        int maxComponent = vector3f.absolute(new Vector3f()).maxComponent();
        Vector3i vector3i = new Vector3i().setComponent(maxComponent, (int)Math.signum(vector3f.get(maxComponent)));
        return Direction.m_122378_((int)vector3i.x(), (int)vector3i.y(), (int)vector3i.z());
    }
}

