/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.handler;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.puzzleslib.api.chat.v1.ComponentHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class OrthoOverlayHandler {
    public static final OrthoOverlayHandler INSTANCE = new OrthoOverlayHandler();
    public static final String KEY_ZOOM = "pixelshot.zoom";
    public static final String KEY_X_ROTATION = "pixelshot.x_rot";
    public static final String KEY_Y_ROTATION = "pixelshot.y_rot";
    private static final ChatFormatting TEXT_COLOR = ChatFormatting.WHITE;
    private static final ChatFormatting POSITIVE_COLOR = ChatFormatting.GREEN;
    private static final ChatFormatting NEGATIVE_COLOR = ChatFormatting.RED;
    private static final int OVERLAY_TIME = 25;
    private static final int OVERLAY_FADE_START = 5;
    private int overlayTicks;
    private ChatFormatting zoomColor = TEXT_COLOR;
    private ChatFormatting xRotColor = TEXT_COLOR;
    private ChatFormatting yRotColor = TEXT_COLOR;

    public void onStartClientTick(Minecraft minecraft) {
        if (this.overlayTicks > 0) {
            --this.overlayTicks;
        }
    }

    public void setZoomOverlay(float newValue, float oldValue) {
        this.setOverlayTicks();
        this.zoomColor = this.getOverlayColor(newValue, oldValue);
    }

    public void setXRotOverlay(float newValue, float oldValue) {
        this.setOverlayTicks();
        this.xRotColor = this.getOverlayColor(newValue, oldValue);
    }

    public void setYRotOverlay(float newValue, float oldValue) {
        this.setOverlayTicks();
        this.yRotColor = this.getOverlayColor(newValue, oldValue);
    }

    private void setOverlayTicks() {
        this.overlayTicks = 25;
        this.xRotColor = this.yRotColor = TEXT_COLOR;
        this.zoomColor = this.yRotColor;
    }

    private ChatFormatting getOverlayColor(float newValue, float oldValue) {
        return newValue - oldValue > 0.0f ? POSITIVE_COLOR : NEGATIVE_COLOR;
    }

    public void onAfterGameRender(Minecraft minecraft, GameRenderer gameRenderer, float partialTick) {
        OrthoViewHandler orthoViewHandler = OrthoViewHandler.INSTANCE;
        if (orthoViewHandler.isActive() && this.overlayTicks > 0 && minecraft.isGameLoadFinished() && minecraft.level != null && minecraft.screen == null) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(this.getDisplayEntry(KEY_ZOOM, orthoViewHandler.getZoom(), this.zoomColor));
            float xRot = orthoViewHandler.followPlayerView() ? gameRenderer.getMainCamera().getEntity().getViewXRot(1.0f) : orthoViewHandler.getXRot();
            lines.add(this.getDisplayEntry(KEY_X_ROTATION, Mth.wrapDegrees((float)xRot), this.xRotColor));
            float yRot = orthoViewHandler.followPlayerView() ? gameRenderer.getMainCamera().getEntity().getViewYRot(1.0f) : orthoViewHandler.getYRot();
            lines.add(this.getDisplayEntry(KEY_Y_ROTATION, Mth.wrapDegrees((float)yRot), this.yRotColor));
            PoseStack posestack = RenderSystem.getModelViewStack();
            posestack.pushPose();
            posestack.setIdentity();
            posestack.translate(0.0f, 0.0f, -11000.0f);
            RenderSystem.applyModelViewMatrix();
            GuiGraphics guiGraphics = new GuiGraphics(minecraft, minecraft.renderBuffers().bufferSource());
            this.renderLines(minecraft.font, guiGraphics, lines, Mth.clamp((float)(((float)this.overlayTicks - partialTick) / 5.0f), (float)0.0f, (float)1.0f), true);
            guiGraphics.flush();
            posestack.popPose();
            RenderSystem.applyModelViewMatrix();
        }
    }

    private String getDisplayEntry(String translationKey, float value, ChatFormatting color) {
        MutableComponent component = Component.translatable((String)translationKey, (Object[])new Object[]{Component.literal((String)"%.1f".formatted(Float.valueOf(value))).withStyle(color)});
        return ComponentHelper.toString((FormattedText)component);
    }

    private void renderLines(Font font, GuiGraphics guiGraphics, List<String> lines, float alpha, boolean leftSide) {
        for (int j = 0; j < lines.size(); ++j) {
            String s = lines.get(j);
            if (Strings.isNullOrEmpty((String)s)) continue;
            int k = font.width(s);
            int l = leftSide ? 2 : guiGraphics.guiWidth() - 2 - k;
            Objects.requireNonNull(font);
            int i1 = 2 + 9 * j;
            Objects.requireNonNull(font);
            guiGraphics.fill(l - 1, i1 - 1, l + k + 1, i1 + 9 - 1, 0x505050 | (int)(144.0f * alpha) << 24);
        }
        for (int j1 = 0; j1 < lines.size(); ++j1) {
            String s1 = lines.get(j1);
            if (Strings.isNullOrEmpty((String)s1)) continue;
            int k1 = font.width(s1);
            int l1 = leftSide ? 2 : guiGraphics.guiWidth() - 2 - k1;
            Objects.requireNonNull(font);
            int i2 = 2 + 9 * j1;
            guiGraphics.drawString(font, s1, l1, i2, 0xE0E0E0 | Math.max(5, (int)(255.0f * alpha)) << 24, false);
        }
    }
}

