/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.gui.screens;

import fuzs.pixelshot.client.gui.screens.AbstractCameraScreen;
import fuzs.pixelshot.client.gui.screens.RangedSliderButton;
import fuzs.pixelshot.client.handler.OrthoViewHandler;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.TooltipBuilder;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SliderCameraScreen
extends AbstractCameraScreen {
    public SliderCameraScreen(Component title, OrthoViewHandler handler) {
        super(AbstractCameraScreen.Type.SLIDER, title, handler);
    }

    @Override
    void addControlRow(final AbstractCameraScreen.OrthoComponent component, int rowHeight, Collection<AbstractWidget> widgets) {
        super.addControlRow(component, rowHeight, widgets);
        final Consumer<Float> consumer = value -> component.consumer.accept(this.handler, (Float)value);
        Supplier<Float> supplier = () -> component.supplier.apply(this.handler);
        RangedSliderButton sliderButton = new RangedSliderButton(this, this.width / 2 - 130, rowHeight, 260, 20, supplier.get().floatValue(), component.minValue, component.maxValue){
            static final double LOGARITHMIC_SCALE = 4.0;
            static final double LOGARITHMIC_SCALE_POW = Math.pow(10.0, -4.0);

            @Override
            protected double getAbsoluteValue() {
                if (component.supportsLogarithmicScale()) {
                    double value = Math.pow(10.0, this.getRelativeValue() * 4.0 - 4.0) - LOGARITHMIC_SCALE_POW;
                    return Mth.lerp((double)value, (double)this.minValue, (double)this.maxValue);
                }
                return super.getAbsoluteValue();
            }

            @Override
            protected void setAbsoluteValue(double value) {
                if (component.supportsLogarithmicScale()) {
                    value = Mth.inverseLerp((double)value, (double)this.minValue, (double)this.maxValue);
                    this.setRelativeValue((Math.log10(value + LOGARITHMIC_SCALE_POW) + 4.0) / 4.0);
                } else {
                    super.setAbsoluteValue(value);
                }
            }

            @Override
            protected Component getMessageFromValue(double value) {
                return Component.translatable((String)component.translationKey, (Object[])new Object[]{Float.valueOf(OrthoViewHandler.roundValue((float)value))});
            }

            @Override
            protected void applyValue(double value) {
                consumer.accept(Float.valueOf((float)value));
            }
        };
        widgets.add((AbstractWidget)sliderButton);
        SpritelessImageButton plusButton = new SpritelessImageButton(this.width / 2 + 134, rowHeight, 20, 20, 60, 0, WIDGETS_LOCATION, button -> {
            consumer.accept(Float.valueOf(((Float)supplier.get()).floatValue() + SliderCameraScreen.getCurrentIncrement()));
            sliderButton.setAbsoluteValue(((Float)supplier.get()).floatValue());
        }).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT);
        TooltipBuilder.create().setLines(SliderCameraScreen.getCurrentTooltipLines('+')).build((AbstractWidget)plusButton);
        widgets.add((AbstractWidget)plusButton);
        SpritelessImageButton minusButton = new SpritelessImageButton(this.width / 2 - 154, rowHeight, 20, 20, 40, 0, WIDGETS_LOCATION, button -> {
            consumer.accept(Float.valueOf(((Float)supplier.get()).floatValue() - SliderCameraScreen.getCurrentIncrement()));
            sliderButton.setAbsoluteValue(((Float)supplier.get()).floatValue());
        }).setDrawBackground().setTextureLayout(SpritelessImageButton.SINGLE_TEXTURE_LAYOUT);
        TooltipBuilder.create().setLines(SliderCameraScreen.getCurrentTooltipLines('-')).build((AbstractWidget)minusButton);
        widgets.add((AbstractWidget)minusButton);
        widgets.add(this.getResetButton(rowHeight, () -> {
            consumer.accept(Float.valueOf(component.getDefaultValue()));
            sliderButton.setAbsoluteValue(component.getDefaultValue());
        }));
    }
}

