/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pixelshot.client.helper;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class DirectionHelper {
    static final Map<Direction, Vector3f> VALUES = (Map)Arrays.stream(Direction.values()).collect(Maps.toImmutableEnumMap(Function.identity(), DirectionHelper::getAnglesFromRotation));

    static Vector3f getAnglesFromRotation(Direction direction) {
        Vector3f vector3f = direction.getRotation().getEulerAnglesXYZ(new Vector3f()).mul(57.295776f).sub(90.0f, 0.0f, 0.0f);
        return vector3f.set(Mth.wrapDegrees((float)vector3f.x()), Mth.wrapDegrees((float)vector3f.y()), Mth.wrapDegrees((float)vector3f.z())).round();
    }

    public static Direction cycleForward(Direction direction) {
        return Direction.from3DDataValue((int)(direction.get3DDataValue() + 1));
    }

    public static Direction cycleBackward(Direction direction) {
        return Direction.from3DDataValue((int)(direction.get3DDataValue() + 5));
    }

    public static Vector3f getAngles(Direction direction) {
        return VALUES.get(direction);
    }

    public static Vector3f cycle(float xRot, float yRot, boolean forward) {
        Direction direction = DirectionHelper.getNearest(xRot, yRot);
        Vector3f angles = DirectionHelper.getAngles(direction);
        if (angles.x() == xRot && angles.z() == yRot) {
            direction = forward ? DirectionHelper.cycleForward(direction) : DirectionHelper.cycleBackward(direction);
            return DirectionHelper.getAngles(direction);
        }
        return angles;
    }

    public static Vector3f getDirectionVector(float pitch, float yaw) {
        float x = Mth.cos((float)yaw) * Mth.cos((float)pitch);
        float y = Mth.sin((float)yaw) * Mth.cos((float)pitch);
        float z = Mth.sin((float)pitch);
        return new Vector3f(-y, -z, x);
    }

    public static Direction getNearest(float xRot, float yRot) {
        Vector3f vector3f = DirectionHelper.getDirectionVector(xRot * ((float)Math.PI / 180), yRot * ((float)Math.PI / 180));
        int maxComponent = vector3f.absolute(new Vector3f()).maxComponent();
        Vector3i vector3i = new Vector3i().setComponent(maxComponent, (int)Math.signum(vector3f.get(maxComponent)));
        return Direction.getNearest((int)vector3i.x(), (int)vector3i.y(), (int)vector3i.z(), null);
    }
}

