/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaLogoffSpot;

import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ManualAttachment;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.TreeOfSelf.PandaLogoffSpot.PandaLogoffSpotConfig;
import me.drex.vanish.api.VanishAPI;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import net.minecraft.class_5250;
import net.minecraft.class_8113;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PandaLogoffSpot
implements ModInitializer {
    public static final String MOD_ID = "panda-logoff-spot";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"panda-logoff-spot");
    private final Map<UUID, LogoffDisplay> activeDisplays = new HashMap<UUID, LogoffDisplay>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public void onInitialize() {
        PandaLogoffSpotConfig.load();
        ServerPlayerEvents.JOIN.register(this::onJoin);
        ServerPlayerEvents.LEAVE.register(this::onLeave);
    }

    private void onLeave(class_3222 player) {
        if (FabricLoader.getInstance().isModLoaded("melius-vanish") && VanishAPI.isVanished((class_1297)player)) {
            return;
        }
        UUID playerId = player.method_5667();
        String playerName = player.method_7334().name();
        class_243 position = player.method_73189().method_1019(new class_243(0.0, player.method_24833((class_4050)player.method_18376()).field_1325 / 2.0, 0.0));
        int viewDistance = player.method_51469().method_8503().method_3760().method_14568();
        double radiusBlocks = (double)viewDistance * 16.0;
        Set<class_3222> nearbyPlayers = this.getNearbyPlayers(player, radiusBlocks);
        if (!nearbyPlayers.isEmpty()) {
            this.removeDisplay(playerId);
            this.createLogoffDisplay(playerId, playerName, position, nearbyPlayers, player);
        }
    }

    private void onJoin(class_3222 player) {
        this.removeDisplay(player.method_5667());
    }

    private Set<class_3222> getNearbyPlayers(class_3222 logoffPlayer, double radius) {
        HashSet<class_3222> nearbyPlayers = new HashSet<class_3222>();
        for (class_3222 otherPlayer : logoffPlayer.method_51469().method_8503().method_3760().method_14571()) {
            if (otherPlayer == logoffPlayer || otherPlayer.method_51469() != logoffPlayer.method_51469()) continue;
            class_243 logoffPos = logoffPlayer.method_73189();
            class_243 otherPos = otherPlayer.method_73189();
            double deltaX = logoffPos.field_1352 - otherPos.field_1352;
            double deltaZ = logoffPos.field_1350 - otherPos.field_1350;
            double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            if (!(horizontalDistance <= radius)) continue;
            nearbyPlayers.add(otherPlayer);
        }
        return nearbyPlayers;
    }

    private void createLogoffDisplay(UUID playerId, String playerName, class_243 position, Set<class_3222> authorizedViewers, class_3222 logoffPlayer) {
        ElementHolder holder = new ElementHolder();
        TextDisplayElement textElement = new TextDisplayElement();
        class_5250 nameText = class_2561.method_43470((String)playerName).method_27694(style -> style.method_36139(PandaLogoffSpotConfig.getNameColor()).method_10982(Boolean.valueOf(true)));
        class_5250 logoffText = class_2561.method_43470((String)"\nLogoff Spot").method_27694(style -> style.method_36139(0xFFFFFF));
        class_5250 displayText = class_2561.method_43473().method_10852((class_2561)nameText).method_10852((class_2561)logoffText);
        if (PandaLogoffSpotConfig.shouldShowCoords()) {
            class_5250 coordsText = class_2561.method_43470((String)String.format("\n%.1f, %.1f, %.1f", position.field_1352, position.field_1351, position.field_1350)).method_27694(style -> style.method_36139(0xAAAAAA));
            displayText = displayText.method_10852((class_2561)coordsText);
        }
        textElement.setText((class_2561)displayText);
        textElement.setScale((Vector3fc)new Vector3f(PandaLogoffSpotConfig.getScale(), PandaLogoffSpotConfig.getScale(), PandaLogoffSpotConfig.getScale()));
        textElement.setBillboardMode(class_8113.class_8114.field_42409);
        holder.addElement((VirtualElement)textElement);
        ManualAttachment attachment = new ManualAttachment(holder, logoffPlayer.method_51469(), () -> position);
        HashSet<UUID> authorizedUuids = new HashSet<UUID>();
        for (class_3222 viewer : authorizedViewers) {
            authorizedUuids.add(viewer.method_5667());
            attachment.startWatching(viewer);
        }
        ScheduledFuture<?> removalTask = this.scheduler.schedule(() -> this.removeDisplay(playerId), (long)PandaLogoffSpotConfig.getDurationSeconds(), TimeUnit.SECONDS);
        LogoffDisplay display = new LogoffDisplay(holder, attachment, authorizedUuids, removalTask);
        this.activeDisplays.put(playerId, display);
    }

    private void removeDisplay(UUID playerId) {
        LogoffDisplay display = this.activeDisplays.remove(playerId);
        if (display != null) {
            display.removalTask.cancel(false);
            display.attachment.destroy();
        }
    }

    private static class LogoffDisplay {
        final ElementHolder holder;
        final ManualAttachment attachment;
        final Set<UUID> authorizedViewers;
        final ScheduledFuture<?> removalTask;

        LogoffDisplay(ElementHolder holder, ManualAttachment attachment, Set<UUID> authorizedViewers, ScheduledFuture<?> removalTask) {
            this.holder = holder;
            this.attachment = attachment;
            this.authorizedViewers = authorizedViewers;
            this.removalTask = removalTask;
        }
    }
}

