/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaLogoffSpot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class PandaLogoffSpotConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("PandaLogoffSpot.json").toFile();
    private static ConfigData config = new ConfigData();

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            PandaLogoffSpotConfig.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getNameColor() {
        try {
            return Integer.parseInt(PandaLogoffSpotConfig.config.nameColor.replace("#", ""), 16);
        }
        catch (Exception e) {
            return 0xF08080;
        }
    }

    public static boolean shouldShowCoords() {
        return PandaLogoffSpotConfig.config.showCoords;
    }

    public static int getDurationSeconds() {
        return PandaLogoffSpotConfig.config.durationSeconds;
    }

    public static float getScale() {
        return PandaLogoffSpotConfig.config.scale;
    }

    public static class ConfigData {
        public String nameColor = "#F08080";
        public boolean showCoords = true;
        public int durationSeconds = 300;
        public float scale = 0.75f;
    }
}

