#version 430 compatibility

uniform vec3 cameraPosition;
#include "/programs/include/wave.glsl"
#include "/programs/settings.glsl"
vec3 brdf(vec3 lightDir, vec3 viewDir, float roughness, vec3 normal, vec3 albedo, float metallic, vec3 reflectance) {
    //for ease of use
    float alpha = pow(roughness,2);

    vec3 H = normalize(lightDir + viewDir);
    

    //dot products
    float NdotV = clamp(dot(normal, viewDir), 0.001,1.0);
    float NdotL = clamp(dot(normal, lightDir), 0.001,1.0);
    float NdotH = clamp(dot(normal,H), 0.001,1.0);
    float VdotH = clamp(dot(viewDir, H), 0.001,1.0);

    // Fresnel
    vec3 F0 = reflectance;
    vec3 fresnelReflectance = F0 + (1.0 - F0) * pow(1.0 - VdotH, 5.0); //Schlick's Approximation

    //phong diffuse
    vec3 rhoD = albedo;
    rhoD *= (vec3(1.0)- fresnelReflectance); //energy conservation - light that doesn't reflect adds to diffuse

    //rhoD *= (1-metallic); //diffuse is 0 for metals

    // Geometric attenuation
    float k = alpha/2;
    float geometry = (NdotL / (NdotL*(1.0-k)+k)) * (NdotV / ((NdotV*(1.0-k)+k)));

    // Distribution of Microfacets
    float lowerTerm = pow(NdotH,2) * (pow(alpha,2) - 1.0) + 1.0;
    float normalDistributionFunctionGGX = pow(alpha,2.0) / (3.14159 * pow(lowerTerm,2.0));

    vec3 phongDiffuse = rhoD; //
    vec3 cookTorrance = (fresnelReflectance*normalDistributionFunctionGGX*geometry)/(4*NdotL*NdotV);
    
    vec3 BRDF = (phongDiffuse+cookTorrance)*NdotL;
   
    vec3 diffFunction = BRDF;
    
    return BRDF;
    
}
uniform sampler2D lightmap;
uniform sampler2D depthtex0;
uniform sampler2D normals;
uniform float viewHeight;
uniform float viewWidth;
uniform float rainStrength;
uniform vec3 fogColor;
uniform float sunAngle;
uniform mat4 gbufferModelViewInverse;
uniform vec3 shadowLightPosition;
uniform sampler2D specular;
/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 outColor0;


in vec4 blockColor;
in vec2 lightMapCoords;
in vec3 viewSpacePosition;
in vec3 geoNormal;
in vec2 texCoord;
in vec4 tangent;
mat3 tbnNormalTangent(vec3 normal, vec3 tangent) {
    //for DirectX normal mapping you want to switch the order of these
    vec3 bitangent = cross(tangent, normal);
    return mat3(tangent, bitangent, normal);
}
mat3 generateSimpleTBN(vec3 normal) {
    // Create an arbitrary tangent vector
    vec3 tangent;
    vec3 c1 = cross(normal, vec3(0.0, 0.0, 1.0));
    vec3 c2 = cross(normal, vec3(0.0, 1.0, 0.0));
    
    // Choose the cross product that gives the longer vector
    if (length(c1) > length(c2)) {
        tangent = c1;
    } else {
        tangent = c2;
    }
    
    tangent = normalize(tangent);
    vec3 bitangent = normalize(cross(normal, tangent));
    
    return mat3(tangent, bitangent, normal);
}
void main() {
    vec4 outputColorData = vec4(pow(blockColor.rgb, vec3(2.2)), blockColor.a);
    vec3 outputColor = outputColorData.rgb;
    float transparency = outputColorData.a;
    if(outputColorData.a < 0.1) {
        discard;
    }
    //transparency = transparency * (outputColor.x + outputColor.y + outputColor.z) * WATER_TRANSLUCENCY_MULTIPLIER;
    
    vec3 shadowLightDirection = normalize(mat3(gbufferModelViewInverse)*shadowLightPosition);

    vec3 worldGeoNormal = mat3(gbufferModelViewInverse) * geoNormal;
    
    vec3 worldTangent = normalize(mat3(gbufferModelViewInverse) * tangent.xyz);
    vec4 normalData = texture(normals, texCoord)*2.0 - 1.0;
    vec3 normalNormalSpace = vec3(normalData.xy, sqrt(1.0-dot(normalData.xy, normalData.xy)));
    mat3 TBN = generateSimpleTBN(worldGeoNormal);
    vec3 normalWorldSpace = TBN * normalNormalSpace;
     vec4 specularData = texture(specular, texCoord);
    float perceptualSmoothness = 0.0001;
    
    float metallic = 0.001;
    vec3 reflectance = vec3(0.1);
    
    float roughness = pow(1.0-perceptualSmoothness, 2.0);
    float smoothness = 1-roughness;

    float lightBrightness = clamp(dot(shadowLightDirection,worldGeoNormal), 0.2, 1.0);

    vec3 skyLight = pow(texture(lightmap, vec2(1/32.0,lightMapCoords.y)).rgb, vec3(2.2));

    vec3 blockLight = pow(texture(lightmap, vec2(lightMapCoords.x, 1/32.0)).rgb, vec3(2.2));
    vec3 worldPos = (gbufferModelViewInverse * vec4(viewSpacePosition.xyz, 1)).xyz + cameraPosition;
    vec3 viewDirection = normalize(cameraPosition - worldPos);
    vec3 riseColor = vec3(1.2, 0.65, 0.5);
	vec3 dayColor = vec3(1.0);
	vec3 nightColor = vec3(0.2, 0.3, 0.3);

    if (sunAngle > 0.00 && sunAngle < 0.025) {
		skyLight = skyLight*riseColor;
	}
	if (sunAngle > 0.025 && sunAngle < 0.075) {
		skyLight = skyLight*mix(riseColor, dayColor, 1/0.05 * (sunAngle - 0.025));
	}
	if (sunAngle > 0.075 && sunAngle < 0.45) {
		skyLight = skyLight*dayColor;
	}
	if (sunAngle > 0.45 && sunAngle < 0.5) {
		skyLight = skyLight*mix(dayColor, riseColor, 1/0.05 * (sunAngle-0.45));
	}
	if (sunAngle > 0.50 && sunAngle < 0.55) {
		skyLight = skyLight*mix(riseColor, nightColor, 1/0.05 * (sunAngle-0.5));
	}
	if ((sunAngle > 0.55 && sunAngle < 0.90) ) {
		skyLight = skyLight*nightColor;
	}
	if ((sunAngle > 0.90 && sunAngle < 1.0) ) {
		skyLight  = skyLight*mix(nightColor, riseColor, 1/0.1 * (sunAngle-0.90));
	}

    
    vec3 sunColor = vec3(1.0);
if (sunAngle < 0.5) {// || sunAngle > 0.98) {
        if (sunAngle > 0.00 && sunAngle < 0.055) {// || sunAngle > 0.98) {
            sunColor = mix(vec3(1.0, 0.3, 0.1), vec3(1.0, 0.5, 0.3), 1/0.055 * (sunAngle));
        } else {
            sunColor = vec3(1.0, 0.5, 0.3);
        }
        sunColor = mix(sunColor, vec3(0.2, 0.1, 0.05), rainStrength);
    } else {
        sunColor = vec3(0.6, 0.6, 0.6);
        
    }
    
#if WATER_STYLE == 1
    //if (dhMaterialId == DH_BLOCK_WATER) {
        //water
        smoothness = 0.9;
        metallic = 0.01;
        roughness = 0.01 * WATER_ROUGHNESS*(0.1 + 5 * pow((outputColor.r + outputColor.g + outputColor.b)/3.0+ 0.8, 2.0));
        reflectance = vec3(WATER_SHININESS * 0.25);
        //outputColor = vec3(outputColor.r/10, clamp(outputColor.g*1.3, 0.0, 0.2), clamp(outputColor.b*1.5, 0.0, 0.4));
    //}
    #endif

    vec3 brdfv = brdf(shadowLightDirection, viewDirection, roughness, normalWorldSpace, outputColor, metallic, reflectance);
     brdfv = clamp(brdfv, vec3(0.0), vec3(1.5));
     if ((brdfv.r + brdfv.g + brdfv.b)/3 > 0.5) {
        //if (sunAngle > 0.5) 
        sunColor=sunColor*15;
        transparency += clamp((max((brdfv.r + brdfv.g + brdfv.b)/2-0.4, 0.0))*(skyLight.r + skyLight.g + skyLight.b)/3, 0.0, 1.0);
        //}
     }
     vec3 ambientLightDirection = worldGeoNormal;
    vec3 ambientLight = (blockLight/2*(AMBIENT_INTENSITY) + 0.2*skyLight*SKYLIGHT_INTENSITY)*clamp(dot(ambientLightDirection, normalWorldSpace), 0.0, 1.0);

    outputColor = outputColor*ambientLight + SHADOW_INTENSITY*skyLight*sunColor*brdfv;


    vec2 texCoord = gl_FragCoord.xy / vec2(viewWidth, viewHeight);
    float depth = texture(depthtex0, texCoord).r;

    if (depth != 1.0) {
    discard;
    }

    float distanceFromCamera = distance(vec3(0), viewSpacePosition);

    float maxFogDistance = 2800;

    float minFogDistance = 1500;
    

    

    outColor0 =vec4(pow(outputColor,vec3(1/2.2)), transparency);
}