/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantmentbroker;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.mrbysco.enchantmentbroker.client.ClientHandler;
import com.mrbysco.enchantmentbroker.commands.BrokerCommands;
import com.mrbysco.enchantmentbroker.entity.Broker;
import com.mrbysco.enchantmentbroker.registry.ModRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.slf4j.Logger;

@Mod(value="enchantmentbroker")
public class EnchantmentBroker {
    public static final String MOD_ID = "enchantmentbroker";
    public static final Logger LOGGER = LogUtils.getLogger();

    public EnchantmentBroker(IEventBus eventBus, Dist dist) {
        ModRegistry.ITEMS.register(eventBus);
        ModRegistry.ENTITIES.register(eventBus);
        ModRegistry.SOUND_EVENTS.register(eventBus);
        eventBus.addListener(this::addTabContents);
        eventBus.addListener(this::registerSpawnPlacement);
        eventBus.addListener(this::registerAttributes);
        NeoForge.EVENT_BUS.addListener(this::onCommandRegister);
        NeoForge.EVENT_BUS.addListener(this::onLivingDamage);
        if (dist.isClient()) {
            eventBus.addListener(ClientHandler::registerEntityRenderers);
        }
    }

    public static ResourceLocation modLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    private void addTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)ModRegistry.BROKER_SPAWN_EGG.get());
        }
    }

    private void registerSpawnPlacement(RegisterSpawnPlacementsEvent event) {
        event.register(ModRegistry.BROKER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(ModRegistry.BROKER.get(), Broker.generateAttributes().build());
    }

    public void onCommandRegister(RegisterCommandsEvent event) {
        BrokerCommands.initializeCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public void onLivingDamage(LivingDamageEvent.Post event) {
        WanderingTrader wanderingTrader;
        LivingEntity livingEntity;
        FallingBlockEntity fallingBlockEntity;
        DamageSource source = event.getSource();
        Entity entity = source.getDirectEntity();
        if (entity instanceof FallingBlockEntity && (fallingBlockEntity = (FallingBlockEntity)entity).getBlockState().is(BlockTags.ANVIL) && (livingEntity = event.getEntity()) instanceof WanderingTrader && (wanderingTrader = (WanderingTrader)livingEntity).getType() == EntityType.WANDERING_TRADER) {
            Level level = livingEntity.level();
            Broker broker = (Broker)ModRegistry.BROKER.get().create(level, EntitySpawnReason.CONVERSION);
            if (broker != null) {
                broker.setPos(wanderingTrader.getX(), wanderingTrader.getY(), wanderingTrader.getZ());
                broker.setYRot(wanderingTrader.getYRot());
                broker.setXRot(wanderingTrader.getXRot());
                wanderingTrader.discard();
                level.addFreshEntity((Entity)broker);
            }
        }
    }
}

