/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantmentbroker.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.enchantmentbroker.entity.Broker;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CrossedArmsItemLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HoldingEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.VillagerRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class BrokerRenderer
extends MobRenderer<Broker, VillagerRenderState, VillagerModel> {
    private static final ResourceLocation BROKER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/wandering_trader.png");

    public BrokerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new VillagerModel(context.bakeLayer(ModelLayers.WANDERING_TRADER)), 0.5f);
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getPlayerSkinRenderCache()));
        this.addLayer((RenderLayer)new CrossedArmsItemLayer((RenderLayerParent)this));
    }

    public VillagerRenderState createRenderState() {
        return new VillagerRenderState();
    }

    public void extractRenderState(Broker broker, VillagerRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)broker, (LivingEntityRenderState)renderState, partialTick);
        HoldingEntityRenderState.extractHoldingEntityRenderState((LivingEntity)broker, (HoldingEntityRenderState)renderState, (ItemModelResolver)this.itemModelResolver);
        renderState.isUnhappy = broker.getUnhappyCounter() > 0;
    }

    public ResourceLocation getTextureLocation(VillagerRenderState broke) {
        return BROKER_TEXTURE;
    }

    protected void scale(VillagerRenderState renderState, PoseStack poseStack) {
        float f = 0.9375f;
        poseStack.scale(f, f, f);
    }
}

