/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantmentbroker.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.enchantmentbroker.data.BrokerData;
import com.mrbysco.enchantmentbroker.data.StoredEnchantment;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class BrokerCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder root = Commands.literal((String)"enchantmentbroker");
        ((LiteralArgumentBuilder)root.requires(commandSource -> commandSource.hasPermission(2))).then(Commands.literal((String)"storedEnchants").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).suggests((source, builder) -> SharedSuggestionProvider.suggest(BrokerCommands.getKnownUUIDS(((CommandSourceStack)source.getSource()).getServer()), (SuggestionsBuilder)builder)).then(Commands.literal((String)"clear").executes(BrokerCommands::clearEnchantments))).then(Commands.literal((String)"add").then(Commands.argument((String)"enchantment", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENCHANTMENT)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(BrokerCommands::addEnchantment))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").then((ArgumentBuilder)Commands.argument((String)"enchantment", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENCHANTMENT)))).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(BrokerCommands::removeEnchantment)))).then(Commands.literal((String)"list").executes(BrokerCommands::listEnchantments))));
        dispatcher.register(root);
    }

    private static Iterable<String> getKnownUUIDS(MinecraftServer server) {
        HashSet<String> set = new HashSet<String>();
        BrokerData brokerData = BrokerData.get((Level)server.getLevel(Level.OVERWORLD));
        if (brokerData != null) {
            set.addAll(brokerData.getUUIDs());
        }
        for (ServerPlayer serverPlayer : server.getPlayerList().getPlayers()) {
            UUID uuid = serverPlayer.getGameProfile().id();
            set.add(uuid.toString());
        }
        return set;
    }

    private static int listEnchantments(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        UUID uuid = UuidArgument.getUuid(ctx, (String)"uuid");
        List<StoredEnchantment> enchantments = BrokerData.get((Level)source.getLevel()).getEnchantments(uuid);
        if (enchantments.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"command.enchantmentbroker.list.empty", (Object[])new Object[]{uuid.toString()}));
        } else {
            source.sendSuccess(() -> Component.translatable((String)"command.enchantmentbroker.list.message", (Object[])new Object[]{uuid.toString()}), true);
            enchantments.forEach(enchantment -> source.sendSuccess(() -> Component.translatable((String)"command.enchantmentbroker.list.message.enchant", (Object[])new Object[]{((Enchantment)enchantment.enchantmentHolder().value()).description().getString(), enchantment.level()}), false));
        }
        return 0;
    }

    private static int clearEnchantments(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        UUID uuid = UuidArgument.getUuid(ctx, (String)"uuid");
        BrokerData data = BrokerData.get((Level)source.getLevel());
        boolean removed = data.clearEnchantments(uuid);
        if (removed) {
            source.sendSuccess(() -> Component.translatable((String)"command.enchantmentbroker.clear.message", (Object[])new Object[]{uuid.toString()}).withStyle(ChatFormatting.GOLD), true);
            data.setDirty();
        } else {
            source.sendFailure((Component)Component.translatable((String)"command.enchantmentbroker.clear.empty", (Object[])new Object[]{uuid.toString()}));
        }
        return 0;
    }

    private static int addEnchantment(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        UUID uuid = UuidArgument.getUuid(ctx, (String)"uuid");
        Holder.Reference enchantment = ResourceArgument.getEnchantment(ctx, (String)"enchantment");
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        BrokerData data = BrokerData.get((Level)source.getLevel());
        data.addEnchantment(uuid, (Holder<Enchantment>)enchantment, level);
        data.setDirty();
        source.sendSuccess(() -> Component.translatable((String)"command.enchantmentbroker.add.message", (Object[])new Object[]{((Enchantment)enchantment.value()).description().getString(), level, uuid.toString()}), true);
        return 0;
    }

    private static int removeEnchantment(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        UUID uuid = UuidArgument.getUuid(ctx, (String)"uuid");
        Holder.Reference enchantment = ResourceArgument.getEnchantment(ctx, (String)"enchantment");
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        BrokerData data = BrokerData.get((Level)source.getLevel());
        boolean removed = data.removeStoredEnchantment(uuid, (Holder<Enchantment>)enchantment, level);
        if (removed) {
            source.sendSuccess(() -> Component.translatable((String)"command.enchantmentbroker.remove.message", (Object[])new Object[]{((Enchantment)enchantment.value()).description().getString(), level, uuid.toString()}), true);
            data.setDirty();
        } else {
            source.sendFailure((Component)Component.translatable((String)"command.enchantmentbroker.remove.failed", (Object[])new Object[]{((Enchantment)enchantment.value()).description().getString(), level, uuid.toString()}));
        }
        return removed ? 1 : 0;
    }
}

