/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantmentbroker.datagen.client;

import com.mrbysco.enchantmentbroker.registry.ModRegistry;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class ModLanguageProvider
extends LanguageProvider {
    public ModLanguageProvider(PackOutput packOutput) {
        super(packOutput, "enchantmentbroker", "en_us");
    }

    protected void addTranslations() {
        this.addEntityType(ModRegistry.BROKER, "The Refundler");
        this.addItem((Supplier)ModRegistry.BROKER_SPAWN_EGG, "Enchantment Broker Spawn Egg");
        this.add("enchantmentbroker.broker.empty", "Enchantment Broker has no trades available!");
        this.add("enchantmentbroker.broker.hint", "Right-click the broker with your enchanted item to retrieve enchantments");
        this.add("enchantmentbroker.broker.accepted", "Enchantment Broker has accepted your enchantments!");
        this.addSubtitle((Supplier<SoundEvent>)ModRegistry.BROKER_AMBIENT, "Enchantment Broker mumbles");
        this.addSubtitle((Supplier<SoundEvent>)ModRegistry.BROKER_TRADE, "Enchantment Broker trades");
        this.addSubtitle((Supplier<SoundEvent>)ModRegistry.BROKER_HURT, "Enchantment Broker hurts");
        this.addSubtitle((Supplier<SoundEvent>)ModRegistry.BROKER_DEATH, "Enchantment Broker dies");
        this.addSubtitle((Supplier<SoundEvent>)ModRegistry.BROKER_YES, "Enchantment Broker agrees");
        this.addSubtitle((Supplier<SoundEvent>)ModRegistry.BROKER_NO, "Enchantment Broker disagrees");
        this.add("command.enchantmentbroker.list.message", "List of enchantments for \u00a7e%s\u00a7r:");
        this.add("command.enchantmentbroker.list.message.enchant", "Enchantment: \u00a7e%s\u00a7r, Level \u00a7e%s\u00a7r");
        this.add("command.enchantmentbroker.list.empty", "No enchantments found for \u00a7e%s\u00a7r");
        this.add("command.enchantmentbroker.clear.message", "Cleared all stored enchantments for \u00a7e%s\u00a7r");
        this.add("command.enchantmentbroker.clear.empty", "No stored enchantments found for \u00a7e%s\u00a7r to clear");
        this.add("command.enchantmentbroker.add.message", "Added \u00a7e%s\u00a7r level \u00a7e%s\u00a7r to \u00a7e%s\u00a7r's stored enchantments");
        this.add("command.enchantmentbroker.remove.message", "Removed \u00a7e%s\u00a7r level \u00a7e%s\u00a7r from \u00a7e%s\u00a7r's stored enchantments");
        this.add("command.enchantmentbroker.remove.failed", "Failed to remove \u00a7e%s\u00a7r level \u00a7e%s\u00a7r from \u00a7e%s\u00a7r's stored enchantments, it may not exist");
    }

    public void addSubtitle(Supplier<SoundEvent> sound, String text) {
        this.addSubtitle(sound.get(), text);
    }

    public void addSubtitle(SoundEvent sound, String text) {
        String path = "enchantmentbroker.subtitle." + sound.location().getPath();
        this.add(path, text);
    }
}

