/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantmentbroker.entity;

import com.mrbysco.enchantmentbroker.data.BrokerData;
import com.mrbysco.enchantmentbroker.data.StoredEnchantment;
import com.mrbysco.enchantmentbroker.registry.ModRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.Nullable;

public class Broker
extends AbstractVillager {
    private static final int NUMBER_OF_TRADE_OFFERS = 3;

    public Broker(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Broker.createMobAttributes();
    }

    public boolean showProgressBar() {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Evoker.class, 12.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vindicator.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vex.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Pillager.class, 15.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Illusioner.class, 12.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zoglin.class, 10.0f, 0.5, 0.5));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.35));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.goalSelector.addGoal(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.isAlive() && !this.isTrading() && !this.isBaby()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.awardStat(Stats.TALKED_TO_VILLAGER);
            }
            if (!this.level().isClientSide()) {
                this.setTradingPlayer(player);
                ItemEnchantments enchantments = itemstack.getTagEnchantments();
                if (!enchantments.isEmpty()) {
                    BrokerData data = BrokerData.get(this.level());
                    for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                        data.addEnchantment(player.getGameProfile().id(), (Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue());
                    }
                    data.setDirty();
                    itemstack.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                    itemstack.set(DataComponents.REPAIR_COST, (Object)0);
                    this.updateTrades();
                    this.setTradingPlayer(null);
                    player.displayClientMessage((Component)Component.translatable((String)"enchantmentbroker.broker.accepted").withStyle(ChatFormatting.GREEN), true);
                    this.playSound(SoundEvents.GRINDSTONE_USE, 1.0f, this.getRandom().nextFloat() * 0.1f + 0.9f);
                    return InteractionResult.CONSUME;
                }
                this.updateTrades();
                if (this.getOffers().isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"enchantmentbroker.broker.empty").withStyle(ChatFormatting.RED), true);
                    this.playSound((SoundEvent)ModRegistry.BROKER_NO.get(), 1.0f, this.getRandom().nextFloat() * 0.1f + 0.9f);
                    this.setTradingPlayer(null);
                    return InteractionResult.CONSUME;
                }
                this.openTradingScreen(player, this.getDisplayName(), 1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.offers = new MerchantOffers();
    }

    protected void rewardTradeXp(MerchantOffer offer) {
    }

    public MerchantOffers getOffers() {
        if (this.level().isClientSide()) {
            throw new IllegalStateException("Cannot load Broker offers on the client");
        }
        if (this.offers == null) {
            this.offers = new MerchantOffers();
        }
        return this.offers;
    }

    protected void updateTrades() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
        } else {
            this.offers.clear();
        }
        if (this.level().isClientSide()) {
            throw new IllegalStateException("Cannot update Broker trades on the client");
        }
        if (this.getTradingPlayer() == null) {
            return;
        }
        BrokerData data = BrokerData.get(this.level());
        ArrayList<StoredEnchantment> storedEnchantments = new ArrayList<StoredEnchantment>(data.getEnchantments(this.getTradingPlayer().getGameProfile().id()));
        if (storedEnchantments.isEmpty()) {
            return;
        }
        storedEnchantments.sort((e1, e2) -> this.random.nextInt(2) - 1);
        for (int i = 0; i < 3; ++i) {
            if (i >= storedEnchantments.size()) continue;
            StoredEnchantment enchantment = (StoredEnchantment)storedEnchantments.get(i);
            Holder<Enchantment> enchantmentHolder = enchantment.enchantmentHolder();
            int level = enchantment.level();
            ItemStack bookStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            bookStack.enchant(enchantmentHolder, level);
            int cost = this.random.nextIntBetweenInclusive(1, level * 2) + 1;
            MerchantOffer offer = new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, cost), Optional.empty(), bookStack, 1, 5, 0.2f);
            this.offers.add((Object)offer);
        }
    }

    public void notifyTrade(MerchantOffer offer) {
        Player player = this.getTradingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack resultStack = offer.getResult();
            ItemEnchantments enchantments = (ItemEnchantments)resultStack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            BrokerData data = BrokerData.get(this.level());
            Optional enchantmentHolder = enchantments.entrySet().stream().findFirst();
            enchantmentHolder.ifPresent(entry -> data.removeStoredEnchantment(serverPlayer.getGameProfile().id(), (Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue()));
            data.setDirty();
        }
        super.notifyTrade(offer);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return this.isTrading() ? (SoundEvent)ModRegistry.BROKER_TRADE.get() : (SoundEvent)ModRegistry.BROKER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModRegistry.BROKER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModRegistry.BROKER_DEATH.get();
    }

    protected SoundEvent getTradeUpdatedSound(boolean getYesSound) {
        return getYesSound ? (SoundEvent)ModRegistry.BROKER_YES.get() : (SoundEvent)ModRegistry.BROKER_NO.get();
    }

    public SoundEvent getNotifyTradeSound() {
        return (SoundEvent)ModRegistry.BROKER_YES.get();
    }
}

