/*
 * Decompiled with CFR 0.152.
 */
package com.cak.watering_overlay;

import com.cak.watering_overlay.FarmingBlockTypes;
import com.cak.watering_overlay.WateringOverlay;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.world.level.block.state.BlockState;

public enum OverlaySelector {
    SOILS_BOX(state -> FarmingBlockTypes.FARMLAND_CANDIDATE.test((BlockState)state) || FarmingBlockTypes.FARMLAND.test((BlockState)state), FarmingBlockTypes.SUGAR_CANE_PLACEABLE::test, WateringOverlay.OverlayRenderType.BOX, ChatFormatting.AQUA),
    FARMLAND_BOX(FarmingBlockTypes.FARMLAND::test, FarmingBlockTypes.SUGAR_CANE_PLACEABLE::test, WateringOverlay.OverlayRenderType.BOX, ChatFormatting.LIGHT_PURPLE),
    OFF(null, null, null, ChatFormatting.RED);

    final Function<BlockState, Boolean> farmlandRangeRenderFilter;
    final Function<BlockState, Boolean> immediateRangeRenderFilter;
    final WateringOverlay.OverlayRenderType renderType;
    final ChatFormatting chatFormatting;

    private OverlaySelector(Function<BlockState, Boolean> farmlandRangeRenderFilter, Function<BlockState, Boolean> immediateRangeRenderFilter, WateringOverlay.OverlayRenderType renderType, ChatFormatting chatFormatting) {
        this.farmlandRangeRenderFilter = farmlandRangeRenderFilter;
        this.immediateRangeRenderFilter = immediateRangeRenderFilter;
        this.renderType = renderType;
        this.chatFormatting = chatFormatting;
    }

    public boolean shouldRenderInFarmlandRange(BlockState state) {
        return this.farmlandRangeRenderFilter.apply(state);
    }

    public boolean shouldRenderInSugarCaneRange(BlockState state) {
        return this.immediateRangeRenderFilter.apply(state);
    }

    public WateringOverlay.OverlayRenderType getRenderType() {
        return this.renderType;
    }

    public ChatFormatting getChatFormatting() {
        return this.chatFormatting;
    }
}

