/*
 * Decompiled with CFR 0.152.
 */
package com.cak.watering_overlay;

import com.cak.watering_overlay.OverlaySelector;
import com.cak.watering_overlay.WateringOverlay;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class WateringChecker {
    static HashSet<BlockPos> FARMLAND_RANGE_BLOCKS;
    static HashSet<BlockPos> IMMEDIATE_HYDRATION_BLOCKS;
    public static Level lastLevel;
    static int LAZY_TICK_INTERVAL;
    static int lazyTick;
    static final Direction[] HORIZONTAL_DIRECTIONS;
    static final int WATER_RANGE = 4;

    public static void tickFarmlandDiscovery() {
        if (WateringOverlay.DisplayOptions.SELECTOR == OverlaySelector.OFF) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        LocalPlayer player = mc.player;
        if (level == null || player == null) {
            return;
        }
        if (++lazyTick == LAZY_TICK_INTERVAL || lastLevel != level) {
            lazyTick = 0;
            lastLevel = level;
            FARMLAND_RANGE_BLOCKS = new HashSet();
            IMMEDIATE_HYDRATION_BLOCKS = new HashSet();
            WateringChecker.updateWatering((Level)level, (Player)player);
        }
    }

    public static void updateWatering(Level level, Player player) {
        BlockPos originPos = BlockPos.containing((Position)player.position());
        int updateRange = WateringOverlay.DisplayOptions.RANGE + 4 + 10;
        int updateVerticalRange = WateringOverlay.DisplayOptions.VERTICAL_RANGE + 4;
        BlockPos minPos = originPos.offset(-updateRange, -updateVerticalRange, -updateRange);
        BlockPos maxPos = originPos.offset(updateRange, updateVerticalRange, updateRange);
        for (int x = minPos.getX(); x <= maxPos.getX(); ++x) {
            for (int y = minPos.getY(); y <= maxPos.getY(); ++y) {
                for (int z = minPos.getZ(); z <= maxPos.getZ(); ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockState state = level.getBlockState(blockPos);
                    if (state.getBlock() != Blocks.WATER && !state.getFluidState().is((Fluid)Fluids.WATER) && !state.getFluidState().is((Fluid)Fluids.FLOWING_WATER)) continue;
                    WateringChecker.putWaterBlock(blockPos);
                }
            }
        }
    }

    private static void putWaterBlock(BlockPos blockPos) {
        for (Direction direction : HORIZONTAL_DIRECTIONS) {
            IMMEDIATE_HYDRATION_BLOCKS.add(blockPos.relative(direction));
        }
        for (int xOffset = -4; xOffset <= 4; ++xOffset) {
            for (int zOffset = -4; zOffset <= 4; ++zOffset) {
                FARMLAND_RANGE_BLOCKS.add(blockPos.offset(xOffset, 0, zOffset));
            }
        }
    }

    static {
        lastLevel = null;
        LAZY_TICK_INTERVAL = 5;
        lazyTick = 0;
        HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    }
}

