/*
 * Decompiled with CFR 0.152.
 */
package com.cak.watering_overlay;

import com.cak.watering_overlay.OverlaySelector;
import com.cak.watering_overlay.WateredType;
import com.cak.watering_overlay.WateringChecker;
import com.cak.watering_overlay.WateringControls;
import com.cak.watering_overlay.WateringHighlightRenderer;
import com.cak.watering_overlay.WateringOverlay;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public class WateringHandlerEvents {
    public static void onClientTick() {
        WateringChecker.tickFarmlandDiscovery();
        WateringControls.tickControls();
    }

    public static void renderLevelLastEvent(PoseStack ps) {
        if (WateringOverlay.DisplayOptions.SELECTOR == OverlaySelector.OFF) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level != WateringChecker.lastLevel) {
            return;
        }
        HashMap<BlockPos, WateredType> renderedTypeMap = new HashMap<BlockPos, WateredType>();
        for (BlockPos blockPos : WateringChecker.FARMLAND_RANGE_BLOCKS) {
            BlockState state = level.getBlockState(blockPos);
            if (WateringOverlay.DisplayOptions.SELECTOR.shouldRenderInFarmlandRange(state)) {
                renderedTypeMap.put(blockPos, WateredType.FARMLAND);
                continue;
            }
            if (!WateringChecker.IMMEDIATE_HYDRATION_BLOCKS.contains(blockPos) || !WateringOverlay.DisplayOptions.SELECTOR.shouldRenderInSugarCaneRange(state)) continue;
            renderedTypeMap.put(blockPos, WateredType.SUGAR_CANE_ONLY);
        }
        for (Map.Entry entry : renderedTypeMap.entrySet()) {
            BlockPos blockPos = (BlockPos)entry.getKey();
            WateredType wateredType = (WateredType)((Object)entry.getValue());
            EnumMap<Direction, Boolean> connectedSides = new EnumMap<Direction, Boolean>(Direction.class);
            for (Direction direction : Direction.values()) {
                connectedSides.put(direction, renderedTypeMap.containsKey(blockPos.relative(direction.getOpposite())));
            }
            WateringHighlightRenderer.renderWateringHighlightBox(ps, blockPos, wateredType.getTexture(), connectedSides);
        }
    }
}

