/*
 * Decompiled with CFR 0.152.
 */
package com.cak.watering_overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class WateringHighlightRenderer {
    public static void renderWateringHighlightBox(PoseStack poseStack, BlockPos blockPos, ResourceLocation texture, EnumMap<Direction, Boolean> connectedSides) {
        AABB renderedCubeAABB = new AABB(new Vec3(0.0, 0.0, 0.0), new Vec3(1.0, 1.0, 1.0));
        for (Direction direction : Direction.values()) {
            if (connectedSides.get(direction).booleanValue()) continue;
            renderedCubeAABB = WateringHighlightRenderer.includeAABBs(renderedCubeAABB, WateringHighlightRenderer.cubeOnSide(direction.getOpposite().getUnitVec3i(), 0.0625f, 1.0f));
        }
        VertexConsumer buffer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.beaconBeam((ResourceLocation)texture, (boolean)true));
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        poseStack.pushPose();
        WateringHighlightRenderer.translatePSVector(poseStack, camera.getPosition().scale(-1.0));
        WateringHighlightRenderer.translatePSVector(poseStack, Vec3.atLowerCornerOf((Vec3i)blockPos.offset(0, 0, 0)).multiply(1.0, 1.0, 1.0));
        WateringHighlightRenderer.renderHighlightCube(poseStack, buffer, renderedCubeAABB, connectedSides);
        poseStack.popPose();
    }

    private static void translatePSVector(PoseStack poseStack, Vec3 vec) {
        poseStack.translate((float)vec.x(), (float)vec.y(), (float)vec.z());
    }

    private static void renderHighlightCube(PoseStack poseStack, VertexConsumer buffer, AABB renderedCubeAABB, EnumMap<Direction, Boolean> connectedSides) {
        if (!connectedSides.get(Direction.NORTH).booleanValue()) {
            WateringHighlightRenderer.renderHighlightCubeSide(poseStack, buffer, Direction.NORTH, renderedCubeAABB, new Vec3(0.0, 0.0, 1.0), new Vec3(1.0, 1.0, 1.0));
        }
        if (!connectedSides.get(Direction.SOUTH).booleanValue()) {
            WateringHighlightRenderer.renderHighlightCubeSide(poseStack, buffer, Direction.SOUTH, renderedCubeAABB, new Vec3(0.0, 0.0, 0.0), new Vec3(1.0, 1.0, 0.0));
        }
        if (!connectedSides.get(Direction.WEST).booleanValue()) {
            WateringHighlightRenderer.renderHighlightCubeSide(poseStack, buffer, Direction.WEST, renderedCubeAABB, new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 1.0, 1.0));
        }
        if (!connectedSides.get(Direction.EAST).booleanValue()) {
            WateringHighlightRenderer.renderHighlightCubeSide(poseStack, buffer, Direction.EAST, renderedCubeAABB, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 1.0, 1.0));
        }
        if (!connectedSides.get(Direction.UP).booleanValue()) {
            WateringHighlightRenderer.renderHighlightCubeSide(poseStack, buffer, Direction.UP, renderedCubeAABB, new Vec3(0.0, 1.0, 0.0), new Vec3(1.0, 1.0, 1.0));
        }
        if (!connectedSides.get(Direction.DOWN).booleanValue()) {
            WateringHighlightRenderer.renderHighlightCubeSide(poseStack, buffer, Direction.DOWN, renderedCubeAABB, new Vec3(0.0, 0.0, 0.0), new Vec3(1.0, 0.0, 1.0));
        }
    }

    private static void renderHighlightCubeSide(PoseStack poseStack, VertexConsumer buffer, Direction direction, AABB renderedCubeAABB, Vec3 from, Vec3 to) {
        Vec3 min = WateringHighlightRenderer.minVector(renderedCubeAABB).multiply(1.0, -1.0, 1.0).add(0.0, 1.0, 0.0);
        Vec3 max = WateringHighlightRenderer.maxVector(renderedCubeAABB).multiply(1.0, -1.0, 1.0).add(0.0, 1.0, 0.0);
        Vec3 diff = max.subtract(min);
        from = from.multiply(diff).add(min);
        to = to.multiply(diff).add(min);
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)direction.getUnitVec3i());
        double normalOrdinal = WateringHighlightRenderer.sumVector(normal);
        Vec3 perpendiculars = new Vec3(1.0, 1.0, 1.0).subtract(normal.scale(normalOrdinal));
        Vec3 firstAxis = WateringHighlightRenderer.getFirstAxis(perpendiculars);
        Vec3 firstTo = from.add(diff.multiply(firstAxis));
        Vec3 secondaryAxis = WateringHighlightRenderer.getSecondaryAxis(perpendiculars);
        Vec3 secondaryTo = from.add(diff.multiply(secondaryAxis));
        Vec3 realDiff = to.subtract(from);
        Vec3 realDiffPrimary = realDiff.multiply(WateringHighlightRenderer.getFirstAxis(realDiff));
        Vec3 realDiffSecondary = realDiff.multiply(WateringHighlightRenderer.getSecondaryAxis(realDiff));
        float primaryUV = (float)(WateringHighlightRenderer.sumVector(realDiffPrimary) / 0.0625 * 0.015625);
        float secondaryUV = (float)(WateringHighlightRenderer.sumVector(realDiffSecondary) / 0.0625 * 0.015625);
        Vector3f n = new Vector3f((float)normal.x, (float)normal.y, (float)normal.z);
        Matrix4f m = poseStack.last().pose();
        int alpha = 90;
        if (normalOrdinal == -1.0) {
            buffer.addVertex(m, (float)to.x, (float)to.y, (float)to.z).setColor(255, 255, 255, alpha).setUv(primaryUV, secondaryUV).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0, 0).setNormal(n.x, n.y, n.z);
        } else {
            buffer.addVertex(m, (float)from.x, (float)from.y, (float)from.z).setColor(255, 255, 255, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0, 0).setNormal(n.x, n.y, n.z);
        }
        buffer.addVertex(m, (float)firstTo.x, (float)firstTo.y, (float)firstTo.z).setColor(255, 255, 255, alpha).setUv(0.0f, secondaryUV).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0, 0).setNormal(n.x, n.y, n.z);
        if (normalOrdinal == 1.0) {
            buffer.addVertex(m, (float)to.x, (float)to.y, (float)to.z).setColor(255, 255, 255, alpha).setUv(primaryUV, secondaryUV).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0, 0).setNormal(n.x, n.y, n.z);
        } else {
            buffer.addVertex(m, (float)from.x, (float)from.y, (float)from.z).setColor(255, 255, 255, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0, 0).setNormal(n.x, n.y, n.z);
        }
        buffer.addVertex(m, (float)secondaryTo.x, (float)secondaryTo.y, (float)secondaryTo.z).setColor(255, 255, 255, alpha).setUv(primaryUV, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(0, 0).setNormal(n.x, n.y, n.z);
    }

    private static Vec3 getFirstAxis(Vec3 perpendiculars) {
        return perpendiculars.x != 0.0 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
    }

    private static Vec3 getSecondaryAxis(Vec3 perpendiculars) {
        return perpendiculars.z != 0.0 ? new Vec3(0.0, 0.0, 1.0) : new Vec3(0.0, 1.0, 0.0);
    }

    private static AABB cubeOnSide(Vec3i normalVec3i, float height, float width) {
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)normalVec3i).multiply(1.0, -1.0, 1.0);
        double normalOrdinal = WateringHighlightRenderer.sumVector(normal);
        Vec3 faceCenter = new Vec3(0.5, 0.5, 0.5).add(normal.scale(0.5));
        Vec3 edgeOffset = new Vec3(1.0, 1.0, 1.0).subtract(normal.scale(normalOrdinal)).scale(0.5).scale((double)width);
        Vec3 min = faceCenter.subtract(edgeOffset);
        Vec3 max = faceCenter.add(edgeOffset).add(normal.scale((double)height));
        return new AABB(min, max);
    }

    private static double sumVector(Vec3 normal) {
        return normal.x() + normal.y() + normal.z();
    }

    private static Vec3 minVector(AABB AABB2) {
        return new Vec3(AABB2.minX, AABB2.minY, AABB2.minZ);
    }

    private static Vec3 maxVector(AABB AABB2) {
        return new Vec3(AABB2.maxX, AABB2.maxY, AABB2.maxZ);
    }

    private static AABB includeAABBs(AABB from, AABB to) {
        return new AABB(Math.min(from.minX, to.minX), Math.min(from.minY, to.minY), Math.min(from.minZ, to.minZ), Math.max(from.maxX, to.maxX), Math.max(from.maxY, to.maxY), Math.max(from.maxZ, to.maxZ));
    }
}

