/*
 * Decompiled with CFR 0.152.
 */
package com.friskmochi.mochimod.skill;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class RainWandActive {
    private static final List<RainWandActive> ACTIVE = new LinkedList<RainWandActive>();
    private final class_3218 world;
    private final class_1657 player;
    private final int maxSegments;
    private int age = 0;

    public static void add(class_3218 world, class_1657 player, float pullPower) {
        ACTIVE.add(new RainWandActive(world, player, pullPower));
    }

    public static void onServerTick(MinecraftServer server) {
        Iterator<RainWandActive> it = ACTIVE.iterator();
        while (it.hasNext()) {
            RainWandActive r = it.next();
            if (r.tick()) continue;
            it.remove();
        }
    }

    private RainWandActive(class_3218 world, class_1657 player, float pullPower) {
        this.world = world;
        this.player = player;
        this.maxSegments = Math.max(1, (int)(pullPower * 6.0f));
    }

    public boolean tick() {
        ++this.age;
        if (this.age > 160) {
            return false;
        }
        if (this.age % 10 == 1) {
            this.doPulse();
        }
        return true;
    }

    private void doPulse() {
        float seconds = (float)this.age / 20.0f;
        float damage = seconds <= 3.0f ? 15.0f : (seconds <= 5.0f ? 10.0f : 5.0f);
        for (int i = 1; i <= this.maxSegments; ++i) {
            class_243 start = this.player.method_33571();
            class_243 dir = this.player.method_5828(1.0f).method_1029();
            class_243 pos = start.method_1019(dir.method_1021((double)i * 2.5));
            this.world.method_14199((class_2394)class_2398.field_11202, pos.field_1352, pos.field_1351, pos.field_1350, 10, 1.0, 0.5, 1.0, 0.1);
            this.world.method_14199((class_2394)class_2398.field_38908, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            if (i == 1) {
                this.world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14887, class_3419.field_15248, 0.6f, 1.0f);
            }
            List targets = this.world.method_8333((class_1297)this.player, class_238.method_30048((class_243)pos, (double)2.5, (double)2.5, (double)2.5), e -> e instanceof class_1309 && !e.method_5722((class_1297)this.player));
            for (class_1297 t : targets) {
                t.method_5643(this.world.method_48963().method_48831(), damage);
            }
        }
    }
}

