/*
 * Decompiled with CFR 0.152.
 */
package net.hellonearth311.copperrails.registries.custom.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.hellonearth311.copperrails.oxidize.OxidationLevel;
import net.hellonearth311.copperrails.oxidize.OxidizableRail;
import net.hellonearth311.copperrails.oxidize.Waxable;
import net.hellonearth311.copperrails.registries.ModBlocks;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_174;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2452;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_5953;

public class CopperRail
extends class_2241
implements OxidizableRail,
Waxable {
    public static final MapCodec<CopperRail> CODEC = CopperRail.method_54094(CopperRail::new);
    public static final class_2754<class_2768> SHAPE = class_2741.field_12507;
    private final OxidationLevel oxidationLevel;

    public MapCodec<CopperRail> method_53969() {
        return CODEC;
    }

    public CopperRail(OxidationLevel oxidationLevel, class_4970.class_2251 settings) {
        super(false, settings);
        this.oxidationLevel = oxidationLevel;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(SHAPE, (Comparable)class_2768.field_12665)).method_11657((class_2769)field_27096, (Comparable)Boolean.valueOf(false)));
    }

    public CopperRail(class_4970.class_2251 settings) {
        this(OxidationLevel.UNAFFECTED, settings);
    }

    @Override
    public OxidationLevel getOxidationLevel() {
        return this.oxidationLevel;
    }

    @Override
    public class_2680 getDegradedState(class_2680 state) {
        return switch (this.oxidationLevel) {
            default -> throw new MatchException(null, null);
            case OxidationLevel.UNAFFECTED -> (class_2680)((class_2680)ModBlocks.EXPOSED_COPPER_RAIL.method_9564().method_11657(SHAPE, (Comparable)((class_2768)state.method_11654(SHAPE)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)state.method_11654((class_2769)field_27096)));
            case OxidationLevel.EXPOSED -> (class_2680)((class_2680)ModBlocks.WEATHERED_COPPER_RAIL.method_9564().method_11657(SHAPE, (Comparable)((class_2768)state.method_11654(SHAPE)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)state.method_11654((class_2769)field_27096)));
            case OxidationLevel.WEATHERED -> (class_2680)((class_2680)ModBlocks.OXIDIZED_COPPER_RAIL.method_9564().method_11657(SHAPE, (Comparable)((class_2768)state.method_11654(SHAPE)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)state.method_11654((class_2769)field_27096)));
            case OxidationLevel.OXIDIZED, OxidationLevel.WAXED_UNAFFECTED, OxidationLevel.WAXED_EXPOSED, OxidationLevel.WAXED_WEATHERED, OxidationLevel.WAXED_OXIDIZED -> state;
        };
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.tickDegradation(state, world, pos, random);
    }

    @Override
    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return class_1269.field_5811;
    }

    @Deprecated
    public class_1269 use(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        System.out.println("CopperRail.use (deprecated) called with item: " + String.valueOf(player.method_5998(hand).method_7909()));
        return this.onUse(state, world, pos, player, hand, hit);
    }

    @Override
    public Optional<class_2680> getWaxedState(class_2680 currentState) {
        class_2248 waxedBlock;
        if (this.oxidationLevel.isWaxed()) {
            return Optional.empty();
        }
        switch (this.oxidationLevel) {
            case UNAFFECTED: {
                class_2248 class_22482 = ModBlocks.WAXED_COPPER_RAIL;
                break;
            }
            case EXPOSED: {
                class_2248 class_22482 = ModBlocks.WAXED_EXPOSED_COPPER_RAIL;
                break;
            }
            case WEATHERED: {
                class_2248 class_22482 = ModBlocks.WAXED_WEATHERED_COPPER_RAIL;
                break;
            }
            case OXIDIZED: {
                class_2248 class_22482 = ModBlocks.WAXED_OXIDIZED_COPPER_RAIL;
                break;
            }
            default: {
                class_2248 class_22482 = waxedBlock = null;
            }
        }
        if (waxedBlock != null) {
            return Optional.of((class_2680)((class_2680)waxedBlock.method_9564().method_11657(SHAPE, (Comparable)((class_2768)currentState.method_11654(SHAPE)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)currentState.method_11654((class_2769)field_27096))));
        }
        return Optional.empty();
    }

    @Override
    public Optional<class_2680> getUnwaxedState(class_2680 currentState) {
        class_2248 unwaxedBlock;
        if (!this.oxidationLevel.isWaxed()) {
            return Optional.empty();
        }
        switch (this.oxidationLevel) {
            case WAXED_UNAFFECTED: {
                class_2248 class_22482 = ModBlocks.COPPER_RAIL;
                break;
            }
            case WAXED_EXPOSED: {
                class_2248 class_22482 = ModBlocks.EXPOSED_COPPER_RAIL;
                break;
            }
            case WAXED_WEATHERED: {
                class_2248 class_22482 = ModBlocks.WEATHERED_COPPER_RAIL;
                break;
            }
            case WAXED_OXIDIZED: {
                class_2248 class_22482 = ModBlocks.OXIDIZED_COPPER_RAIL;
                break;
            }
            default: {
                class_2248 class_22482 = unwaxedBlock = null;
            }
        }
        if (unwaxedBlock != null) {
            return Optional.of((class_2680)((class_2680)unwaxedBlock.method_9564().method_11657(SHAPE, (Comparable)((class_2768)currentState.method_11654(SHAPE)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)currentState.method_11654((class_2769)field_27096))));
        }
        return Optional.empty();
    }

    public boolean method_9542(class_2680 state) {
        return !this.oxidationLevel.isFullyOxidized() && !this.oxidationLevel.isWaxed();
    }

    protected void method_9477(class_2680 state, class_1937 world, class_2338 pos, class_2248 neighbor) {
        if (neighbor.method_9564().method_26219() && new class_2452(world, pos, state).method_10457().size() == 3) {
            this.method_9475(world, pos, state, false);
        }
    }

    public class_2769<class_2768> method_9474() {
        return SHAPE;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        class_2768 railShape = (class_2768)state.method_11654(SHAPE);
        return (class_2680)state.method_11657(SHAPE, (Comparable)(switch (rotation) {
            case class_2470.field_11464 -> {
                switch (railShape) {
                    case field_12665: {
                        yield class_2768.field_12665;
                    }
                    case field_12674: {
                        yield class_2768.field_12674;
                    }
                    case field_12667: {
                        yield class_2768.field_12666;
                    }
                    case field_12666: {
                        yield class_2768.field_12667;
                    }
                    case field_12670: {
                        yield class_2768.field_12668;
                    }
                    case field_12668: {
                        yield class_2768.field_12670;
                    }
                    case field_12664: {
                        yield class_2768.field_12672;
                    }
                    case field_12671: {
                        yield class_2768.field_12663;
                    }
                    case field_12672: {
                        yield class_2768.field_12664;
                    }
                    case field_12663: {
                        yield class_2768.field_12671;
                    }
                }
                throw new MatchException(null, null);
            }
            case class_2470.field_11465 -> {
                switch (railShape) {
                    case field_12665: {
                        yield class_2768.field_12674;
                    }
                    case field_12674: {
                        yield class_2768.field_12665;
                    }
                    case field_12667: {
                        yield class_2768.field_12670;
                    }
                    case field_12666: {
                        yield class_2768.field_12668;
                    }
                    case field_12670: {
                        yield class_2768.field_12666;
                    }
                    case field_12668: {
                        yield class_2768.field_12667;
                    }
                    case field_12664: {
                        yield class_2768.field_12663;
                    }
                    case field_12671: {
                        yield class_2768.field_12664;
                    }
                    case field_12672: {
                        yield class_2768.field_12671;
                    }
                    case field_12663: {
                        yield class_2768.field_12672;
                    }
                }
                throw new MatchException(null, null);
            }
            case class_2470.field_11463 -> {
                switch (railShape) {
                    case field_12665: {
                        yield class_2768.field_12674;
                    }
                    case field_12674: {
                        yield class_2768.field_12665;
                    }
                    case field_12667: {
                        yield class_2768.field_12668;
                    }
                    case field_12666: {
                        yield class_2768.field_12670;
                    }
                    case field_12670: {
                        yield class_2768.field_12667;
                    }
                    case field_12668: {
                        yield class_2768.field_12666;
                    }
                    case field_12664: {
                        yield class_2768.field_12671;
                    }
                    case field_12671: {
                        yield class_2768.field_12672;
                    }
                    case field_12672: {
                        yield class_2768.field_12663;
                    }
                    case field_12663: {
                        yield class_2768.field_12664;
                    }
                }
                throw new MatchException(null, null);
            }
            default -> railShape;
        }));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        class_2768 railShape = (class_2768)state.method_11654(SHAPE);
        switch (mirror) {
            case field_11300: {
                switch (railShape) {
                    case field_12670: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12668);
                    }
                    case field_12668: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12670);
                    }
                    case field_12664: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12663);
                    }
                    case field_12671: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12672);
                    }
                    case field_12672: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12671);
                    }
                    case field_12663: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12664);
                    }
                }
                return super.method_9569(state, mirror);
            }
            case field_11301: {
                switch (railShape) {
                    case field_12667: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12666);
                    }
                    case field_12666: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12667);
                    }
                    case field_12664: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12671);
                    }
                    case field_12671: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12664);
                    }
                    case field_12672: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12663);
                    }
                    case field_12663: {
                        return (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12672);
                    }
                }
            }
        }
        return super.method_9569(state, mirror);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SHAPE, field_27096});
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        Optional<class_2680> unwaxedState;
        Optional<class_2680> waxedState;
        class_1792 item = stack.method_7909();
        if (item instanceof class_5953 && (waxedState = this.getWaxedState(state)).isPresent()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
            }
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            world.method_8652(pos, waxedState.get(), 11);
            world.method_8396(player, pos, class_3417.field_29543, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (item instanceof class_1743 && (unwaxedState = this.getUnwaxedState(state)).isPresent()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
            }
            world.method_8652(pos, unwaxedState.get(), 11);
            world.method_8396(player, pos, class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!world.field_9236 && entity instanceof class_1688) {
            class_1688 minecart = (class_1688)entity;
            double speedCap = this.oxidationLevel.getMaxSpeed();
            class_243 velocity = minecart.method_18798();
            double currentSpeed = Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350);
            if (currentSpeed > speedCap) {
                double ratio = speedCap / currentSpeed;
                class_243 cappedVelocity = velocity.method_18805(ratio, 1.0, ratio);
                minecart.method_18799(cappedVelocity);
            }
        }
    }
}

