/*
 * Decompiled with CFR 0.152.
 */
package net.hellonearth311.copperrails.registries.custom.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.hellonearth311.copperrails.oxidize.OxidationLevel;
import net.hellonearth311.copperrails.oxidize.OxidizableRail;
import net.hellonearth311.copperrails.oxidize.Waxable;
import net.hellonearth311.copperrails.registries.ModBlocks;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_174;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_5953;

public class PoweredCopperRail
extends class_2241
implements OxidizableRail,
Waxable {
    public static final MapCodec<PoweredCopperRail> CODEC = PoweredCopperRail.method_54094(PoweredCopperRail::new);
    public static final class_2754<class_2768> SHAPE = class_2741.field_12542;
    public static final class_2746 POWERED = class_2741.field_12484;
    private final OxidationLevel oxidationLevel;

    public MapCodec<PoweredCopperRail> method_53969() {
        return CODEC;
    }

    public PoweredCopperRail(OxidationLevel oxidationLevel, class_4970.class_2251 settings) {
        super(true, settings);
        this.oxidationLevel = oxidationLevel;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(SHAPE, (Comparable)class_2768.field_12665)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_27096, (Comparable)Boolean.valueOf(false)));
    }

    public PoweredCopperRail(class_4970.class_2251 settings) {
        this(OxidationLevel.UNAFFECTED, settings);
    }

    @Override
    public OxidationLevel getOxidationLevel() {
        return this.oxidationLevel;
    }

    @Override
    public class_2680 getDegradedState(class_2680 state) {
        return switch (this.oxidationLevel) {
            default -> throw new MatchException(null, null);
            case OxidationLevel.UNAFFECTED -> (class_2680)((class_2680)((class_2680)ModBlocks.EXPOSED_POWERED_COPPER_RAIL.method_9564().method_11657(SHAPE, (Comparable)((class_2768)state.method_11654(SHAPE)))).method_11657((class_2769)POWERED, (Comparable)((Boolean)state.method_11654((class_2769)POWERED)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)state.method_11654((class_2769)field_27096)));
            case OxidationLevel.EXPOSED -> (class_2680)((class_2680)((class_2680)ModBlocks.WEATHERED_POWERED_COPPER_RAIL.method_9564().method_11657(SHAPE, (Comparable)((class_2768)state.method_11654(SHAPE)))).method_11657((class_2769)POWERED, (Comparable)((Boolean)state.method_11654((class_2769)POWERED)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)state.method_11654((class_2769)field_27096)));
            case OxidationLevel.WEATHERED -> (class_2680)((class_2680)((class_2680)ModBlocks.OXIDIZED_POWERED_COPPER_RAIL.method_9564().method_11657(SHAPE, (Comparable)((class_2768)state.method_11654(SHAPE)))).method_11657((class_2769)POWERED, (Comparable)((Boolean)state.method_11654((class_2769)POWERED)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)state.method_11654((class_2769)field_27096)));
            case OxidationLevel.OXIDIZED, OxidationLevel.WAXED_UNAFFECTED, OxidationLevel.WAXED_EXPOSED, OxidationLevel.WAXED_WEATHERED, OxidationLevel.WAXED_OXIDIZED -> state;
        };
    }

    @Override
    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 waxResult = Waxable.super.onUse(state, world, pos, player, hand, hit);
        return waxResult != class_1269.field_5811 ? waxResult : class_1269.field_5811;
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.tickDegradation(state, world, pos, random);
    }

    @Override
    public Optional<class_2680> getWaxedState(class_2680 currentState) {
        class_2248 waxedBlock;
        if (this.oxidationLevel.isWaxed()) {
            return Optional.empty();
        }
        switch (this.oxidationLevel) {
            case UNAFFECTED: {
                class_2248 class_22482 = ModBlocks.WAXED_POWERED_COPPER_RAIL;
                break;
            }
            case EXPOSED: {
                class_2248 class_22482 = ModBlocks.WAXED_EXPOSED_POWERED_COPPER_RAIL;
                break;
            }
            case WEATHERED: {
                class_2248 class_22482 = ModBlocks.WAXED_WEATHERED_POWERED_COPPER_RAIL;
                break;
            }
            case OXIDIZED: {
                class_2248 class_22482 = ModBlocks.WAXED_OXIDIZED_POWERED_COPPER_RAIL;
                break;
            }
            default: {
                class_2248 class_22482 = waxedBlock = null;
            }
        }
        if (waxedBlock != null) {
            return Optional.of((class_2680)((class_2680)((class_2680)waxedBlock.method_9564().method_11657(SHAPE, (Comparable)((class_2768)currentState.method_11654(SHAPE)))).method_11657((class_2769)POWERED, (Comparable)((Boolean)currentState.method_11654((class_2769)POWERED)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)currentState.method_11654((class_2769)field_27096))));
        }
        return Optional.empty();
    }

    @Override
    public Optional<class_2680> getUnwaxedState(class_2680 currentState) {
        class_2248 unwaxedBlock;
        if (!this.oxidationLevel.isWaxed()) {
            return Optional.empty();
        }
        switch (this.oxidationLevel) {
            case WAXED_UNAFFECTED: {
                class_2248 class_22482 = ModBlocks.POWERED_COPPER_RAIL;
                break;
            }
            case WAXED_EXPOSED: {
                class_2248 class_22482 = ModBlocks.EXPOSED_POWERED_COPPER_RAIL;
                break;
            }
            case WAXED_WEATHERED: {
                class_2248 class_22482 = ModBlocks.WEATHERED_POWERED_COPPER_RAIL;
                break;
            }
            case WAXED_OXIDIZED: {
                class_2248 class_22482 = ModBlocks.OXIDIZED_POWERED_COPPER_RAIL;
                break;
            }
            default: {
                class_2248 class_22482 = unwaxedBlock = null;
            }
        }
        if (unwaxedBlock != null) {
            return Optional.of((class_2680)((class_2680)((class_2680)unwaxedBlock.method_9564().method_11657(SHAPE, (Comparable)((class_2768)currentState.method_11654(SHAPE)))).method_11657((class_2769)POWERED, (Comparable)((Boolean)currentState.method_11654((class_2769)POWERED)))).method_11657((class_2769)field_27096, (Comparable)((Boolean)currentState.method_11654((class_2769)field_27096))));
        }
        return Optional.empty();
    }

    public boolean method_9542(class_2680 state) {
        return !this.oxidationLevel.isFullyOxidized() && !this.oxidationLevel.isWaxed();
    }

    protected boolean isPoweredByOtherRails(class_1937 world, class_2338 pos, class_2680 state, boolean bl, int distance) {
        if (distance >= 8) {
            return false;
        }
        int i = pos.method_10263();
        int j = pos.method_10264();
        int k = pos.method_10260();
        boolean bl2 = true;
        class_2768 railShape = (class_2768)state.method_11654(SHAPE);
        switch (railShape) {
            case field_12665: {
                if (bl) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case field_12674: {
                if (bl) {
                    ++i;
                    break;
                }
                --i;
                break;
            }
            case field_12667: {
                if (bl) {
                    ++i;
                } else {
                    ++k;
                    --j;
                    bl2 = false;
                }
                railShape = class_2768.field_12674;
                break;
            }
            case field_12666: {
                if (bl) {
                    --i;
                } else {
                    ++k;
                    --j;
                    bl2 = false;
                }
                railShape = class_2768.field_12674;
                break;
            }
            case field_12670: {
                if (bl) {
                    --k;
                } else {
                    ++i;
                    --j;
                    bl2 = false;
                }
                railShape = class_2768.field_12665;
                break;
            }
            case field_12668: {
                if (bl) {
                    ++k;
                } else {
                    ++i;
                    --j;
                    bl2 = false;
                }
                railShape = class_2768.field_12665;
            }
        }
        return this.findPoweredRailSignal(world, new class_2338(i, j, k), bl2, distance, railShape) || this.findPoweredRailSignal(world, new class_2338(i, j + 1, k), bl2, distance, railShape);
    }

    protected boolean findPoweredRailSignal(class_1937 world, class_2338 pos, boolean bl, int distance, class_2768 railShape) {
        class_2680 blockState = world.method_8320(pos);
        if (!blockState.method_27852((class_2248)this)) {
            return false;
        }
        class_2768 railShape2 = (class_2768)blockState.method_11654(SHAPE);
        if (railShape != class_2768.field_12674 || railShape2 != class_2768.field_12665 && railShape2 != class_2768.field_12670 && railShape2 != class_2768.field_12668) {
            if (railShape != class_2768.field_12665 || railShape2 != class_2768.field_12674 && railShape2 != class_2768.field_12667 && railShape2 != class_2768.field_12666) {
                if (((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue()) {
                    return world.method_49803(pos) || this.isPoweredByOtherRails(world, pos, blockState, true, distance + 1) || this.isPoweredByOtherRails(world, pos, blockState, false, distance + 1);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    protected void method_9477(class_2680 state, class_1937 world, class_2338 pos, class_2248 neighbor) {
        boolean bl2;
        boolean bl = (Boolean)state.method_11654((class_2769)POWERED);
        boolean bl3 = bl2 = world.method_49803(pos) || this.isPoweredByOtherRails(world, pos, state, true, 0) || this.isPoweredByOtherRails(world, pos, state, false, 0);
        if (bl2 != bl) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(bl2)), 3);
            world.method_61271(pos.method_10074(), (class_2248)this);
            if (((class_2768)state.method_11654(SHAPE)).method_11897()) {
                world.method_61271(pos.method_10084(), (class_2248)this);
            }
        }
    }

    public class_2769<class_2768> method_9474() {
        return SHAPE;
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> {
                switch ((class_2768)state.method_11654(SHAPE)) {
                    case field_12667: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12666);
                    }
                    case field_12666: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12667);
                    }
                    case field_12670: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12668);
                    }
                    case field_12668: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12670);
                    }
                    case field_12665: 
                    case field_12674: {
                        yield state;
                    }
                }
                yield state;
            }
            case class_2470.field_11465 -> {
                switch ((class_2768)state.method_11654(SHAPE)) {
                    case field_12665: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12674);
                    }
                    case field_12674: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12665);
                    }
                    case field_12667: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12670);
                    }
                    case field_12666: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12668);
                    }
                    case field_12670: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12666);
                    }
                    case field_12668: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12667);
                    }
                }
                yield state;
            }
            case class_2470.field_11463 -> {
                switch ((class_2768)state.method_11654(SHAPE)) {
                    case field_12665: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12674);
                    }
                    case field_12674: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12665);
                    }
                    case field_12667: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12668);
                    }
                    case field_12666: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12670);
                    }
                    case field_12670: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12667);
                    }
                    case field_12668: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12666);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        class_2768 railShape = (class_2768)state.method_11654(SHAPE);
        return switch (mirror) {
            case class_2415.field_11300 -> {
                switch (railShape) {
                    case field_12670: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12668);
                    }
                    case field_12668: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12670);
                    }
                }
                yield super.method_9569(state, mirror);
            }
            case class_2415.field_11301 -> {
                switch (railShape) {
                    case field_12667: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12666);
                    }
                    case field_12666: {
                        yield (class_2680)state.method_11657(SHAPE, (Comparable)class_2768.field_12667);
                    }
                }
                yield super.method_9569(state, mirror);
            }
            default -> super.method_9569(state, mirror);
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SHAPE, POWERED, field_27096});
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!world.field_9236 && entity instanceof class_1688) {
            class_1688 minecart = (class_1688)entity;
            if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                class_243 velocity = minecart.method_18798();
                double speed = Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350);
                if (speed > 0.01) {
                    double multiplier = 1.06;
                    minecart.method_18800(velocity.field_1352 * multiplier, velocity.field_1351, velocity.field_1350 * multiplier);
                } else {
                    class_2768 shape = (class_2768)state.method_11654(SHAPE);
                    double pushForce = 0.02;
                    switch (shape) {
                        case field_12665: 
                        case field_12670: 
                        case field_12668: {
                            minecart.method_18800(0.0, 0.0, pushForce);
                            break;
                        }
                        case field_12674: 
                        case field_12667: 
                        case field_12666: {
                            minecart.method_18800(pushForce, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        Optional<class_2680> unwaxedState;
        Optional<class_2680> waxedState;
        class_1792 item = stack.method_7909();
        if (item instanceof class_5953 && (waxedState = this.getWaxedState(state)).isPresent()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
            }
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            world.method_8652(pos, waxedState.get(), 11);
            world.method_8396(player, pos, class_3417.field_29543, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (item instanceof class_1743 && (unwaxedState = this.getUnwaxedState(state)).isPresent()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
            }
            world.method_8652(pos, unwaxedState.get(), 11);
            world.method_8396(player, pos, class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }
}

