/*
 * Decompiled with CFR 0.152.
 */
package com.skycatdev.antiscan.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.skycatdev.antiscan.AntiScan;
import com.skycatdev.antiscan.Utils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.minecraft.class_2535;
import net.minecraft.class_2915;
import net.minecraft.class_3248;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_3248.class})
public abstract class ServerLoginNetworkHandlerMixin {
    @Shadow
    @Final
    class_2535 field_14158;

    @WrapMethod(method={"onHello"})
    private void antiScan$handleBaddies(class_2915 packet, Operation<Void> original) {
        boolean good;
        @Nullable String hostString = null;
        SocketAddress socketAddress = this.field_14158.method_10755();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            hostString = inetSocketAddress.getHostString();
        }
        switch (AntiScan.CONFIG.getLoginMode()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MATCH_EITHER: {
                boolean bl;
                if (hostString != null) {
                    if (this.field_14158.method_10756() || !AntiScan.IP_CHECKER.isBlacklisted(hostString) || !AntiScan.NAME_CHECKER.isBlacklisted(packet.comp_765())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (this.field_14158.method_10756() || !AntiScan.NAME_CHECKER.isBlacklisted(packet.comp_765())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case MATCH_NONE: {
                boolean bl = true;
                break;
            }
            case MATCH_ALL: {
                boolean bl = false;
                break;
            }
            case MATCH_BOTH: {
                boolean bl;
                if (hostString != null) {
                    if (this.field_14158.method_10756() || !AntiScan.IP_CHECKER.isBlacklisted(hostString) && !AntiScan.NAME_CHECKER.isBlacklisted(packet.comp_765())) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (this.field_14158.method_10756() && !AntiScan.NAME_CHECKER.isBlacklisted(packet.comp_765())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case MATCH_IP: {
                boolean bl;
                if (hostString != null) {
                    if (this.field_14158.method_10756() || !AntiScan.IP_CHECKER.isBlacklisted(hostString)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = this.field_14158.method_10756();
                break;
            }
            case MATCH_NAME: {
                boolean bl = good = !AntiScan.NAME_CHECKER.isBlacklisted(packet.comp_765());
            }
        }
        if (good) {
            original.call(new Object[]{packet});
        } else {
            switch (AntiScan.CONFIG.getLoginAction()) {
                case NOTHING: {
                    original.call(new Object[]{packet});
                    break;
                }
                case TIMEOUT: {
                    AntiScan.LOGGER.info("Timing out {}.", (Object)(hostString == null ? "connection" : hostString));
                    break;
                }
                case DISCONNECT: {
                    AntiScan.LOGGER.info("Disconnecting {}.", (Object)(hostString == null ? "connection" : hostString));
                    this.field_14158.method_10747(Utils.translatable("multiplayer.disconnect.generic", new Object[0]));
                    break;
                }
                default: {
                    AntiScan.LOGGER.error("Impossible case - login action not handled. Allowing connection. Please report this at https://github.com/skycatminepokie/antiscan/issues.");
                    original.call(new Object[]{packet});
                }
            }
            if (AntiScan.CONFIG.isLoginReport() && hostString != null) {
                AntiScan.IP_CHECKER.report(hostString, "Bad connection attempt. Reported by AntiScan for Fabric.", new int[]{14});
            }
        }
    }
}

