/*
 * Decompiled with CFR 0.152.
 */
package com.skycatdev.antiscan;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skycatdev.antiscan.AntiScan;
import com.skycatdev.antiscan.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IpChecker {
    public static final Codec<IpChecker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().xmap(IpChecker::listToConcurrentSet, set -> set.stream().toList()).fieldOf("blacklistCache").forGetter(IpChecker::getBlacklistCache), (App)Codec.LONG.fieldOf("lastUpdated").forGetter(IpChecker::getLastUpdated), (App)Codec.STRING.listOf().xmap(IpChecker::listToConcurrentSet, set -> set.stream().toList()).fieldOf("manualBlacklist").forGetter(IpChecker::getManualBlacklist), (App)Codec.STRING.listOf().xmap(IpChecker::listToConcurrentSet, set -> set.stream().toList()).fieldOf("whitelistCache").forGetter(IpChecker::getWhitelistCache)).apply((Applicative)instance, (blacklistCache1, lastUpdated1, manualBlacklist1, whitelistCache1) -> new IpChecker((Set<String>)blacklistCache1, (long)lastUpdated1, (Set<String>)manualBlacklist1, (Set<String>)whitelistCache1, new ConcurrentHashMap<String, Long>())));
    protected final Set<String> blacklistCache;
    protected final Set<String> manualBlacklist;
    protected final Set<String> whitelistCache;
    protected long lastUpdated;
    protected final transient Map<String, Long> reportingCache;

    protected IpChecker(Set<String> blacklistCache, long lastUpdated, Set<String> manualBlacklist, Set<String> whitelistCache, ConcurrentHashMap<String, Long> reportingCache) {
        this.blacklistCache = blacklistCache;
        this.lastUpdated = lastUpdated;
        this.manualBlacklist = manualBlacklist;
        this.whitelistCache = whitelistCache;
        this.reportingCache = reportingCache;
    }

    @NotNull
    private static <T> Set<T> listToConcurrentSet(List<T> list) {
        ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
        set.addAll(list);
        return set;
    }

    public static IpChecker load(File saveFile) throws IOException {
        AntiScan.LOGGER.info("Loading ip blacklist.");
        try (JsonReader reader = new JsonReader((Reader)new FileReader(saveFile));){
            IpChecker ipChecker = (IpChecker)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)reader)).getOrThrow()).getFirst();
            return ipChecker;
        }
    }

    public static IpChecker loadOrCreate(File saveFile) {
        if (!saveFile.exists()) {
            AntiScan.LOGGER.info("Creating a new ip blacklist.");
            return new IpChecker(ConcurrentHashMap.newKeySet(), 0L, ConcurrentHashMap.newKeySet(), ConcurrentHashMap.newKeySet(), new ConcurrentHashMap<String, Long>());
        }
        try {
            return IpChecker.load(saveFile);
        }
        catch (IOException e) {
            AntiScan.LOGGER.warn("Failed to load ip blacklist from save file. This is NOT a detrimental error.", (Throwable)e);
            return new IpChecker(ConcurrentHashMap.newKeySet(), 0L, ConcurrentHashMap.newKeySet(), ConcurrentHashMap.newKeySet(), new ConcurrentHashMap<String, Long>());
        }
    }

    public boolean blacklist(String ip) {
        return this.blacklist(ip, false);
    }

    public boolean blacklist(String ip, boolean manual) {
        try {
            return this.blacklist(ip, manual, null);
        }
        catch (IOException e) {
            AntiScan.LOGGER.warn("Failed to save blacklist, even though we weren't trying?", (Throwable)e);
            return false;
        }
    }

    public boolean blacklist(String ip, boolean manual, @Nullable File saveFile) throws IOException {
        boolean added = manual ? this.manualBlacklist.add(ip) : this.blacklistCache.add(ip);
        if (added && saveFile != null) {
            this.save(saveFile);
        }
        return added;
    }

    public boolean checkAbuseIpdb(String ip) {
        HttpResponse<String> response;
        if (AntiScan.CONFIG.getAbuseIpdbKey() == null || this.whitelistCache.contains(ip)) {
            return false;
        }
        AntiScan.LOGGER.info("Checking ip '{}'", (Object)ip);
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(String.format("https://api.abuseipdb.com/api/v2/check?ipAddress=%s", ip))).GET().setHeader("Key", AntiScan.CONFIG.getAbuseIpdbKey()).setHeader("Accept", "application/json").timeout(Duration.of(5L, TimeUnit.SECONDS.toChronoUnit())).build();
            try {
                response = client.send(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | InterruptedException e) {
                AntiScan.LOGGER.warn("Failed to load ip check from AbuseIPDB. This is NOT a fatal error.", (Throwable)e);
                boolean bl = false;
                if (client != null) {
                    client.close();
                }
                return bl;
            }
        }
        if (response != null) {
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                JsonElement json;
                try (JsonReader reader = new JsonReader((Reader)new StringReader(response.body()));){
                    json = Streams.parse((JsonReader)reader);
                }
                catch (IOException e) {
                    AntiScan.LOGGER.warn("Failed to parse ip check from AbuseIPDB. This is NOT a fatal error.", (Throwable)e);
                    return true;
                }
                if (json != null) {
                    boolean safe;
                    boolean bl = safe = json.getAsJsonObject().get("data").getAsJsonObject().get("abuseConfidenceScore").getAsInt() < 90;
                    if (!safe) {
                        this.blacklistCache.add(ip);
                    } else {
                        this.whitelistCache.add(ip);
                    }
                    return safe;
                }
                AntiScan.LOGGER.warn("Failed to load ip check from AbuseIPDB - response was JSON null. This is NOT a fatal error.");
                return false;
            }
            AntiScan.LOGGER.warn("Failed to load ip check from AbuseIPDB. This is NOT a fatal error. Status: {}. Body: {}", (Object)response.statusCode(), (Object)response.body());
            return false;
        }
        AntiScan.LOGGER.warn("Failed to load ip check from AbuseIPDB - response was null. This is NOT a fatal error.");
        return false;
    }

    protected boolean fetchFromAbuseIpdb(String apiKey) {
        HttpResponse<String> response;
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.abuseipdb.com/api/v2/blacklist?confidenceMinimum=90")).GET().setHeader("Key", apiKey).setHeader("Accept", "text/plain").build();
            try {
                response = client.send(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | InterruptedException e) {
                AntiScan.LOGGER.warn("Failed to load ip blacklist from AbuseIPDB. This is NOT a fatal error.", (Throwable)e);
                boolean bl = false;
                if (client != null) {
                    client.close();
                }
                return bl;
            }
        }
        if (response != null) {
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                AntiScan.LOGGER.warn("Failed to load ip blacklist from AbuseIPDB. This is NOT a fatal error. Status: {}. Body: {}", (Object)response.statusCode(), (Object)response.body());
                return false;
            }
        } else {
            AntiScan.LOGGER.warn("Failed to load ip blacklist from AbuseIPDB - response was null. This is NOT a fatal error.");
            return false;
        }
        this.blacklistCache.addAll(Arrays.asList(response.body().split("\n")));
        return true;
    }

    protected boolean fetchFromHunter() {
        HttpResponse<String> response;
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://raw.githubusercontent.com/pebblehost/hunter/refs/heads/master/ips.txt")).GET().build();
            try {
                response = client.send(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | InterruptedException e) {
                AntiScan.LOGGER.warn("Failed to load ip blacklist from hunter. This is NOT a fatal error.", (Throwable)e);
                boolean bl = false;
                if (client != null) {
                    client.close();
                }
                return bl;
            }
        }
        if (response != null) {
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                AntiScan.LOGGER.warn("Failed to load ip blacklist from hunter. This is NOT a fatal error. Status: {}. Body: {}", (Object)response.statusCode(), (Object)response.body());
                return false;
            }
        } else {
            AntiScan.LOGGER.warn("Failed to load ip blacklist from hunter - response was null. This is NOT a fatal error.");
            return false;
        }
        this.blacklistCache.addAll(Arrays.asList(response.body().split("\n")));
        return true;
    }

    public Set<String> getBlacklistCache() {
        return this.blacklistCache;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public Set<String> getManualBlacklist() {
        return this.manualBlacklist;
    }

    private Set<String> getWhitelistCache() {
        return this.whitelistCache;
    }

    public boolean isBlacklisted(String ip) {
        return this.blacklistCache.contains(ip) || this.manualBlacklist.contains(ip) || this.checkAbuseIpdb(ip);
    }

    public Future<Boolean> report(String ip, String comment, int[] categories) {
        FutureTask<Boolean> future = new FutureTask<Boolean>(() -> this.reportNow(ip, comment, categories));
        new Thread(future, "AntiScan Reporting").start();
        return future;
    }

    public boolean reportNow(String ip, String comment, int[] categories) {
        if (AntiScan.CONFIG.getAbuseIpdbKey() != null && !ip.equals("127.0.0.1") && ip.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}") && System.currentTimeMillis() - this.reportingCache.getOrDefault(ip, 0L) > TimeUnit.MINUTES.toMillis(15L)) {
            HttpResponse<String> response;
            this.reportingCache.put(ip, System.currentTimeMillis());
            try (HttpClient client = HttpClient.newHttpClient();){
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.abuseipdb.com/api/v2/report")).POST(HttpRequest.BodyPublishers.ofString(String.format("ip=%s&categories=%s&comment=%s", ip, Arrays.stream(categories).mapToObj(String::valueOf).collect(Collectors.joining(",")), comment.replaceAll("\\W", "+")))).setHeader("Key", AntiScan.CONFIG.getAbuseIpdbKey()).setHeader("Accept", "application/json").setHeader("Content-Type", "application/x-www-form-urlencoded").build();
                try {
                    response = client.send(request, HttpResponse.BodyHandlers.ofString());
                }
                catch (IOException | InterruptedException e) {
                    AntiScan.LOGGER.warn("Failed to report IP. This is NOT a fatal error.", (Throwable)e);
                    boolean bl = false;
                    if (client != null) {
                        client.close();
                    }
                    return bl;
                }
            }
            if (response != null) {
                if (response.statusCode() >= 200 && response.statusCode() < 300) {
                    AntiScan.LOGGER.info("Reported {}.", (Object)ip);
                    return true;
                }
                AntiScan.LOGGER.warn("Failed to report IP to AbuseIPDB. This is NOT a fatal error. Status: {}. Body: {}", (Object)response.statusCode(), (Object)response.body());
                return false;
            }
            AntiScan.LOGGER.warn("Failed to report IP to AbuseIPDB - response was null. This is NOT a fatal error.");
            return false;
        }
        return false;
    }

    public void save(File file) throws IOException {
        Utils.saveToFile(this, file, CODEC);
    }

    public boolean unBlacklist(String ip, boolean manual, @Nullable File saveFile) throws IOException {
        boolean removed = manual ? this.manualBlacklist.remove(ip) : this.blacklistCache.remove(ip);
        if (removed && saveFile != null) {
            this.save(saveFile);
        }
        return removed;
    }

    public Future<Boolean> update(long cooldown) {
        return this.update(cooldown, null);
    }

    public Future<Boolean> update(long cooldown, @Nullable File saveFile) {
        if (System.currentTimeMillis() - this.lastUpdated > cooldown) {
            return this.updateNow(saveFile);
        }
        return CompletableFuture.completedFuture(Boolean.FALSE);
    }

    public Future<Boolean> updateNow() {
        return this.updateNow(null);
    }

    public Future<Boolean> updateNow(@Nullable File saveFile) {
        this.lastUpdated = System.currentTimeMillis();
        AntiScan.LOGGER.info("Updating blacklisted IPs.");
        this.whitelistCache.clear();
        FutureTask<Boolean> hunter = new FutureTask<Boolean>(this::fetchFromHunter);
        FutureTask<Boolean> abuseIpdb = new FutureTask<Boolean>(() -> {
            if (AntiScan.CONFIG.getAbuseIpdbKey() != null) {
                return this.fetchFromAbuseIpdb(AntiScan.CONFIG.getAbuseIpdbKey());
            }
            return false;
        });
        FutureTask<Boolean> finished = new FutureTask<Boolean>(() -> {
            try {
                boolean hunterSucceeded = (Boolean)hunter.get();
                boolean abuseIpdbSucceeded = (Boolean)abuseIpdb.get();
                if (saveFile != null) {
                    this.save(saveFile);
                }
                return hunterSucceeded || abuseIpdbSucceeded;
            }
            catch (InterruptedException | ExecutionException e) {
                AntiScan.LOGGER.warn("Failed to wait for Hunter and AbuseIPDB threads. This is NOT a fatal error.", (Throwable)e);
                return false;
            }
        });
        new Thread(hunter, "AntiScan Hunter").start();
        new Thread(abuseIpdb, "AntiScan AbuseIPDB").start();
        new Thread(finished, "AntiScan Save").start();
        return finished;
    }
}

