/*
 * Decompiled with CFR 0.152.
 */
package com.skycatdev.antiscan;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.skycatdev.antiscan.AntiScan;
import com.skycatdev.antiscan.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static boolean handleNameIpConnection(class_2535 connection, String name, Config.NameIpMode mode, Config.Action action, boolean report, Runnable allow) {
        boolean good;
        switch (mode) {
            default: {
                throw new MatchException(null, null);
            }
            case MATCH_EITHER: {
                boolean bl;
                if (AntiScan.CONNECTION_CHECKER.shouldAllow(connection.method_10755()) && !AntiScan.NAME_CHECKER.isBlacklisted(name)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case MATCH_NONE: {
                boolean bl = true;
                break;
            }
            case MATCH_ALL: {
                boolean bl = false;
                break;
            }
            case MATCH_BOTH: {
                boolean bl;
                if (AntiScan.CONNECTION_CHECKER.shouldAllow(connection.method_10755()) || !AntiScan.NAME_CHECKER.isBlacklisted(name)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case MATCH_IP: {
                boolean bl = AntiScan.CONNECTION_CHECKER.shouldAllow(connection.method_10755());
                break;
            }
            case MATCH_NAME: {
                boolean bl = good = !AntiScan.NAME_CHECKER.isBlacklisted(name);
            }
        }
        if (good) {
            allow.run();
            return true;
        }
        String hostString = null;
        SocketAddress socketAddress = connection.method_10755();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            hostString = inetSocketAddress.getHostString();
        }
        return Utils.handleAction(action, report, connection, allow, hostString);
    }

    public static boolean handleIpConnection(class_2535 connection, Config.IpMode mode, Config.Action action, boolean report, Runnable allow) {
        boolean good;
        switch (mode) {
            default: {
                throw new MatchException(null, null);
            }
            case MATCH_NONE: {
                boolean bl = true;
                break;
            }
            case MATCH_ALL: {
                boolean bl = false;
                break;
            }
            case MATCH_IP: {
                boolean bl = good = AntiScan.CONNECTION_CHECKER.shouldAllow(connection.method_10755());
            }
        }
        if (good) {
            allow.run();
            return true;
        }
        String hostString = null;
        SocketAddress socketAddress = connection.method_10755();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            hostString = inetSocketAddress.getHostString();
        }
        return Utils.handleAction(action, report, connection, allow, hostString);
    }

    private static boolean handleAction(Config.Action action, boolean report, class_2535 connection, Runnable allow, @Nullable String hostString) {
        switch (action) {
            case NOTHING: {
                allow.run();
                break;
            }
            case TIMEOUT: {
                if (!AntiScan.CONFIG.shouldLogActions()) break;
                AntiScan.LOGGER.info("Timing out {}.", (Object)(hostString == null ? "connection" : hostString));
                break;
            }
            case DISCONNECT: {
                if (AntiScan.CONFIG.shouldLogActions()) {
                    AntiScan.LOGGER.info("Disconnecting {}.", (Object)(hostString == null ? "connection" : hostString));
                }
                connection.method_10747(Utils.translatable("multiplayer.disconnect.generic", new Object[0]));
                break;
            }
            default: {
                AntiScan.LOGGER.error("Impossible case - action not handled. Allowing connection. Please report this at https://github.com/skycatminepokie/antiscan/issues.");
                allow.run();
                return true;
            }
        }
        if (report && hostString != null) {
            AntiScan.CONNECTION_CHECKER.report(hostString, "Bad connection attempt. Reported by AntiScan for Fabric.", new int[]{14});
        }
        return false;
    }

    public static <T> void saveToFile(T t, File file, Codec<T> codec) throws IOException {
        if (!(file.exists() || !file.isDirectory() && file.createNewFile())) {
            throw new FileNotFoundException();
        }
        JsonElement json = (JsonElement)codec.encode(t, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(IOException::new);
        try (JsonWriter writer = new JsonWriter((Writer)new PrintWriter(file));){
            writer.setIndent("  ");
            Streams.write((JsonElement)json, (JsonWriter)writer);
        }
    }

    public static <T> T loadFromFile(File file, Codec<T> codec) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new FileReader(file));){
            Object object = ((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)reader)).getOrThrow()).getFirst();
            return (T)object;
        }
    }

    public static class_2561 textOf(String text) {
        return class_2561.method_43470((String)text);
    }

    public static class_2561 translatable(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args);
    }
}

