/*
 * Decompiled with CFR 0.152.
 */
package com.skycatdev.antiscan;

import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skycatdev.antiscan.AntiScan;
import com.skycatdev.antiscan.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public class Config {
    public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("abuseIpdbKey").xmap(opt -> opt.orElse(null), Optional::ofNullable).forGetter(Config::getAbuseIpdbKey), (App)IpMode.CODEC.fieldOf("handshakeMode").forGetter(Config::getHandshakeMode), (App)Action.CODEC.fieldOf("handshakeAction").forGetter(Config::getHandshakeAction), (App)Codec.BOOL.fieldOf("handshakeReport").forGetter(Config::isHandshakeReport), (App)NameIpMode.CODEC.fieldOf("loginMode").forGetter(Config::getLoginMode), (App)Action.CODEC.fieldOf("loginAction").forGetter(Config::getLoginAction), (App)Codec.BOOL.fieldOf("loginReport").forGetter(Config::isLoginReport), (App)IpMode.CODEC.fieldOf("queryMode").forGetter(Config::getQueryMode), (App)Action.CODEC.fieldOf("queryAction").forGetter(Config::getQueryAction), (App)Codec.BOOL.fieldOf("queryReport").forGetter(Config::isQueryReport), (App)IpMode.CODEC.fieldOf("pingMode").forGetter(Config::getPingMode), (App)Action.CODEC.fieldOf("pingAction").forGetter(Config::getPingAction), (App)Codec.BOOL.fieldOf("pingReport").forGetter(Config::isPingReport)).apply((Applicative)instance, Config::new));
    @Nullable
    protected String abuseIpdbKey;
    protected IpMode handshakeMode;
    protected Action handshakeAction;
    protected boolean handshakeReport;
    protected NameIpMode loginMode;
    protected Action loginAction;
    protected boolean loginReport;
    protected IpMode queryMode;
    protected Action queryAction;
    protected boolean queryReport;
    protected IpMode pingMode;
    protected Action pingAction;
    protected boolean pingReport;

    public Config(@Nullable String abuseIpdbKey, IpMode handshakeMode, Action handshakeAction, boolean handshakeReport, NameIpMode loginMode, Action loginAction, boolean loginReport, IpMode queryMode, Action queryAction, boolean queryReport, IpMode pingMode, Action pingAction, boolean pingReport) {
        this.abuseIpdbKey = abuseIpdbKey;
        this.handshakeMode = handshakeMode;
        this.handshakeAction = handshakeAction;
        this.handshakeReport = handshakeReport;
        this.loginMode = loginMode;
        this.loginAction = loginAction;
        this.loginReport = loginReport;
        this.queryMode = queryMode;
        this.queryAction = queryAction;
        this.queryReport = queryReport;
        this.pingMode = pingMode;
        this.pingAction = pingAction;
        this.pingReport = pingReport;
    }

    public Config() {
        this.abuseIpdbKey = null;
        this.handshakeMode = IpMode.MATCH_NONE;
        this.handshakeAction = Action.NOTHING;
        this.handshakeReport = false;
        this.loginMode = NameIpMode.MATCH_EITHER;
        this.loginAction = Action.TARPIT;
        this.loginReport = true;
        this.queryMode = IpMode.MATCH_NONE;
        this.queryAction = Action.DISCONNECT;
        this.queryReport = true;
        this.pingMode = IpMode.MATCH_NONE;
        this.pingAction = Action.DISCONNECT;
        this.pingReport = true;
    }

    public static Config load(File saveFile) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new FileReader(saveFile));){
            Config config = (Config)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)reader)).getOrThrow()).getFirst();
            return config;
        }
    }

    public static Config loadOrCreate(File saveFile) {
        if (!saveFile.exists()) {
            AntiScan.LOGGER.info("Creating a new ip blacklist.");
            return new Config();
        }
        try {
            return Config.load(saveFile);
        }
        catch (IOException e) {
            AntiScan.LOGGER.warn("Failed to load ip blacklist from save file. This is NOT a detrimental error.", (Throwable)e);
            return new Config();
        }
    }

    @Nullable
    public String getAbuseIpdbKey() {
        return this.abuseIpdbKey;
    }

    public Action getHandshakeAction() {
        return this.handshakeAction;
    }

    public IpMode getHandshakeMode() {
        return this.handshakeMode;
    }

    public Action getLoginAction() {
        return this.loginAction;
    }

    public NameIpMode getLoginMode() {
        return this.loginMode;
    }

    public Action getPingAction() {
        return this.pingAction;
    }

    public IpMode getPingMode() {
        return this.pingMode;
    }

    public Action getQueryAction() {
        return this.queryAction;
    }

    public IpMode getQueryMode() {
        return this.queryMode;
    }

    public boolean isHandshakeReport() {
        return this.handshakeReport;
    }

    public boolean isLoginReport() {
        return this.loginReport;
    }

    public boolean isPingReport() {
        return this.pingReport;
    }

    public boolean isQueryReport() {
        return this.queryReport;
    }

    protected void save(File file) throws IOException {
        Utils.saveToFile(this, file, CODEC);
    }

    public void setAbuseIpdbKey(@Nullable String abuseIpdbKey, @Nullable File saveFile) throws IOException {
        this.abuseIpdbKey = abuseIpdbKey;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setHandshakeAction(Action handshakeAction, @Nullable File saveFile) throws IOException {
        this.handshakeAction = handshakeAction;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setHandshakeMode(IpMode handshakeMode, @Nullable File saveFile) throws IOException {
        this.handshakeMode = handshakeMode;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setHandshakeReport(boolean handshakeReport, @Nullable File saveFile) throws IOException {
        this.handshakeReport = handshakeReport;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setLoginAction(Action loginAction, @Nullable File saveFile) throws IOException {
        this.loginAction = loginAction;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setLoginMode(NameIpMode loginMode, @Nullable File saveFile) throws IOException {
        this.loginMode = loginMode;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setLoginReport(boolean loginReport, @Nullable File saveFile) throws IOException {
        this.loginReport = loginReport;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setPingAction(Action pingAction, @Nullable File saveFile) throws IOException {
        this.pingAction = pingAction;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setPingMode(IpMode pingMode, @Nullable File saveFile) throws IOException {
        this.pingMode = pingMode;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setPingReport(boolean pingReport, @Nullable File saveFile) throws IOException {
        this.pingReport = pingReport;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setQueryAction(Action queryAction, @Nullable File saveFile) throws IOException {
        this.queryAction = queryAction;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setQueryMode(IpMode queryMode, @Nullable File saveFile) throws IOException {
        this.queryMode = queryMode;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public void setQueryReport(boolean queryReport, @Nullable File saveFile) throws IOException {
        this.queryReport = queryReport;
        if (saveFile != null) {
            this.save(saveFile);
        }
    }

    public static enum IpMode implements class_3542
    {
        MATCH_NONE("match_none"),
        MATCH_IP("match_ip"),
        MATCH_ALL("match_all");

        public static final Codec<IpMode> CODEC;
        private final String id;

        private IpMode(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }

        public static IpMode fromId(String id) {
            return switch (id) {
                case "match_ip" -> MATCH_IP;
                case "match_all" -> MATCH_ALL;
                case "match_none" -> MATCH_NONE;
                default -> throw new IllegalStateException("Unexpected value: " + id);
            };
        }

        static {
            CODEC = class_3542.method_28140(IpMode::values);
        }
    }

    public static enum Action implements class_3542
    {
        NOTHING("nothing"),
        DISCONNECT("disconnect"),
        TARPIT("tarpit");

        public static final Codec<Action> CODEC;
        private final String id;

        private Action(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }

        public static Action fromId(String id) {
            return switch (id) {
                case "disconnect" -> DISCONNECT;
                case "tarpit" -> TARPIT;
                case "nothing" -> NOTHING;
                default -> throw new IllegalStateException("Unexpected value: " + id);
            };
        }

        static {
            CODEC = class_3542.method_28140(Action::values);
        }
    }

    public static enum NameIpMode implements class_3542
    {
        MATCH_ALL("match_all"),
        MATCH_BOTH("match_both"),
        MATCH_IP("match_ip"),
        MATCH_NAME("match_name"),
        MATCH_EITHER("match_either"),
        MATCH_NONE("match_none");

        public static final Codec<NameIpMode> CODEC;
        private final String id;

        private NameIpMode(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }

        public static NameIpMode fromId(String id) {
            return switch (id) {
                case "match_all" -> MATCH_ALL;
                case "match_both" -> MATCH_BOTH;
                case "match_ip" -> MATCH_IP;
                case "match_name" -> MATCH_NAME;
                case "match_either" -> MATCH_EITHER;
                case "match_none" -> MATCH_NONE;
                default -> throw new IllegalStateException("Unexpected value: " + id);
            };
        }

        static {
            CODEC = class_3542.method_28140(NameIpMode::values);
        }
    }
}

