/*
 * Decompiled with CFR 0.152.
 */
package com.skycatdev.antiscan;

import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skycatdev.antiscan.AntiScan;
import com.skycatdev.antiscan.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class NameChecker {
    public static Codec<NameChecker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().xmap(list -> {
        ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
        set.addAll(list);
        return set;
    }, set -> set.stream().toList()).fieldOf("blacklist").forGetter(NameChecker::getBlacklist)).apply((Applicative)instance, NameChecker::new));
    protected final Set<String> blacklist;

    protected NameChecker(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    public static NameChecker load(File saveFile) throws IOException {
        AntiScan.LOGGER.info("Loading username blacklist.");
        try (JsonReader reader = new JsonReader((Reader)new FileReader(saveFile));){
            NameChecker nameChecker = (NameChecker)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)reader)).getOrThrow()).getFirst();
            return nameChecker;
        }
    }

    public static NameChecker loadOrCreate(File saveFile) {
        if (!saveFile.exists()) {
            AntiScan.LOGGER.info("Creating a new name blacklist.");
            return new NameChecker(ConcurrentHashMap.newKeySet());
        }
        try {
            return NameChecker.load(saveFile);
        }
        catch (IOException e) {
            AntiScan.LOGGER.warn("Failed to load name blacklist from save file. This is NOT a detrimental error.", (Throwable)e);
            return new NameChecker(ConcurrentHashMap.newKeySet());
        }
    }

    public boolean blacklist(String name) {
        try {
            return this.blacklist(name, null);
        }
        catch (IOException e) {
            AntiScan.LOGGER.warn("Failed to save name blacklist. This is NOT a fatal error.", (Throwable)e);
            return false;
        }
    }

    public boolean blacklist(String name, @Nullable File saveFile) throws IOException {
        boolean added = this.blacklist.add(name);
        if (added && saveFile != null) {
            this.save(saveFile);
        }
        return added;
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    public boolean isBlacklisted(String name) {
        return this.blacklist.contains(name);
    }

    protected void save(File file) throws IOException {
        Utils.saveToFile(this, file, CODEC);
    }

    public boolean unBlacklist(String name) {
        try {
            return this.unBlacklist(name, null);
        }
        catch (IOException e) {
            AntiScan.LOGGER.warn("Failed to save name blacklist, even though we weren't trying?", (Throwable)e);
            return false;
        }
    }

    public boolean unBlacklist(String name, @Nullable File saveFile) throws IOException {
        boolean removed = this.blacklist.remove(name);
        if (removed && saveFile != null) {
            this.save(saveFile);
        }
        return removed;
    }
}

