/*
 * Decompiled with CFR 0.152.
 */
package com.skycatdev.antiscan;

import com.skycatdev.antiscan.CommandHandler;
import com.skycatdev.antiscan.Config;
import com.skycatdev.antiscan.ConnectionChecker;
import com.skycatdev.antiscan.NameChecker;
import com.skycatdev.antiscan.Stats;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntiScan
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "antiscan";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"antiscan");
    public static final boolean IS_DEV_MODE = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("antiscan.json").toFile();
    public static final Config CONFIG = Config.loadOrCreate(CONFIG_FILE);
    public static final File CONNECTION_CHECKER_FILE = FabricLoader.getInstance().getGameDir().resolve("data").resolve("antiscan_ips.json").toFile();
    public static final ConnectionChecker CONNECTION_CHECKER = ConnectionChecker.loadOrCreate(CONNECTION_CHECKER_FILE);
    public static final File NAME_CHECKER_FILE = FabricLoader.getInstance().getGameDir().resolve("data").resolve("antiscan_names.json").toFile();
    public static final NameChecker NAME_CHECKER = NameChecker.loadOrCreate(NAME_CHECKER_FILE);
    public static final Timer BLACKLIST_UPDATER = new Timer("Antiscan Blacklist Updater", true);
    public static final File STATS_FILE = FabricLoader.getInstance().getGameDir().resolve("data").resolve("antiscan_stats.json").toFile();
    public static final Stats STATS = Stats.loadOrCreate(STATS_FILE);

    public void onInitializeServer() {
        CommandRegistrationCallback.EVENT.register((Object)new CommandHandler());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            try {
                STATS.save(STATS_FILE);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to save Antiscan stats. This is NOT a fatal error.");
            }
        });
    }

    static {
        if (!CONNECTION_CHECKER_FILE.getParentFile().exists()) {
            CONNECTION_CHECKER_FILE.getParentFile().mkdirs();
        }
        if (!NAME_CHECKER_FILE.getParentFile().exists()) {
            NAME_CHECKER_FILE.getParentFile().mkdirs();
        }
        if (!CONFIG_FILE.getParentFile().exists()) {
            CONFIG_FILE.getParentFile().mkdirs();
        }
        if (!STATS_FILE.getParentFile().exists()) {
            STATS_FILE.getParentFile().mkdirs();
        }
        BLACKLIST_UPDATER.schedule(new TimerTask(){

            @Override
            public void run() {
                CONNECTION_CHECKER.update(CONFIG.getBlacklistUpdateCooldown(), CONNECTION_CHECKER_FILE);
            }
        }, CONFIG.getBlacklistUpdateCooldown(), CONFIG.getBlacklistUpdateCooldown() + 10L);
    }
}

