/*
 * Decompiled with CFR 0.152.
 */
package com.skycatdev.antiscan;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.skycatdev.antiscan.AntiScan;
import com.skycatdev.antiscan.Config;
import com.skycatdev.antiscan.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_7157;

public class CommandHandler
implements CommandRegistrationCallback {
    public static final DynamicCommandExceptionType FAILED_TO_BLACKLIST = new DynamicCommandExceptionType(name -> () -> String.format("Failed to blacklist %s.", name));
    public static final DynamicCommandExceptionType FAILED_TO_UN_BLACKLIST = new DynamicCommandExceptionType(name -> () -> String.format("Failed to un-blacklist %s.", name));
    public static final SimpleCommandExceptionType FAILED_TO_SET_KEY = new SimpleCommandExceptionType(() -> "Failed to set key!");
    public static final SimpleCommandExceptionType FAILED_TO_SET_CONFIG = new SimpleCommandExceptionType(() -> "Failed to set config!");

    private static int blacklistIp(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String ip = StringArgumentType.getString(context, (String)"ip");
            if (AntiScan.CONNECTION_CHECKER.blacklist(ip, true, AntiScan.CONNECTION_CHECKER_FILE)) {
                ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Blacklisted %s.", ip)), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("%s was already blacklisted!", ip)), true);
            return 0;
        }
        catch (IOException e) {
            throw FAILED_TO_BLACKLIST.create((Object)"ip");
        }
    }

    private static int blacklistName(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String name = StringArgumentType.getString(context, (String)"name");
            if (AntiScan.NAME_CHECKER.blacklist(name, AntiScan.NAME_CHECKER_FILE)) {
                ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Blacklisted %s.", name)), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("%s was already blacklisted!", name)), true);
            return 0;
        }
        catch (IOException e) {
            throw FAILED_TO_BLACKLIST.create((Object)"name");
        }
    }

    private static int checkIp(CommandContext<class_2168> context) {
        String ip = StringArgumentType.getString(context, (String)"ip");
        if (AntiScan.CONNECTION_CHECKER.isBlacklisted(ip)) {
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("%s is blacklisted.", ip)), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("%s is not blacklisted.", ip)), false);
        return 0;
    }

    private static int checkName(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection profiles = class_2191.method_9330(context, (String)"name");
        int blacklisted = 0;
        for (GameProfile profile : profiles) {
            if (AntiScan.NAME_CHECKER.isBlacklisted(profile.getName())) {
                ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("%s is blacklisted.", profile.getName())), false);
                ++blacklisted;
                continue;
            }
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("%s is not blacklisted.", profile.getName())), false);
        }
        int finalBlacklisted = blacklisted;
        if (profiles.size() != 1) {
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("%d/%d are blacklisted.", finalBlacklisted, profiles.size())), false);
        }
        return finalBlacklisted;
    }

    private static int displayHandshakeAction(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Handshake action is %s.", AntiScan.CONFIG.getHandshakeAction().method_15434())), false);
        return 1;
    }

    private static int displayHandshakeMode(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Handshake mode is %s.", AntiScan.CONFIG.getHandshakeMode().method_15434())), false);
        return 1;
    }

    private static int displayHandshakeReport(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Reporting is %s.", AntiScan.CONFIG.isHandshakeReport() ? "on" : "off")), false);
        return 1;
    }

    private static int displayLoginAction(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Login action is %s.", AntiScan.CONFIG.getLoginAction().method_15434())), false);
        return 1;
    }

    private static int displayLoginMode(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Login mode is %s.", AntiScan.CONFIG.getLoginMode().method_15434())), false);
        return 1;
    }

    private static int displayLoginReport(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Reporting is %s.", AntiScan.CONFIG.isLoginReport() ? "on" : "off")), false);
        return 1;
    }

    private static int displayPingAction(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Ping action is %s.", AntiScan.CONFIG.getPingAction().method_15434())), false);
        return 1;
    }

    private static int displayPingMode(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Ping mode is %s.", AntiScan.CONFIG.getPingMode().method_15434())), false);
        return 1;
    }

    private static int displayPingReport(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Reporting is %s.", AntiScan.CONFIG.isPingReport() ? "on" : "off")), false);
        return 1;
    }

    private static int displayQueryAction(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Query action is %s.", AntiScan.CONFIG.getQueryAction().method_15434())), false);
        return 1;
    }

    private static int displayQueryMode(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Query mode is %s.", AntiScan.CONFIG.getQueryMode().method_15434())), false);
        return 1;
    }

    private static int displayQueryReport(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Reporting is %s.", AntiScan.CONFIG.isQueryReport() ? "on" : "off")), false);
        return 1;
    }

    private static int forceUpdateIpBlacklist(CommandContext<class_2168> context) {
        AntiScan.CONNECTION_CHECKER.updateNow(AntiScan.CONNECTION_CHECKER_FILE);
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("IP blacklist will be updated."), true);
        return 1;
    }

    private static int listAllBlacklistedIps(CommandContext<class_2168> context) {
        for (String string : AntiScan.CONNECTION_CHECKER.getManualBlacklist()) {
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(string), false);
        }
        int ips = AntiScan.CONNECTION_CHECKER.getManualBlacklist().size();
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("(%d IPs manually blacklisted)", ips)), false);
        for (String ip : AntiScan.CONNECTION_CHECKER.getBlacklistCache()) {
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(ip), false);
        }
        int n = AntiScan.CONNECTION_CHECKER.getBlacklistCache().size();
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("(%d IPs automatically blacklisted)", cached)), false);
        return ips + n;
    }

    private static int listBlacklistedIps(CommandContext<class_2168> context) {
        for (String ip : AntiScan.CONNECTION_CHECKER.getManualBlacklist()) {
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(ip), false);
        }
        int ips = AntiScan.CONNECTION_CHECKER.getManualBlacklist().size();
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("(%d IPs)", ips)), false);
        return ips;
    }

    private static int listBlacklistedNames(CommandContext<class_2168> context) {
        for (String name : AntiScan.NAME_CHECKER.getBlacklist()) {
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(name), false);
        }
        int names = AntiScan.NAME_CHECKER.getBlacklist().size();
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("(%d names)", names)), false);
        return names;
    }

    private static int displayLogActions(CommandContext<class_2168> context) {
        if (AntiScan.CONFIG.shouldLogActions()) {
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("Action logging is on."), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("Action logging is off."), false);
        return 0;
    }

    private static int setAbuseIpdbKey(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setAbuseIpdbKey(StringArgumentType.getString(context, (String)"key"), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_KEY.create();
        }
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("Set! Make sure to clear your command history (including the file!) or terminal."), false);
        return 1;
    }

    private static int setHandshakeAction(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setHandshakeAction(Config.Action.fromId(StringArgumentType.getString(context, (String)"action")), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayHandshakeAction(context);
        return 1;
    }

    private static int setHandshakeMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setHandshakeMode(Config.IpMode.fromId(StringArgumentType.getString(context, (String)"mode")), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayHandshakeMode(context);
        return 1;
    }

    private static int setHandshakeReport(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setHandshakeReport(BoolArgumentType.getBool(context, (String)"report"), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayHandshakeReport(context);
        return 1;
    }

    private static int setLoginAction(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setLoginAction(Config.Action.fromId(StringArgumentType.getString(context, (String)"action")), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayLoginAction(context);
        return 1;
    }

    private static int setLoginMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setLoginMode(Config.NameIpMode.fromId(StringArgumentType.getString(context, (String)"mode")), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayLoginMode(context);
        return 1;
    }

    private static int setLoginReport(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setLoginReport(BoolArgumentType.getBool(context, (String)"report"), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayLoginReport(context);
        return 1;
    }

    private static int setPingAction(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setPingAction(Config.Action.fromId(StringArgumentType.getString(context, (String)"action")), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayPingAction(context);
        return 1;
    }

    private static int setPingMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setPingMode(Config.IpMode.fromId(StringArgumentType.getString(context, (String)"mode")), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayPingMode(context);
        return 1;
    }

    private static int setPingReport(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setPingReport(BoolArgumentType.getBool(context, (String)"report"), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayPingReport(context);
        return 1;
    }

    private static int setQueryAction(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setQueryAction(Config.Action.fromId(StringArgumentType.getString(context, (String)"action")), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayQueryAction(context);
        return 1;
    }

    private static int setQueryMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setQueryMode(Config.IpMode.fromId(StringArgumentType.getString(context, (String)"mode")), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayQueryMode(context);
        return 1;
    }

    private static int setQueryReport(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setQueryReport(BoolArgumentType.getBool(context, (String)"report"), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayQueryReport(context);
        return 1;
    }

    private static int unBlacklistIp(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String ip = StringArgumentType.getString(context, (String)"ip");
            if (AntiScan.CONNECTION_CHECKER.unBlacklist(ip, true, AntiScan.CONNECTION_CHECKER_FILE)) {
                ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Removed %s from the blacklist!", ip)), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("%s was not blacklisted!", ip)), true);
            return 0;
        }
        catch (IOException e) {
            throw FAILED_TO_UN_BLACKLIST.create((Object)"ip");
        }
    }

    private static int unBlacklistName(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String name = StringArgumentType.getString(context, (String)"name");
            if (AntiScan.NAME_CHECKER.unBlacklist(name, AntiScan.NAME_CHECKER_FILE)) {
                ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Removed %s from the blacklist!", name)), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("%s was not blacklisted!", name)), true);
            return 0;
        }
        catch (IOException e) {
            throw FAILED_TO_UN_BLACKLIST.create((Object)"name");
        }
    }

    private static int updateIpBlacklist(CommandContext<class_2168> context) {
        AntiScan.CONNECTION_CHECKER.update(TimeUnit.HOURS.toMillis(5L), AntiScan.CONNECTION_CHECKER_FILE);
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("IP blacklist will be updated if it has not been updated in the last 5 hours. Add \"force\" to do it now."), true);
        return 1;
    }

    private static int setBlacklistUpdateCooldown(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setBlacklistUpdateCooldown(LongArgumentType.getLong(context, (String)"cooldown"), AntiScan.CONFIG_FILE);
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("Set cooldown!"), false);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        return 1;
    }

    private static int displayStats(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("Please wait..."), false);
        new Thread(() -> ((class_2168)context.getSource()).method_9226(() -> Utils.textOf(String.format("Reports sent: %d", AntiScan.STATS.getIpsReported())), false), "AntiScan Stat Reporting").start();
        return 1;
    }

    private static int displayLogReports(CommandContext<class_2168> context) {
        if (AntiScan.CONFIG.shouldLogReports()) {
            ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("Report logging is on."), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("Report logging is off."), false);
        return 0;
    }

    private static int reportIp(CommandContext<class_2168> context) {
        AntiScan.CONNECTION_CHECKER.report(StringArgumentType.getString(context, (String)"ip"), "Reported manually with AntiScan for Fabric", new int[]{14});
        ((class_2168)context.getSource()).method_9226(() -> Utils.textOf("Report sent."), true);
        return 1;
    }

    private static int setLogActions(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setLogActions(BoolArgumentType.getBool(context, (String)"log"), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayLogActions(context);
        return 1;
    }

    private static int setLogReports(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            AntiScan.CONFIG.setLogReports(BoolArgumentType.getBool(context, (String)"log"), AntiScan.CONFIG_FILE);
        }
        catch (IOException e) {
            throw FAILED_TO_SET_CONFIG.create();
        }
        CommandHandler.displayLogReports(context);
        return 1;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        SuggestionProvider actionSuggestionProvider = (context, builder) -> class_2172.method_9264(Arrays.stream(Config.Action.values()).map(Config.Action::method_15434), (SuggestionsBuilder)builder);
        SuggestionProvider ipModeSuggestionProvider = (context, builder) -> class_2172.method_9264(Arrays.stream(Config.IpMode.values()).map(Config.IpMode::method_15434), (SuggestionsBuilder)builder);
        SuggestionProvider nameIpModeSuggestionProvider = (context, builder) -> class_2172.method_9264(Arrays.stream(Config.NameIpMode.values()).map(Config.NameIpMode::method_15434), (SuggestionsBuilder)builder);
        LiteralCommandNode antiScan = ((LiteralArgumentBuilder)class_2170.method_9247((String)"antiscan").requires(Permissions.require((String)"antiscan", (int)3))).build();
        LiteralCommandNode ip = ((LiteralArgumentBuilder)class_2170.method_9247((String)"ip").requires(Permissions.require((String)"antiscan.ip", (int)3))).build();
        LiteralCommandNode ipBlacklist = ((LiteralArgumentBuilder)class_2170.method_9247((String)"blacklist").requires(Permissions.require((String)"antiscan.ip.blacklist", (int)3))).build();
        LiteralCommandNode ipBlacklistAdd = ((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(Permissions.require((String)"antiscan.ip.blacklist.add", (int)3))).build();
        ArgumentCommandNode ipBlacklistAddIp = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"ip", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.ip.blacklist.add", (int)3))).executes(CommandHandler::blacklistIp)).build();
        LiteralCommandNode ipBlacklistRemove = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(Permissions.require((String)"antiscan.ip.blacklist.remove", (int)3))).build();
        ArgumentCommandNode ipBlacklistRemoveIp = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"ip", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.ip.blacklist.remove", (int)3))).executes(CommandHandler::unBlacklistIp)).build();
        LiteralCommandNode ipBlacklistCheck = ((LiteralArgumentBuilder)class_2170.method_9247((String)"check").requires(Permissions.require((String)"antiscan.ip.blacklist.check", (int)3))).build();
        ArgumentCommandNode ipBlacklistCheckIp = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"ip", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.ip.blacklist.check", (int)3))).executes(CommandHandler::checkIp)).build();
        LiteralCommandNode ipBlacklistUpdate = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"update").requires(Permissions.require((String)"antiscan.ip.blacklist.update", (int)4))).executes(CommandHandler::updateIpBlacklist)).build();
        LiteralCommandNode ipBlacklistUpdateForce = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"force").requires(Permissions.require((String)"antiscan.ip.blacklist.update.force", (int)4))).executes(CommandHandler::forceUpdateIpBlacklist)).build();
        LiteralCommandNode ipBlacklistList = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"antiscan.ip.blacklist.list", (int)3))).executes(CommandHandler::listBlacklistedIps)).build();
        LiteralCommandNode ipBlacklistListAll = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"all").requires(Permissions.require((String)"antiscan.ip.blacklist.list.all", (int)3))).executes(CommandHandler::listAllBlacklistedIps)).build();
        LiteralCommandNode name = ((LiteralArgumentBuilder)class_2170.method_9247((String)"name").requires(Permissions.require((String)"antiscan.name", (int)3))).build();
        LiteralCommandNode nameBlacklist = ((LiteralArgumentBuilder)class_2170.method_9247((String)"blacklist").requires(Permissions.require((String)"antiscan.name.blacklist", (int)3))).build();
        LiteralCommandNode nameBlacklistAdd = ((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(Permissions.require((String)"antiscan.name.blacklist.add", (int)3))).build();
        ArgumentCommandNode nameBlacklistAddName = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.name.blacklist.add", (int)3))).executes(CommandHandler::blacklistName)).build();
        LiteralCommandNode nameBlacklistRemove = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(Permissions.require((String)"antiscan.name.blacklist.remove", (int)3))).build();
        ArgumentCommandNode nameBlacklistRemoveName = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.name.blacklist.remove", (int)3))).executes(CommandHandler::unBlacklistName)).build();
        LiteralCommandNode nameBlacklistCheck = ((LiteralArgumentBuilder)class_2170.method_9247((String)"check").requires(Permissions.require((String)"antiscan.name.blacklist.check", (int)3))).build();
        ArgumentCommandNode nameBlacklistCheckName = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)class_2191.method_9329()).requires(Permissions.require((String)"antiscan.name.blacklist.check", (int)3))).executes(CommandHandler::checkName)).build();
        LiteralCommandNode nameBlacklistList = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"antiscan.name.blacklist.list", (int)3))).executes(CommandHandler::listBlacklistedNames)).build();
        LiteralCommandNode config = ((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(Permissions.require((String)"antiscan.config", (int)4))).build();
        LiteralCommandNode configAbuseIpdbKey = ((LiteralArgumentBuilder)class_2170.method_9247((String)"abuseIpdbKey").requires(Permissions.require((String)"antiscan.config.abuseIpdbKey", (int)4))).build();
        ArgumentCommandNode configAbuseIpdbKeyKey = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.config.abuseIpdbKey", (int)4))).executes(CommandHandler::setAbuseIpdbKey)).build();
        LiteralCommandNode configHandshake = ((LiteralArgumentBuilder)class_2170.method_9247((String)"handshake").requires(Permissions.require((String)"antiscan.config.handshake", (int)4))).build();
        LiteralCommandNode configHandshakeMode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mode").requires(Permissions.require((String)"antiscan.config.handshake.mode", (int)4))).executes(CommandHandler::displayHandshakeMode)).build();
        ArgumentCommandNode configHandshakeModeMode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.config.handshake.mode.set", (int)4))).suggests(ipModeSuggestionProvider).executes(CommandHandler::setHandshakeMode)).build();
        LiteralCommandNode configHandshakeAction = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"action").requires(Permissions.require((String)"antiscan.config.handshake.action", (int)4))).executes(CommandHandler::displayHandshakeAction)).build();
        ArgumentCommandNode configHandshakeActionAction = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.config.handshake.action.set", (int)4))).suggests(actionSuggestionProvider).executes(CommandHandler::setHandshakeAction)).build();
        LiteralCommandNode configHandshakeReport = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"report").requires(Permissions.require((String)"antiscan.config.handshake.report", (int)4))).executes(CommandHandler::displayHandshakeReport)).build();
        ArgumentCommandNode configHandshakeReportReport = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"report", (ArgumentType)BoolArgumentType.bool()).requires(Permissions.require((String)"antiscan.config.handshake.report.set", (int)4))).executes(CommandHandler::setHandshakeReport)).build();
        LiteralCommandNode configLogin = ((LiteralArgumentBuilder)class_2170.method_9247((String)"login").requires(Permissions.require((String)"antiscan.config.login", (int)4))).build();
        LiteralCommandNode configLoginMode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mode").requires(Permissions.require((String)"antiscan.config.login.mode", (int)4))).executes(CommandHandler::displayLoginMode)).build();
        ArgumentCommandNode configLoginModeMode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.config.login.mode.set", (int)4))).suggests(nameIpModeSuggestionProvider).executes(CommandHandler::setLoginMode)).build();
        LiteralCommandNode configLoginAction = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"action").requires(Permissions.require((String)"antiscan.config.login.action", (int)4))).executes(CommandHandler::displayLoginAction)).build();
        ArgumentCommandNode configLoginActionAction = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.config.login.action.set", (int)4))).suggests(actionSuggestionProvider).executes(CommandHandler::setLoginAction)).build();
        LiteralCommandNode configLogReport = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"report").requires(Permissions.require((String)"antiscan.config.login.report", (int)4))).executes(CommandHandler::displayLoginReport)).build();
        ArgumentCommandNode configLogReportReport = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"report", (ArgumentType)BoolArgumentType.bool()).requires(Permissions.require((String)"antiscan.config.login.report.set", (int)4))).executes(CommandHandler::setLoginReport)).build();
        LiteralCommandNode configPing = ((LiteralArgumentBuilder)class_2170.method_9247((String)"ping").requires(Permissions.require((String)"antiscan.config.ping", (int)4))).build();
        LiteralCommandNode configPingMode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mode").requires(Permissions.require((String)"antiscan.config.ping.mode", (int)4))).executes(CommandHandler::displayPingMode)).build();
        ArgumentCommandNode configPingModeMode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.config.ping.mode.set", (int)4))).suggests(ipModeSuggestionProvider).executes(CommandHandler::setPingMode)).build();
        LiteralCommandNode configPingAction = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"action").requires(Permissions.require((String)"antiscan.config.ping.action", (int)4))).executes(CommandHandler::displayPingAction)).build();
        ArgumentCommandNode configPingActionAction = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.config.ping.action.set", (int)4))).suggests(actionSuggestionProvider).executes(CommandHandler::setPingAction)).build();
        LiteralCommandNode configPingReport = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"report").requires(Permissions.require((String)"antiscan.config.ping.report", (int)4))).executes(CommandHandler::displayPingReport)).build();
        ArgumentCommandNode configPingReportReport = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"report", (ArgumentType)BoolArgumentType.bool()).requires(Permissions.require((String)"antiscan.config.ping.report.set", (int)4))).executes(CommandHandler::setPingReport)).build();
        LiteralCommandNode configQuery = ((LiteralArgumentBuilder)class_2170.method_9247((String)"query").requires(Permissions.require((String)"antiscan.config.query", (int)4))).build();
        LiteralCommandNode configQueryMode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mode").requires(Permissions.require((String)"antiscan.config.query.mode", (int)4))).executes(CommandHandler::displayQueryMode)).build();
        ArgumentCommandNode configQueryModeMode = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.config.query.mode.set", (int)4))).suggests(ipModeSuggestionProvider).executes(CommandHandler::setQueryMode)).build();
        LiteralCommandNode configQueryAction = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"action").requires(Permissions.require((String)"antiscan.config.query.action", (int)4))).executes(CommandHandler::displayQueryAction)).build();
        ArgumentCommandNode configQueryActionAction = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"action", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.config.query.action.set", (int)4))).suggests(actionSuggestionProvider).executes(CommandHandler::setQueryAction)).build();
        LiteralCommandNode configQueryReport = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"report").requires(Permissions.require((String)"antiscan.config.query.report", (int)4))).executes(CommandHandler::displayQueryReport)).build();
        ArgumentCommandNode configQueryReportReport = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"report", (ArgumentType)BoolArgumentType.bool()).requires(Permissions.require((String)"antiscan.config.query.report.set", (int)4))).executes(CommandHandler::setQueryReport)).build();
        LiteralCommandNode configBlacklistUpdateCooldown = ((LiteralArgumentBuilder)class_2170.method_9247((String)"blacklistUpdateCooldown").requires(Permissions.require((String)"antiscan.config.blacklistUpdateCooldown", (int)4))).build();
        ArgumentCommandNode configBlacklistUpdateCooldownCooldown = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"milliseconds", (ArgumentType)LongArgumentType.longArg((long)1L)).requires(Permissions.require((String)"antiscan.config.blacklistUpdateCooldown", (int)4))).executes(CommandHandler::setBlacklistUpdateCooldown)).build();
        LiteralCommandNode configLog = ((LiteralArgumentBuilder)class_2170.method_9247((String)"log").requires(Permissions.require((String)"antiscan.config.log", (int)4))).build();
        LiteralCommandNode configLogReports = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reports").requires(Permissions.require((String)"antiscan.config.log.reports", (int)4))).executes(CommandHandler::displayLogReports)).build();
        ArgumentCommandNode configLogReportsLog = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"log", (ArgumentType)BoolArgumentType.bool()).requires(Permissions.require((String)"antiscan.config.log.reports.set", (int)4))).executes(CommandHandler::setLogReports)).build();
        LiteralCommandNode configLogActions = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"actions").requires(Permissions.require((String)"antiscan.config.log.actions", (int)4))).executes(CommandHandler::displayLogActions)).build();
        ArgumentCommandNode configLogActionsLog = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"log", (ArgumentType)BoolArgumentType.bool()).requires(Permissions.require((String)"antiscan.config.log.actions.set", (int)4))).executes(CommandHandler::setLogActions)).build();
        LiteralCommandNode report = ((LiteralArgumentBuilder)class_2170.method_9247((String)"report").requires(Permissions.require((String)"antiscan.report", (int)4))).build();
        ArgumentCommandNode reportIp = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"ip", (ArgumentType)StringArgumentType.string()).requires(Permissions.require((String)"antiscan.report", (int)4))).executes(CommandHandler::reportIp)).build();
        LiteralCommandNode stats = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").requires(Permissions.require((String)"antiscan.stats", (int)3))).executes(CommandHandler::displayStats)).build();
        dispatcher.getRoot().addChild((CommandNode)antiScan);
        antiScan.addChild((CommandNode)ip);
        ip.addChild((CommandNode)ipBlacklist);
        ipBlacklist.addChild((CommandNode)ipBlacklistAdd);
        ipBlacklistAdd.addChild((CommandNode)ipBlacklistAddIp);
        ipBlacklist.addChild((CommandNode)ipBlacklistRemove);
        ipBlacklistRemove.addChild((CommandNode)ipBlacklistRemoveIp);
        ipBlacklist.addChild((CommandNode)ipBlacklistCheck);
        ipBlacklistCheck.addChild((CommandNode)ipBlacklistCheckIp);
        ipBlacklist.addChild((CommandNode)ipBlacklistUpdate);
        ipBlacklistUpdate.addChild((CommandNode)ipBlacklistUpdateForce);
        ipBlacklist.addChild((CommandNode)ipBlacklistList);
        ipBlacklistList.addChild((CommandNode)ipBlacklistListAll);
        antiScan.addChild((CommandNode)name);
        name.addChild((CommandNode)nameBlacklist);
        nameBlacklist.addChild((CommandNode)nameBlacklistAdd);
        nameBlacklistAdd.addChild((CommandNode)nameBlacklistAddName);
        nameBlacklist.addChild((CommandNode)nameBlacklistRemove);
        nameBlacklistRemove.addChild((CommandNode)nameBlacklistRemoveName);
        nameBlacklist.addChild((CommandNode)nameBlacklistCheck);
        nameBlacklistCheck.addChild((CommandNode)nameBlacklistCheckName);
        nameBlacklist.addChild((CommandNode)nameBlacklistList);
        antiScan.addChild((CommandNode)config);
        config.addChild((CommandNode)configAbuseIpdbKey);
        configAbuseIpdbKey.addChild((CommandNode)configAbuseIpdbKeyKey);
        config.addChild((CommandNode)configHandshake);
        configHandshake.addChild((CommandNode)configHandshakeAction);
        configHandshakeAction.addChild((CommandNode)configHandshakeActionAction);
        configHandshake.addChild((CommandNode)configHandshakeMode);
        configHandshakeMode.addChild((CommandNode)configHandshakeModeMode);
        configHandshake.addChild((CommandNode)configHandshakeReport);
        configHandshakeReport.addChild((CommandNode)configHandshakeReportReport);
        config.addChild((CommandNode)configLogin);
        configLogin.addChild((CommandNode)configLoginAction);
        configLoginAction.addChild((CommandNode)configLoginActionAction);
        configLogin.addChild((CommandNode)configLoginMode);
        configLoginMode.addChild((CommandNode)configLoginModeMode);
        configLogin.addChild((CommandNode)configLogReport);
        configLogReport.addChild((CommandNode)configLogReportReport);
        config.addChild((CommandNode)configQuery);
        configQuery.addChild((CommandNode)configQueryAction);
        configQueryAction.addChild((CommandNode)configQueryActionAction);
        configQuery.addChild((CommandNode)configQueryMode);
        configQueryMode.addChild((CommandNode)configQueryModeMode);
        configQuery.addChild((CommandNode)configQueryReport);
        configQueryReport.addChild((CommandNode)configQueryReportReport);
        config.addChild((CommandNode)configPing);
        configPing.addChild((CommandNode)configPingAction);
        configPingAction.addChild((CommandNode)configPingActionAction);
        configPing.addChild((CommandNode)configPingMode);
        configPingMode.addChild((CommandNode)configPingModeMode);
        configPing.addChild((CommandNode)configPingReport);
        configPingReport.addChild((CommandNode)configPingReportReport);
        config.addChild((CommandNode)configBlacklistUpdateCooldown);
        configBlacklistUpdateCooldown.addChild((CommandNode)configBlacklistUpdateCooldownCooldown);
        config.addChild((CommandNode)configLog);
        configLog.addChild((CommandNode)configLogReports);
        configLogReports.addChild((CommandNode)configLogReportsLog);
        configLog.addChild((CommandNode)configLogActions);
        configLogActions.addChild((CommandNode)configLogActionsLog);
        antiScan.addChild((CommandNode)report);
        report.addChild((CommandNode)reportIp);
        antiScan.addChild((CommandNode)stats);
    }
}

