/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.unusualfurniture.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.toopa.unusualfurniture.UnusualFurnitureMod;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation2Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation3Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation4Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation5Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation6Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation7Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotation8Procedure;
import net.toopa.unusualfurniture.procedures.SetTableItemRotationProcedure;
import net.toopa.unusualfurniture.procedures.SetTableRotationItem1Procedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record TableGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TableGUISlotMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"unusual_furniture", (String)"table_gui_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TableGUISlotMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }, buffer -> new TableGUISlotMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<TableGUISlotMessage> type() {
        return TYPE;
    }

    public static void handleData(TableGUISlotMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> TableGUISlotMessage.handleSlotAction(context.player(), message.slotID, message.changeType, message.meta, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 0 && changeType == 0) {
            SetTableItemRotationProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 1 && changeType == 0) {
            SetTableRotationItem1Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 2 && changeType == 0) {
            SetTableItemRotation2Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 3 && changeType == 0) {
            SetTableItemRotation3Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 4 && changeType == 0) {
            SetTableItemRotation4Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 5 && changeType == 0) {
            SetTableItemRotation5Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 6 && changeType == 0) {
            SetTableItemRotation6Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 7 && changeType == 0) {
            SetTableItemRotation7Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 8 && changeType == 0) {
            SetTableItemRotation8Procedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        UnusualFurnitureMod.addNetworkMessage(TYPE, STREAM_CODEC, TableGUISlotMessage::handleData);
    }
}

