/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper;

import dev.spiritstudios.snapper.gui.screen.ScreenshotScreen;
import dev.spiritstudios.snapper.gui.screen.ScreenshotViewerScreen;
import dev.spiritstudios.snapper.gui.toast.SnapperToast;
import dev.spiritstudios.snapper.util.DynamicTexture;
import dev.spiritstudios.snapper.util.ScreenshotActions;
import dev.spiritstudios.snapper.util.SnapperUtil;
import dev.spiritstudios.specter.api.core.client.event.ClientKeybindEvents;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class SnapperKeybindings {
    public static final class_304 PANORAMA_KEY = new class_304("key.snapper.panorama", 297, "key.categories.snapper");
    public static final class_304 RECENT_SCREENSHOT_KEY = new class_304("key.snapper.recent", 79, "key.categories.snapper");
    public static final class_304 SCREENSHOT_MENU_KEY = new class_304("key.snapper.screenshot_menu", 86, "key.categories.snapper");

    public static void init() {
        KeyBindingHelper.registerKeyBinding((class_304)PANORAMA_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)RECENT_SCREENSHOT_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)SCREENSHOT_MENU_KEY);
        ClientKeybindEvents.pressed((class_304)SCREENSHOT_MENU_KEY).register(client -> client.method_1507((class_437)new ScreenshotScreen(client.field_1755)));
        ClientKeybindEvents.pressed((class_304)PANORAMA_KEY).register(SnapperKeybindings::takePanorama);
        ClientKeybindEvents.pressed((class_304)RECENT_SCREENSHOT_KEY).register(SnapperKeybindings::openRecentScreenshot);
    }

    private static void takePanorama(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        client.method_35698(client.field_1697);
        SnapperUtil.toast(SnapperToast.Type.PANORAMA, (class_2561)class_2561.method_43471((String)"toast.snapper.panorama.created"), (class_2561)class_2561.method_43469((String)"toast.snapper.panorama.created.description", (Object[])new Object[]{SCREENSHOT_MENU_KEY.method_16007()}));
    }

    private static void openRecentScreenshot(class_310 client) {
        List<Path> screenshots = ScreenshotActions.getScreenshots();
        if (screenshots.isEmpty()) {
            SnapperUtil.toast(SnapperToast.Type.SCREENSHOT, (class_2561)class_2561.method_43471((String)"toast.snapper.screenshot.recent.failure"), (class_2561)class_2561.method_43471((String)"toast.snapper.screenshot.recent.failure.not_exist"));
            return;
        }
        Path latestPath = screenshots.getFirst();
        DynamicTexture.createScreenshot(client.method_1531(), latestPath).ifPresentOrElse(image -> {
            client.method_1507((class_437)new ScreenshotViewerScreen((DynamicTexture)image, latestPath, client.field_1755));
            image.load();
        }, () -> SnapperUtil.toast(SnapperToast.Type.DENY, (class_2561)class_2561.method_43471((String)"toast.snapper.screenshot.recent.failure"), (class_2561)class_2561.method_43471((String)"toast.snapper.screenshot.recent.failure.generic")));
    }
}

