/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.gui.screen;

import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.util.DynamicCubemapTexture;
import dev.spiritstudios.snapper.util.SafeFiles;
import dev.spiritstudios.snapper.util.SnapperUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10537;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_751;
import net.minecraft.class_766;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PanoramaViewerScreen
extends class_437 {
    protected static final class_2960 ID = Snapper.id("screenshots/panorama");
    protected static final class_751 PANORAMA_RENDERER = new class_751(ID);
    private final class_766 rotatingPanoramaRenderer = new class_766(PANORAMA_RENDERER);
    private final DynamicCubemapTexture texture;
    private final String title;
    private final class_437 parent;

    protected PanoramaViewerScreen(String title, class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"menu.snapper.viewer_menu"));
        this.title = title;
        this.parent = parent;
        this.field_22787 = class_310.method_1551();
        assert (this.field_22787 != null);
        this.texture = this.getTexture();
        if (this.texture != null) {
            this.field_22787.method_1531().method_65876(ID, (class_10537)this.texture);
        }
    }

    @Nullable
    private DynamicCubemapTexture getTexture() {
        DynamicCubemapTexture dynamicCubemapTexture;
        block10: {
            assert (this.field_22787 != null);
            Path panoramaDir = SnapperUtil.getConfiguredScreenshotDirectory().resolve("panorama");
            if (!SnapperUtil.panoramaPresent(panoramaDir)) {
                return null;
            }
            Stream<Path> stream = Files.list(panoramaDir);
            try {
                DynamicCubemapTexture dynamicCubemapTexture2 = dynamicCubemapTexture = stream.allMatch(path -> {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        return false;
                    }
                    return SafeFiles.isContentType(path, "image/png", ".png");
                }) ? (DynamicCubemapTexture)DynamicCubemapTexture.createPanorama(ID, panoramaDir).orElse(null) : null;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException e) {
                    Snapper.LOGGER.error("Failed to list the contents of directory", (Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return dynamicCubemapTexture;
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        if (this.texture != null) {
            this.field_22787.method_1531().method_4615(ID);
            this.texture.close();
        }
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        assert (this.field_22787 != null);
        if (this.texture == null) {
            Snapper.LOGGER.error("No panorama found");
            this.method_25419();
            return;
        }
        Path panoramaPath = Path.of(this.field_22787.field_1697.getPath(), "screenshots", "panorama");
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.folder"), button -> class_156.method_668().method_60932(panoramaPath)).method_46434(this.field_22789 / 2 - 150 - 4, this.field_22790 - 32, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 32, 150, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.rotatingPanoramaRenderer.method_3317(context, this.field_22789, this.field_22790, true);
        context.method_25300(this.field_22793, this.title, this.field_22789 / 2, 20, -1);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }
}

