/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.gui.screen;

import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.SnapperConfig;
import dev.spiritstudios.snapper.gui.screen.PanoramaViewerScreen;
import dev.spiritstudios.snapper.gui.screen.ScreenshotRenameScreen;
import dev.spiritstudios.snapper.gui.screen.ScreenshotViewerScreen;
import dev.spiritstudios.snapper.gui.widget.ScreenshotListWidget;
import dev.spiritstudios.snapper.util.ScreenshotActions;
import dev.spiritstudios.snapper.util.SnapperUtil;
import dev.spiritstudios.snapper.util.uploading.ScreenshotUploading;
import dev.spiritstudios.specter.api.config.client.RootConfigScreen;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7843;
import net.minecraft.class_7849;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8662;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ScreenshotScreen
extends class_437 {
    private static final class_2960 PANORAMA_BUTTON_ICON = Snapper.id("screenshots/panorama");
    private static final class_2960 PANORAMA_BUTTON_DISABLED_ICON = Snapper.id("screenshots/panorama_disabled");
    private static final class_2960 SETTINGS_ICON = Snapper.id("screenshots/settings");
    private static final class_2960 VIEW_MODE_ICON_LIST = Snapper.id("screenshots/show_list");
    private static final class_2960 VIEW_MODE_ICON_GRID = Snapper.id("screenshots/show_grid");
    private final class_437 parent;
    private final boolean isOffline;
    private ScreenshotListWidget screenshotList;
    private class_4185 deleteButton;
    private class_4185 renameButton;
    private class_4185 viewButton;
    private class_4185 copyButton;
    private class_4185 openButton;
    private class_4185 uploadButton;
    private class_8662 viewModeButton;
    @Nullable
    private ScreenshotListWidget.ScreenshotEntry selectedScreenshot = null;
    private boolean showGrid;

    public ScreenshotScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"menu.snapper.screenshot_menu"));
        this.parent = parent;
        this.showGrid = ((ViewMode)((Object)SnapperConfig.INSTANCE.viewMode.get())).equals((Object)ViewMode.GRID);
        this.isOffline = SnapperUtil.isOfflineAccount();
    }

    protected void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        this.screenshotList = (ScreenshotListWidget)this.method_37063((class_364)new ScreenshotListWidget(this.field_22787, this.field_22789, this.field_22790 - 48 - 68, 48, 36, this.screenshotList, this));
        int secondRowButtonWidth = 100;
        class_4185 folderButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.folder"), button -> class_156.method_668().method_60932(SnapperUtil.getConfiguredScreenshotDirectory())).method_46432(secondRowButtonWidth).method_46431());
        this.openButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.open"), button -> {
            if (this.selectedScreenshot != null) {
                class_156.method_668().method_60932(this.selectedScreenshot.icon.getPath());
            }
        }).method_46432(secondRowButtonWidth).method_46431());
        class_4185 doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(secondRowButtonWidth).method_46431());
        int firstRowButtonWidth = 58;
        this.deleteButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.delete"), button -> {
            if (this.selectedScreenshot != null) {
                ScreenshotActions.deleteScreenshot(this.selectedScreenshot.icon.getPath(), this);
            }
        }).method_46432(firstRowButtonWidth).method_46431());
        this.renameButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.rename"), button -> {
            if (this.selectedScreenshot != null) {
                this.field_22787.method_1507((class_437)new ScreenshotRenameScreen(this.selectedScreenshot.icon.getPath(), this));
            }
        }).method_46432(firstRowButtonWidth).method_46431());
        this.copyButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.copy"), button -> {
            if (this.selectedScreenshot != null) {
                Snapper.getPlatformHelper().copyScreenshot(this.selectedScreenshot.icon.getPath());
            }
        }).method_46432(firstRowButtonWidth).method_46431());
        this.viewButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.view"), button -> {
            if (this.selectedScreenshot != null) {
                this.field_22787.method_1507((class_437)new ScreenshotViewerScreen(this.selectedScreenshot.icon, this.selectedScreenshot.icon.getPath(), this.selectedScreenshot.screenParent));
            }
        }).method_46432(firstRowButtonWidth).method_46431());
        this.uploadButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.upload"), button -> {
            if (this.selectedScreenshot == null) {
                return;
            }
            button.field_22763 = false;
            ScreenshotUploading.upload(this.selectedScreenshot.icon.getPath()).thenRun(() -> {
                button.field_22763 = true;
            });
        }).method_46432(firstRowButtonWidth).method_46431());
        if (this.isOffline) {
            this.uploadButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"button.snapper.upload.tooltip")));
        }
        class_8667 verticalButtonLayout = class_8667.method_52741().method_52735(4);
        class_7849 firstRowWidget = (class_7849)verticalButtonLayout.method_52736((class_8021)new class_7849(308, 20, class_7849.class_7851.field_40789));
        firstRowWidget.method_46495((class_8021)this.deleteButton);
        firstRowWidget.method_46495((class_8021)this.renameButton);
        firstRowWidget.method_46495((class_8021)this.copyButton);
        firstRowWidget.method_46495((class_8021)this.viewButton);
        firstRowWidget.method_46495((class_8021)this.uploadButton);
        class_7849 secondRowWidget = (class_7849)verticalButtonLayout.method_52736((class_8021)new class_7849(308, 20, class_7849.class_7851.field_40789));
        secondRowWidget.method_46495((class_8021)folderButton);
        secondRowWidget.method_46495((class_8021)this.openButton);
        secondRowWidget.method_46495((class_8021)doneButton);
        verticalButtonLayout.method_48222();
        class_7843.method_46442((class_8021)verticalButtonLayout, (int)0, (int)(this.field_22790 - 66), (int)this.field_22789, (int)64);
        class_8662 settingsButton = (class_8662)this.method_37063((class_364)class_8662.method_52723((class_2561)class_2561.method_43471((String)"config.snapper.snapper.title"), button -> this.field_22787.method_1507((class_437)new RootConfigScreen(SnapperConfig.HOLDER, (class_437)new ScreenshotScreen(this.parent))), (boolean)true).method_52725(20).method_52727(SETTINGS_ICON, 15, 15).method_52724());
        settingsButton.method_48229(this.field_22789 / 2 - 178, this.field_22790 - 32);
        this.viewModeButton = (class_8662)this.method_37063((class_364)class_8662.method_52723((class_2561)class_2561.method_43471((String)"config.snapper.snapper.viewMode"), button -> this.toggleGrid(), (boolean)true).method_52725(20).method_52727(this.showGrid ? VIEW_MODE_ICON_LIST : VIEW_MODE_ICON_GRID, 15, 15).method_52724());
        this.viewModeButton.method_48229(this.field_22789 / 2 - 178, this.field_22790 - 56);
        Path panoramaDir = SnapperUtil.getConfiguredScreenshotDirectory().resolve("panorama");
        boolean hasPanorama = SnapperUtil.panoramaPresent(panoramaDir);
        class_8662 panoramaButton = (class_8662)this.method_37063((class_364)class_8662.method_52723((class_2561)class_2561.method_43471((String)"button.snapper.screenshots"), button -> this.field_22787.method_1507((class_437)new PanoramaViewerScreen(class_2561.method_43471((String)"menu.snapper.panorama").getString(), this)), (boolean)true).method_52725(20).method_52727(hasPanorama ? PANORAMA_BUTTON_ICON : PANORAMA_BUTTON_DISABLED_ICON, 15, 15).method_52724());
        panoramaButton.field_22763 = hasPanorama;
        panoramaButton.method_48229(this.field_22789 / 2 + 158, this.field_22790 - 32);
        panoramaButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)(hasPanorama ? "button.snapper.panorama.tooltip" : "text.snapper.panorama_encourage"))));
        this.imageSelected(this.selectedScreenshot);
    }

    public void imageSelected(@Nullable ScreenshotListWidget.ScreenshotEntry screenshot) {
        boolean hasScreenshot;
        this.copyButton.field_22763 = hasScreenshot = screenshot != null;
        this.deleteButton.field_22763 = hasScreenshot;
        this.openButton.field_22763 = hasScreenshot;
        this.renameButton.field_22763 = hasScreenshot;
        this.viewButton.field_22763 = hasScreenshot;
        this.selectedScreenshot = screenshot;
        this.uploadButton.field_22763 = !this.isOffline && hasScreenshot;
    }

    public void toggleGrid() {
        this.screenshotList.toggleGrid();
        this.screenshotList.method_65506();
        this.showGrid = !this.showGrid;
        this.method_37066((class_364)this.viewModeButton);
        this.viewModeButton = (class_8662)this.method_37063((class_364)class_8662.method_52723((class_2561)class_2561.method_43471((String)"config.snapper.snapper.viewMode"), button -> this.toggleGrid(), (boolean)true).method_52725(20).method_52727(this.showGrid ? VIEW_MODE_ICON_LIST : VIEW_MODE_ICON_GRID, 15, 15).method_52724());
        this.viewModeButton.method_48229(this.field_22789 / 2 - 178, this.field_22790 - 56);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_22787 == null) {
            return false;
        }
        if (keyCode == 294) {
            this.field_22787.method_1507((class_437)new ScreenshotScreen(this.parent));
            return true;
        }
        if (this.selectedScreenshot == null) {
            return false;
        }
        if ((modifiers & 2) != 0 && keyCode == 67) {
            Snapper.getPlatformHelper().copyScreenshot(this.selectedScreenshot.icon.getPath());
            return true;
        }
        if (keyCode == 257) {
            this.field_22787.method_1507((class_437)new ScreenshotViewerScreen(this.selectedScreenshot.icon, this.selectedScreenshot.icon.getPath(), this));
            return true;
        }
        return false;
    }

    public void method_25419() {
        SnapperConfig.HOLDER.save();
        super.method_25419();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, -1);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ViewMode {
        LIST,
        GRID;

    }
}

