/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.gui.screen;

import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.gui.screen.ScreenshotRenameScreen;
import dev.spiritstudios.snapper.util.DynamicTexture;
import dev.spiritstudios.snapper.util.ScreenshotActions;
import dev.spiritstudios.snapper.util.SnapperUtil;
import dev.spiritstudios.snapper.util.uploading.ScreenshotUploading;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7843;
import net.minecraft.class_7849;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ScreenshotViewerScreen
extends class_437 {
    private static final class_2960 MENU_DECOR_BACKGROUND_TEXTURE = class_2960.method_60656((String)"textures/gui/menu_list_background.png");
    private static final class_2960 INWORLD_MENU_DECOR_BACKGROUND_TEXTURE = class_2960.method_60656((String)"textures/gui/inworld_menu_list_background.png");
    private final class_310 client = class_310.method_1551();
    private final DynamicTexture image;
    private final String title;
    private final int imageWidth;
    private final int imageHeight;
    private final class_437 parent;
    private final Path screenshot;
    @Nullable
    private final List<Path> screenshots;
    private final int screenshotIndex;
    private final Path iconPath;

    public ScreenshotViewerScreen(DynamicTexture icon, Path screenshot, class_437 parent) {
        this(icon, screenshot, parent, null);
    }

    public ScreenshotViewerScreen(DynamicTexture icon, Path iconPath, class_437 parent, @Nullable List<Path> screenshots) {
        super((class_2561)class_2561.method_43471((String)"menu.snapper.viewer_menu"));
        this.parent = parent;
        this.iconPath = iconPath;
        BufferedImage image = null;
        try (InputStream stream = Files.newInputStream(iconPath, new OpenOption[0]);){
            image = ImageIO.read(stream);
        }
        catch (IOException e) {
            Snapper.LOGGER.error("Failed to read image.", (Throwable)e);
            this.client.method_1507(parent);
        }
        this.image = icon;
        this.title = iconPath.getFileName().toString();
        this.imageWidth = image != null ? image.getWidth() : 0;
        this.imageHeight = image != null ? image.getHeight() : 0;
        this.screenshot = iconPath;
        this.screenshots = screenshots;
        this.screenshotIndex = this.screenshots != null ? this.screenshots.indexOf(this.screenshot) : -1;
    }

    public void method_25419() {
        this.client.method_1507(this.parent);
    }

    protected void method_25426() {
        int firstRowButtonWidth = 74;
        class_4185 folderButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.folder"), button -> class_156.method_668().method_672(new File(this.client.field_1697, "screenshots"))).method_46432(100).method_46431());
        class_4185 openButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.open"), button -> class_156.method_668().method_60932(this.iconPath)).method_46432(100).method_46431());
        class_4185 doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(100).method_46431());
        class_4185 deleteButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.delete"), button -> ScreenshotActions.deleteScreenshot(this.screenshot, this.parent)).method_46432(firstRowButtonWidth).method_46431());
        class_4185 renameButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.rename"), button -> {
            if (this.screenshot != null) {
                this.client.method_1507((class_437)new ScreenshotRenameScreen(this.screenshot, this.parent));
            }
        }).method_46432(firstRowButtonWidth).method_46431());
        class_4185 copyButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.copy"), button -> Snapper.getPlatformHelper().copyScreenshot(this.screenshot)).method_46432(firstRowButtonWidth).method_46431());
        class_4185 uploadButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.snapper.upload"), button -> {
            button.field_22763 = false;
            ScreenshotUploading.upload(this.iconPath).thenRun(() -> {
                button.field_22763 = true;
            });
        }).method_46432(firstRowButtonWidth).method_46431());
        if (SnapperUtil.isOfflineAccount()) {
            uploadButton.field_22763 = false;
            uploadButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"button.snapper.upload.tooltip")));
        }
        class_8667 verticalButtonLayout = class_8667.method_52741().method_52735(4);
        class_7849 firstRowWidget = (class_7849)verticalButtonLayout.method_52736((class_8021)new class_7849(308, 20, class_7849.class_7851.field_40789));
        firstRowWidget.method_46495((class_8021)deleteButton);
        firstRowWidget.method_46495((class_8021)renameButton);
        firstRowWidget.method_46495((class_8021)copyButton);
        firstRowWidget.method_46495((class_8021)uploadButton);
        class_7849 secondRowWidget = (class_7849)verticalButtonLayout.method_52736((class_8021)new class_7849(308, 20, class_7849.class_7851.field_40789));
        secondRowWidget.method_46495((class_8021)folderButton);
        secondRowWidget.method_46495((class_8021)openButton);
        secondRowWidget.method_46495((class_8021)doneButton);
        verticalButtonLayout.method_48222();
        class_7843.method_46442((class_8021)verticalButtonLayout, (int)0, (int)(this.field_22790 - 66), (int)this.field_22789, (int)64);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.drawMenuBackground(context);
        this.drawHeaderAndFooterSeparators(context);
        context.method_25300(this.field_22793, this.title, this.field_22789 / 2, 20, -1);
        int finalHeight = this.field_22790 - 48 - 68;
        float scaleFactor = (float)finalHeight / (float)this.imageHeight;
        int finalWidth = (int)((float)this.imageWidth * scaleFactor);
        context.method_25290(class_10799.field_56883, this.image.getTextureId(), this.field_22789 / 2 - finalWidth / 2, this.field_22790 - 68 - finalHeight, 0.0f, 0.0f, finalWidth, finalHeight, finalWidth, finalHeight);
        if (this.screenshotIndex != -1 && this.screenshots != null) {
            context.method_25300(this.field_22793, "Screenshot %d/%d".formatted(this.screenshotIndex + 1, this.screenshots.size()), this.field_22789 / 2, 30, -1);
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            this.renderDebugInfo(context);
        }
    }

    private void renderDebugInfo(class_332 context) {
        context.method_51448().pushMatrix();
        int finalHeight = this.field_22790 - 48 - 48;
        float scaleFactor = (float)finalHeight / (float)this.imageHeight;
        int finalWidth = (int)((float)this.imageWidth * scaleFactor);
        context.method_25300(this.field_22793, "Image Size: %dx%d".formatted(this.imageWidth, this.imageHeight), this.field_22789 / 2, 40, -1);
        context.method_25300(this.field_22793, "Screen Size: %dx%d".formatted(this.field_22789, this.field_22790), this.field_22789 / 2, 50, -1);
        context.method_25300(this.field_22793, "Scale Factor: %s".formatted(Float.valueOf(scaleFactor)), this.field_22789 / 2, 60, -1);
        context.method_25300(this.field_22793, "Scaled Size: %dx%d".formatted(finalWidth, finalHeight), this.field_22789 / 2, 70, -1);
    }

    private void drawMenuBackground(class_332 context) {
        context.method_25290(class_10799.field_56883, this.client.field_1687 == null ? MENU_DECOR_BACKGROUND_TEXTURE : INWORLD_MENU_DECOR_BACKGROUND_TEXTURE, 0, 48, 0.0f, 0.0f, this.field_22789, this.field_22790 - 68 - 48, 32, 32);
    }

    private void drawHeaderAndFooterSeparators(class_332 context) {
        context.method_25290(class_10799.field_56883, this.client.field_1687 == null ? class_437.field_49895 : class_437.field_49897, 0, 46, 0.0f, 0.0f, this.field_22789, 2, 32, 2);
        context.method_25290(class_10799.field_56883, this.client.field_1687 == null ? class_437.field_49896 : class_437.field_49898, 0, this.field_22790 - 68, 0.0f, 0.0f, this.field_22789, 2, 32, 2);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Path imagePath;
        if (this.screenshotIndex == -1 || this.screenshots == null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        switch (keyCode) {
            case 263: {
                Path path;
                if (this.screenshotIndex >= 1) {
                    path = this.screenshots.get(this.screenshotIndex - 1);
                    break;
                }
                path = this.screenshots.getLast();
                break;
            }
            case 262: {
                Path path;
                if (this.screenshotIndex < this.screenshots.size() - 1) {
                    path = this.screenshots.get(this.screenshotIndex + 1);
                    break;
                }
                path = this.screenshots.getFirst();
                break;
            }
            default: {
                Path path = imagePath = null;
            }
        }
        if (imagePath == null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        CompletableFuture.supplyAsync(() -> DynamicTexture.createScreenshot(this.client.method_1531(), imagePath), (Executor)class_156.method_27958()).thenAccept(texture -> texture.ifPresent(dynamicTexture -> this.client.method_20493(() -> {
            this.client.method_1507((class_437)new ScreenshotViewerScreen((DynamicTexture)dynamicTexture, imagePath, this.parent, this.screenshots));
            dynamicTexture.load();
        })));
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

