/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.gui.widget;

import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.SnapperConfig;
import dev.spiritstudios.snapper.gui.screen.ScreenshotScreen;
import dev.spiritstudios.snapper.gui.screen.ScreenshotViewerScreen;
import dev.spiritstudios.snapper.mixin.accessor.EntryListWidgetAccessor;
import dev.spiritstudios.snapper.util.DynamicTexture;
import dev.spiritstudios.snapper.util.SafeFiles;
import dev.spiritstudios.snapper.util.ScreenshotActions;
import dev.spiritstudios.snapper.util.SnapperUtil;
import dev.spiritstudios.specter.api.core.exception.UnreachableException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7413;
import net.minecraft.class_8028;
import net.minecraft.class_8494;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ScreenshotListWidget
extends class_4280<Entry> {
    private static final class_2960 VIEW_SPRITE = Snapper.id("screenshots/view");
    private static final class_2960 VIEW_HIGHLIGHTED_SPRITE = Snapper.id("screenshots/view_highlighted");
    private static final class_2960 GRID_SELECTION_BACKGROUND_TEXTURE = Snapper.id("textures/gui/grid_selection_background.png");
    private final class_437 parent;
    public final CompletableFuture<List<ScreenshotEntry>> loadFuture;
    public static final int GRID_ENTRY_WIDTH = 144;
    private final int gridItemHeight = 81;
    private final int listItemHeight = 36;
    private boolean showGrid = false;

    public ScreenshotListWidget(class_310 client, int width, int height, int y, int itemHeight, @Nullable ScreenshotListWidget previous, class_437 parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        this.method_25321((class_350.class_351)new LoadingEntry(client));
        this.loadFuture = previous != null ? previous.loadFuture : this.load(client);
        this.loadFuture.thenAccept(entries -> {
            this.method_25339();
            entries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
            if (entries.isEmpty()) {
                this.method_25321((class_350.class_351)new EmptyEntry(client));
            }
        });
        this.showGrid = ((ScreenshotScreen.ViewMode)((Object)SnapperConfig.INSTANCE.viewMode.get())).equals((Object)ScreenshotScreen.ViewMode.GRID);
        ((EntryListWidgetAccessor)((Object)this)).setItemHeight(this.showGrid ? this.gridItemHeight : this.listItemHeight);
    }

    protected void method_25339() {
        this.method_25396().forEach(Entry::close);
        super.method_25339();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Entry entry;
        if (class_8494.method_51255((int)keyCode) && (entry = (Entry)this.method_25334()) instanceof ScreenshotEntry) {
            ScreenshotEntry screenshotEntry = (ScreenshotEntry)entry;
            return screenshotEntry.click();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public CompletableFuture<List<ScreenshotEntry>> load(class_310 client) {
        return CompletableFuture.supplyAsync(() -> {
            List<Path> screenshots = ScreenshotActions.getScreenshots();
            return screenshots.parallelStream().flatMap(path -> DynamicTexture.createScreenshot(client.method_1531(), path).stream()).peek(screenshotImage -> screenshotImage.load().exceptionally(throwable -> {
                Snapper.LOGGER.error("An error occurred while loading the screenshot list", throwable);
                return null;
            })).map(image -> new ScreenshotEntry((DynamicTexture)image, client, this.parent, screenshots)).sorted(Comparator.comparingLong(ScreenshotEntry::lastModified).reversed()).toList();
        }).exceptionally(throwable -> {
            Snapper.LOGGER.error("An error occurred while loading the screenshot list", throwable);
            return Collections.emptyList();
        });
    }

    private void setEntrySelected(@Nullable ScreenshotEntry entry) {
        super.method_25313((class_350.class_351)entry);
        class_437 class_4372 = this.parent;
        if (class_4372 instanceof ScreenshotScreen) {
            ScreenshotScreen screenshotScreen = (ScreenshotScreen)class_4372;
            screenshotScreen.imageSelected(entry);
        }
    }

    private int getColumnCount() {
        if (this.field_22740.field_1755 != null) {
            int width = this.field_22740.field_1755.field_22789;
            if (width < 480) {
                return 2;
            }
            if (width < 720) {
                return 3;
            }
            return 4;
        }
        return 3;
    }

    public int method_25322() {
        return this.showGrid ? 144 * this.getColumnCount() + 4 * (this.getColumnCount() - 1) : 220;
    }

    protected void method_25311(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.showGrid) {
            int rowLeft = this.method_25342();
            int rowWidth = this.method_25322();
            int entryHeight = this.field_22741 - 4;
            int entryWidth = 144;
            int entryCount = this.method_25340();
            int spacing = (rowWidth - this.getColumnCount() * entryWidth) / (this.getColumnCount() - 1);
            for (int index = 0; index < entryCount; ++index) {
                int rowTop = this.method_25337(index);
                int rowBottom = this.method_25319(index);
                int colIndex = index % this.getColumnCount();
                int leftOffset = colIndex * (entryWidth + spacing);
                if (rowBottom < this.method_46427() || rowTop > this.method_55443()) continue;
                this.method_44397(context, mouseX, mouseY, delta, index, rowLeft + leftOffset, rowTop, entryWidth, entryHeight);
            }
        } else {
            super.method_25311(context, mouseX, mouseY, delta);
        }
    }

    public int method_25337(int index) {
        return super.method_25337(this.showGrid ? index / this.getColumnCount() : index);
    }

    protected void method_44398(class_332 context, int y, int entryWidth, int entryHeight, int borderColor, int fillColor) {
    }

    public int method_44390() {
        int totalRows = this.method_25340() / this.getColumnCount() + (this.method_25340() % this.getColumnCount() > 0 ? 1 : 0);
        return this.showGrid ? Math.max(0, totalRows * this.field_22741 - this.field_22759 + 4) : super.method_44390();
    }

    protected int method_44395() {
        if (!this.showGrid) {
            return super.method_44395();
        }
        int totalRows = this.method_25340() / this.getColumnCount() + (this.method_25340() % this.getColumnCount() > 0 ? 1 : 0);
        return totalRows * this.field_22741 + this.field_22748 + 4;
    }

    public void toggleGrid() {
        this.showGrid = !this.showGrid;
        ((EntryListWidgetAccessor)((Object)this)).setItemHeight(this.showGrid ? this.gridItemHeight : this.listItemHeight);
        for (Entry entry : this.method_25396()) {
            if (!(entry instanceof ScreenshotEntry)) continue;
            ScreenshotEntry sc = (ScreenshotEntry)entry;
            sc.setShowGrid(this.showGrid);
        }
        SnapperConfig.INSTANCE.viewMode.set((Object)(this.showGrid ? ScreenshotScreen.ViewMode.GRID : ScreenshotScreen.ViewMode.LIST));
    }

    @Nullable
    protected Entry getEntryAtPosition(double x, double y) {
        if (!this.showGrid) {
            return (Entry)super.method_25308(x, y);
        }
        int rowWidth = this.method_25322();
        int relX = class_3532.method_15357((double)(x - (double)this.method_25342()));
        int relY = class_3532.method_15357((double)(y - (double)this.method_46427())) - this.field_22748;
        if (relX < 0 || relX > rowWidth || relY < 0 || relY > this.method_55443()) {
            return null;
        }
        int rowIndex = (relY + (int)this.method_44387()) / this.field_22741;
        int colIndex = class_3532.method_15375((float)((float)relX / (float)rowWidth * (float)this.getColumnCount()));
        int entryIndex = rowIndex * this.getColumnCount() + colIndex;
        return entryIndex >= 0 && entryIndex < this.method_25340() ? (Entry)this.method_25326(entryIndex) : null;
    }

    @Nullable
    protected Entry getNeighboringEntry(class_8028 direction, Predicate<Entry> predicate, @Nullable Entry selected) {
        int offset;
        if (!this.showGrid) {
            return (Entry)super.method_48199(direction, predicate, (class_350.class_351)selected);
        }
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case field_41828: {
                int n = -1;
                break;
            }
            case field_41829: {
                int n = 1;
                break;
            }
            case field_41826: {
                int n = -this.getColumnCount();
                break;
            }
            case field_41827: {
                int n = offset = this.getColumnCount();
            }
        }
        if (this.method_25340() > 0) {
            int entryIndex = selected == null ? (offset > 0 ? 0 : this.method_25340() - 1) : this.method_25396().indexOf(selected) + offset;
            for (int k = entryIndex; k >= 0 && k < this.method_25396().size(); k += offset) {
                Entry entry = (Entry)this.method_25326(k);
                if (!predicate.test(entry)) continue;
                return entry;
            }
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static class LoadingEntry
    extends Entry
    implements AutoCloseable {
        private static final class_2561 LOADING_LIST_TEXT = class_2561.method_43471((String)"text.snapper.loading");
        private final class_310 client;

        public LoadingEntry(class_310 client) {
            this.client = client;
        }

        public class_2561 method_37006() {
            return LOADING_LIST_TEXT;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.client.field_1755 == null) {
                throw new UnreachableException();
            }
            context.method_51439(this.client.field_1772, LOADING_LIST_TEXT, (this.client.field_1755.field_22789 - this.client.field_1772.method_27525((class_5348)LOADING_LIST_TEXT)) / 2, y + (entryHeight - 9) / 2, -1, false);
            String loadString = class_7413.method_43449((long)class_156.method_658());
            context.method_51433(this.client.field_1772, loadString, (this.client.field_1755.field_22789 - this.client.field_1772.method_1727(loadString)) / 2, y + (entryHeight - 9) / 2 + 9, -8355712, false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4280.class_4281<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ScreenshotEntry
    extends Entry
    implements AutoCloseable {
        public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
        public final FileTime lastModified;
        private final class_310 client;
        public final DynamicTexture icon;
        public final String iconFileName;
        public final class_437 screenParent;
        private long time;
        private boolean showGrid;
        private final List<Path> screenshots;
        private boolean clickThroughHovered = false;

        public ScreenshotEntry(DynamicTexture icon, class_310 client, class_437 parent, List<Path> screenshots) {
            this.showGrid = ScreenshotListWidget.this.showGrid;
            this.client = client;
            this.screenParent = parent;
            this.icon = icon;
            this.iconFileName = icon.getPath().getFileName().toString();
            this.lastModified = SafeFiles.getLastModifiedTime(icon.getPath()).orElse(FileTime.fromMillis(0L));
            this.screenshots = screenshots;
        }

        public void setShowGrid(boolean showGrid) {
            this.showGrid = showGrid;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.showGrid) {
                this.renderGrid(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
                return;
            }
            this.renderList(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }

        public void renderList(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Object fileName = this.iconFileName;
            Object creationString = "undefined";
            long creationTime = 0L;
            try {
                creationTime = Files.readAttributes(this.icon.getPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
            }
            catch (IOException e) {
                this.client.method_1507((class_437)new ScreenshotScreen(this.screenParent));
            }
            if (creationTime != -1L) {
                creationString = class_2561.method_43471((String)"text.snapper.created").getString() + " " + DATE_FORMAT.format(Instant.ofEpochMilli(creationTime));
            }
            if (class_3544.method_15438((String)fileName)) {
                fileName = String.valueOf(class_2561.method_43471((String)"text.snapper.generic")) + " " + (index + 1);
            }
            context.method_51433(this.client.field_1772, this.truncateFileName((String)fileName, entryWidth - 32 - 6, 29), x + 32 + 3, y + 1, -1, false);
            context.method_51433(this.client.field_1772, (String)creationString, x + 35, y + 12, -8355712, false);
            if (this.icon.loaded()) {
                context.method_25302(class_10799.field_56883, this.icon.getTextureId(), x, y, (float)this.icon.getHeight() / 3.0f + 32.0f, 0.0f, entryHeight, entryHeight, this.icon.getHeight(), this.icon.getHeight(), this.icon.getWidth(), this.icon.getHeight());
            }
            if (((Boolean)this.client.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                context.method_25294(x, y, x + 32, y + 32, -1601138544);
                context.method_52706(class_10799.field_56883, mouseX - x < 32 && this.icon.loaded() ? VIEW_HIGHLIGHTED_SPRITE : VIEW_SPRITE, x, y, 32, 32);
            }
        }

        public void renderGrid(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int centreX = x + entryWidth / 2;
            int centreY = y + entryHeight / 2;
            this.clickThroughHovered = SnapperUtil.inBoundingBox(centreX - 16, centreY - 16, 32, 32, mouseX, mouseY);
            if (this.icon.loaded()) {
                context.method_25302(class_10799.field_56883, this.icon.getTextureId(), x, y, 0.0f, 0.0f, entryWidth, entryHeight, this.icon.getWidth(), this.icon.getHeight(), this.icon.getWidth(), this.icon.getHeight());
            }
            if (((Boolean)this.client.field_1690.method_42446().method_41753()).booleanValue() || hovered && mouseX < x + entryWidth || ScreenshotListWidget.this.method_25332(index)) {
                this.renderMetadata(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            }
        }

        public void renderMetadata(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Object fileName = this.iconFileName;
            int centreX = x + entryWidth / 2;
            int centreY = y + entryHeight / 2;
            if (class_3544.method_15438((String)fileName)) {
                fileName = String.valueOf(class_2561.method_43471((String)"text.snapper.generic")) + " " + (index + 1);
            }
            String creationString = "undefined";
            long creationTime = 0L;
            try {
                creationTime = Files.readAttributes(this.icon.getPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
            }
            catch (IOException e) {
                this.client.method_1507((class_437)new ScreenshotScreen(this.screenParent));
            }
            if (creationTime != -1L) {
                creationString = DATE_FORMAT.format(Instant.ofEpochMilli(creationTime));
            }
            context.method_25290(class_10799.field_56883, GRID_SELECTION_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, entryWidth, entryHeight, 16, 16);
            context.method_52706(class_10799.field_56883, this.clickThroughHovered && this.icon.loaded() ? VIEW_HIGHLIGHTED_SPRITE : VIEW_SPRITE, centreX - 16, centreY - 16, 32, 32);
            context.method_51433(this.client.field_1772, this.truncateFileName((String)fileName, entryWidth, 24), x + 5, y + 6, -1, true);
            context.method_51439(this.client.field_1772, (class_2561)class_2561.method_43471((String)"text.snapper.created"), x + 5, y + entryHeight - 22, -6250336, true);
            context.method_51433(this.client.field_1772, creationString, x + 5, y + entryHeight - 12, -6250336, true);
        }

        public String truncateFileName(String fileName, int maxWidth, int truncateLength) {
            Object truncatedName = fileName;
            if (this.client.field_1772.method_1727((String)truncatedName) > maxWidth) {
                truncatedName = ((String)truncatedName).substring(0, Math.min(fileName.length(), truncateLength)) + "...";
            }
            return truncatedName;
        }

        public void method_49568(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (ScreenshotListWidget.this.method_25332(index)) {
                context.method_25294(x - 2, y - 2, x + entryWidth + 2, y + entryHeight + 2, -1);
                context.method_25294(x - 1, y - 1, x + entryWidth + 1, y + entryHeight + 1, -16777216);
            }
        }

        public void method_25365(boolean focused) {
            if (focused) {
                ScreenshotListWidget.this.setEntrySelected(this);
            }
            super.method_25365(focused);
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.iconFileName);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean clickThrough;
            ScreenshotListWidget.this.setEntrySelected(this);
            boolean bl = clickThrough = !this.showGrid && mouseX - (double)ScreenshotListWidget.this.method_25342() <= 32.0 || this.showGrid && this.clickThroughHovered;
            if (!clickThrough && class_156.method_658() - this.time >= 250L) {
                this.time = class_156.method_658();
                return super.method_25402(mouseX, mouseY, button);
            }
            return this.click();
        }

        public boolean click() {
            if (this.icon == null) {
                return false;
            }
            class_339.method_62888((class_1144)this.client.method_1483());
            this.client.method_1507((class_437)new ScreenshotViewerScreen(this.icon, this.icon.getPath(), this.screenParent, this.screenshots));
            return true;
        }

        @Override
        public void close() {
            this.icon.close();
        }

        public long lastModified() {
            return this.lastModified.toMillis();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class EmptyEntry
    extends Entry
    implements AutoCloseable {
        private static final class_2561 EMPTY_LIST_TEXT = class_2561.method_43471((String)"text.snapper.empty");
        private static final class_2561 EMPTY_CUSTOM_LIST_TEXT = class_2561.method_43471((String)"text.snapper.empty.custom");
        private final class_310 client;

        public EmptyEntry(class_310 client) {
            this.client = client;
        }

        public class_2561 method_37006() {
            return EMPTY_LIST_TEXT;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.client.field_1755 == null) {
                throw new UnreachableException();
            }
            context.method_51439(this.client.field_1772, EMPTY_LIST_TEXT, (this.client.field_1755.field_22789 - this.client.field_1772.method_27525((class_5348)EMPTY_LIST_TEXT)) / 2, y + entryHeight / 2, -1, false);
            context.method_51439(this.client.field_1772, EMPTY_CUSTOM_LIST_TEXT, (this.client.field_1755.field_22789 - this.client.field_1772.method_27525((class_5348)EMPTY_CUSTOM_LIST_TEXT)) / 2, y + entryHeight / 2 + 10, -1, false);
        }
    }
}

