/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util;

import dev.spiritstudios.snapper.Snapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_10539;
import net.minecraft.class_1084;
import net.minecraft.class_11405;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public class DynamicCubemapTexture
extends class_11405 {
    private static final String[] TEXTURE_SUFFIXES = new String[]{"_1.png", "_3.png", "_5.png", "_4.png", "_0.png", "_2.png"};
    private final Path path;

    public DynamicCubemapTexture(class_2960 id, Path path) {
        super(id);
        this.path = path;
    }

    public class_10539 method_65809(class_3300 resourceManager) throws IOException {
        class_10539 contents;
        try (InputStream baseStream = Files.newInputStream(this.path.resolve("panorama" + TEXTURE_SUFFIXES[0]), new OpenOption[0]);){
            class_1011 baseImage = class_1011.method_4309((InputStream)baseStream);
            int width = baseImage.method_4307();
            int height = baseImage.method_4323();
            class_1011 image = new class_1011(width, height * 6, false);
            baseImage.method_47594(image, 0, 0, 0, 0, width, height, false, true);
            for (int i = 1; i < 6; ++i) {
                try (InputStream panoramaStream = Files.newInputStream(this.path.resolve("panorama" + TEXTURE_SUFFIXES[i]), new OpenOption[0]);){
                    class_1011 panoramaImage = class_1011.method_4309((InputStream)panoramaStream);
                    if (panoramaImage.method_4307() != width || panoramaImage.method_4323() != height) {
                        Snapper.LOGGER.error("Image dimensions of panorama '{}' sides do not match: part 0 is {}x{}, but part {} is {}x{}", new Object[]{this.method_65859(), width, height, i, panoramaImage.method_4307(), panoramaImage.method_4323()});
                        baseImage.close();
                        throw new IOException();
                    }
                    panoramaImage.method_47594(image, 0, 0, 0, i * height, width, height, false, true);
                    panoramaImage.close();
                    continue;
                }
            }
            baseImage.close();
            contents = new class_10539(image, new class_1084(true, false));
        }
        return contents;
    }

    public static Optional<DynamicCubemapTexture> createPanorama(class_2960 id, Path path) {
        return Optional.of(new DynamicCubemapTexture(id, path));
    }
}

