/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util;

import dev.spiritstudios.snapper.Snapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class DynamicTexture
implements AutoCloseable {
    private static final class_2960 UNKNOWN_SERVER = class_2960.method_60656((String)"textures/misc/unknown_server.png");
    private final class_1060 textureManager;
    private final class_2960 id;
    private final Path path;
    private final class_1011 image;
    private class_1043 texture;

    private DynamicTexture(class_1060 textureManager, class_2960 id, Path path) throws IOException {
        this.textureManager = textureManager;
        this.id = id;
        this.path = path;
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            this.image = class_1011.method_4309((InputStream)stream);
        }
    }

    public CompletableFuture<Void> load() {
        return class_310.method_1551().method_20493(() -> {
            this.texture = new class_1043(() -> ((class_2960)this.id).toString(), this.image);
            this.textureManager.method_4616(this.id, (class_1044)this.texture);
        });
    }

    public static Optional<DynamicTexture> createScreenshot(class_1060 textureManager, Path path) {
        try {
            return Optional.of(new DynamicTexture(textureManager, Snapper.id("screenshots/" + class_156.method_30309((String)path.getFileName().toString(), class_2960::method_29184) + "/icon"), path));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public void enableFiltering() {
        this.texture.method_4527(true, true);
    }

    public void destroy() {
        this.textureManager.method_4615(this.id);
        this.texture.close();
    }

    public int getWidth() {
        return this.texture != null && this.texture.method_4525() != null ? this.texture.method_4525().method_4307() : 64;
    }

    public int getHeight() {
        return this.texture != null && this.texture.method_4525() != null ? this.texture.method_4525().method_4323() : 64;
    }

    public class_2960 getTextureId() {
        return this.texture != null ? this.id : UNKNOWN_SERVER;
    }

    public boolean loaded() {
        return this.texture != null;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void close() {
        this.destroy();
    }
}

