/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util;

import dev.spiritstudios.snapper.Snapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class SafeFiles {
    public static boolean createDirectories(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isContentType(Path path, String matchType, String extension) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try {
            @Nullable String foundType = Files.probeContentType(path);
            if (foundType != null) {
                return foundType.equals(matchType);
            }
        }
        catch (IOException | NullPointerException e) {
            Snapper.LOGGER.error("Failed to get MIME type of file name {}; attempting extension match", (Object)path.getFileName());
            return false;
        }
        return path.getFileName().toString().endsWith(extension);
    }

    public static Optional<FileTime> getLastModifiedTime(Path path) {
        try {
            return Optional.of(Files.getLastModifiedTime(path, new LinkOption[0]));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

