/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util;

import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.util.SafeFiles;
import dev.spiritstudios.snapper.util.SnapperUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_410;
import net.minecraft.class_435;
import net.minecraft.class_437;
import net.minecraft.class_5244;

@Environment(value=EnvType.CLIENT)
public class ScreenshotActions {
    public static void deleteScreenshot(Path path, class_437 screen) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed) {
                client.method_1507((class_437)new class_435(true));
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    Snapper.LOGGER.error("Failed to delete file", (Throwable)e);
                }
            }
            client.method_1507(screen);
        }, (class_2561)class_2561.method_43471((String)"text.snapper.delete_question"), (class_2561)class_2561.method_43469((String)"text.snapper.delete_warning", (Object[])new Object[]{path.getFileName()}), (class_2561)class_2561.method_43471((String)"button.snapper.delete"), class_5244.field_24335));
    }

    public static void renameScreenshot(Path screenshot, String newName) {
        if (Files.exists(screenshot, new LinkOption[0])) {
            try {
                Files.move(screenshot, screenshot.getParent().resolve(newName), new CopyOption[0]);
            }
            catch (IOException e) {
                Snapper.LOGGER.error("Failed to rename file", (Throwable)e);
            }
        }
    }

    public static List<Path> getScreenshots() {
        List<Path> list;
        block9: {
            Path screenshotDirectory = SnapperUtil.getConfiguredScreenshotDirectory();
            if (!Files.exists(screenshotDirectory, new LinkOption[0])) {
                return List.of();
            }
            Stream<Path> stream = Files.list(screenshotDirectory);
            try {
                list = stream.filter(path -> !Files.isDirectory(path, new LinkOption[0]) && SafeFiles.isContentType(path, "image/png", ".png")).sorted(Comparator.comparingLong(path -> SafeFiles.getLastModifiedTime(path).map(FileTime::toMillis).orElse(0L)).reversed()).toList();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return list;
    }
}

