/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util;

import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.SnapperConfig;
import dev.spiritstudios.snapper.gui.toast.SnapperToast;
import dev.spiritstudios.snapper.util.SafeFiles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import org.apache.commons.lang3.SystemProperties;

@Environment(value=EnvType.CLIENT)
public final class SnapperUtil {
    public static final Path UNIFIED_FOLDER = switch (class_156.method_668()) {
        case class_156.class_158.field_1133 -> Path.of(System.getenv("APPDATA"), ".snapper");
        case class_156.class_158.field_1137 -> Path.of(SystemProperties.getUserHome(), "Library", "Application Support", "snapper");
        default -> Path.of(SystemProperties.getUserHome(), ".snapper");
    };

    public static Path getConfiguredScreenshotDirectory() {
        if (((Boolean)SnapperConfig.INSTANCE.useCustomScreenshotFolder.get()).booleanValue()) {
            Path customPath = ((Path)SnapperConfig.INSTANCE.customScreenshotFolder.get()).resolve("screenshots");
            if (!SafeFiles.createDirectories(customPath)) {
                Snapper.LOGGER.error("Failed to create directories of configured custom screenshot folder");
            }
            return customPath;
        }
        return class_310.method_1551().field_1697.toPath().resolve("screenshots");
    }

    public static boolean inBoundingBox(int x, int y, int w, int h, double mouseX, double mouseY) {
        return mouseX > (double)x && mouseX < (double)(x + w) && mouseY > (double)y && mouseY < (double)(y + h);
    }

    public static boolean isOfflineAccount() {
        return class_310.method_1551().method_1548().method_1674().length() < 400;
    }

    public static boolean panoramaPresent(Path path) {
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (Files.exists(path.resolve("panorama_%s.png".formatted(i)), new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    public static void toast(SnapperToast.Type type, class_2561 title, class_2561 description) {
        class_310.method_1551().method_1566().method_1999((class_368)new SnapperToast(type, title, description));
    }

    @Environment(value=EnvType.CLIENT)
    public static enum PanoramaSize {
        ONE_THOUSAND_TWENTY_FOUR(1024),
        TWO_THOUSAND_FORTY_EIGHT(2048),
        FOUR_THOUSAND_NINETY_SIX(4096);

        private final int size;

        private PanoramaSize(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }
    }
}

