/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util.actions;

import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.util.PlatformHelper;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class GeneralPlatformActions
implements PlatformHelper {
    @Override
    public void copyScreenshot(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            Snapper.LOGGER.warn("Attempted to copy screenshot {} that does not exist", (Object)path);
            return;
        }
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            BufferedImage imageBuffer = ImageIO.read(stream);
            GeneralPlatformActions.getClipboard().ifPresent(clipboard -> clipboard.setContents(new TransferableImage(imageBuffer), null));
        }
        catch (IOException e) {
            Snapper.LOGGER.error("Copying of image at {} failed", (Object)path);
        }
    }

    private static Optional<Clipboard> getClipboard() {
        try {
            return Optional.of(Toolkit.getDefaultToolkit().getSystemClipboard());
        }
        catch (HeadlessException e) {
            Snapper.LOGGER.error("Failed to get clipboard", (Throwable)e);
            return Optional.empty();
        }
    }

    @Environment(value=EnvType.CLIENT)
    record TransferableImage(Image image) implements Transferable
    {
        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image();
        }
    }
}

