/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util.actions;

import ca.weblite.objc.Client;
import ca.weblite.objc.Proxy;
import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.util.PlatformHelper;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MacPlatformActions
implements PlatformHelper {
    @Override
    public void copyScreenshot(Path screenshot) {
        Client client = Client.getInstance();
        Proxy url = client.sendProxy("NSURL", "fileURLWithPath:", new Object[]{screenshot.toAbsolutePath().toString()});
        Proxy image = client.sendProxy("NSImage", "alloc", new Object[0]);
        image.send("initWithContentsOfURL:", new Object[]{url});
        Proxy array = client.sendProxy("NSArray", "array", new Object[0]);
        array = array.sendProxy("arrayByAddingObject:", new Object[]{image});
        Proxy pasteboard = client.sendProxy("NSPasteboard", "generalPasteboard", new Object[0]);
        pasteboard.send("clearContents", new Object[0]);
        boolean wasSuccessful = pasteboard.sendBoolean("writeObjects:", new Object[]{array});
        if (!wasSuccessful) {
            Snapper.LOGGER.error("Failed to write image to pasteboard.");
        }
    }
}

