/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.spiritstudios.snapper.gui.widget.FolderSelectWidget;
import dev.spiritstudios.specter.api.config.Value;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import joptsimple.internal.Strings;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_339;
import org.apache.commons.lang3.SystemProperties;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

@Environment(value=EnvType.CLIENT)
public class DirectoryConfigUtil {
    public static final Codec<Path> PATH_CODEC = Codec.STRING.comapFlatMap(string -> {
        Path path = Path.of(string, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            return DataResult.error(e::getMessage);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return DataResult.error(() -> "Failed to get file from config string value. Does the directory exist?");
        }
        return DataResult.success((Object)path);
    }, path -> DirectoryConfigUtil.escapePath(path.toString()));
    public static final BiFunction<Value<?>, String, ? extends class_339> PATH_WIDGET_FACTORY = (configValue, id) -> {
        Value value = configValue;
        return new FolderSelectWidget(0, 0, 10, 10, (Value<Path>)value, "%s.placeholder".formatted(configValue.translationKey(id)));
    };

    public static CompletableFuture<Optional<Path>> openFolderSelect(String title) {
        return CompletableFuture.supplyAsync(() -> TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)title.replaceAll("[^a-zA-Z0-9 .,]", ""), (CharSequence)SystemProperties.getUserHome())).thenApply(selectedPath -> {
            if (Strings.isNullOrEmpty((String)selectedPath)) {
                return Optional.empty();
            }
            return Optional.of(Path.of(selectedPath, new String[0]));
        });
    }

    public static String escapePath(String path) {
        return path.replace("\\", "\\\\");
    }
}

