/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util.uploading;

import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.SnapperConfig;
import dev.spiritstudios.snapper.gui.toast.SnapperToast;
import dev.spiritstudios.snapper.util.SnapperUtil;
import dev.spiritstudios.snapper.util.uploading.AxolotlAuthentication;
import dev.spiritstudios.snapper.util.uploading.ScreenshotUploading;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AxolotlClientApi
implements Closeable {
    private static final String BASE_URL = "https://api.axolotlclient.com/v1/";
    private final HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).executor((Executor)class_156.method_27958()).build();
    private Instant authTime = Instant.EPOCH;
    @Nullable
    private AxolotlAuthentication auth;

    public CompletableFuture<String> uploadImage(Path image) {
        byte[] bytes;
        try {
            bytes = Files.readAllBytes(image);
        }
        catch (IOException e2) {
            return CompletableFuture.failedFuture(e2);
        }
        SnapperUtil.toast(SnapperToast.Type.UPLOAD, (class_2561)class_2561.method_43471((String)"toast.snapper.upload.in_progress"), (class_2561)class_2561.method_43471((String)"toast.snapper.upload.in_progress.description"));
        return ((CompletableFuture)((CompletableFuture)this.authenticate().thenCompose(ignored -> this.post("image/" + image.getFileName().toString(), bytes))).thenApply(response -> {
            if (response.statusCode() != 200) {
                return null;
            }
            return (String)response.body();
        })).exceptionally(e -> {
            Snapper.LOGGER.error("Failed to upload image", e);
            return null;
        });
    }

    private CompletableFuture<Void> authenticate() {
        if (this.authTime.plus(24L, ChronoUnit.HOURS).isAfter(Instant.now())) {
            return CompletableFuture.completedFuture(null);
        }
        class_320 session = class_310.method_1551().method_1548();
        MinecraftSessionService sessionService = class_310.method_1551().method_1495();
        String serverId = new BigInteger(DigestUtils.sha1((byte[])RandomStringUtils.insecure().next(40).getBytes(StandardCharsets.UTF_8))).toString(16);
        try {
            sessionService.joinServer(session.method_44717(), session.method_1674(), serverId);
        }
        catch (AuthenticationException e) {
            return CompletableFuture.failedFuture(e);
        }
        return ((CompletableFuture)this.get("authenticate", Map.of("username", session.method_1676(), "server_id", serverId)).thenApply(response -> (AxolotlAuthentication)AxolotlAuthentication.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)((String)response.body()))).getOrThrow())).thenAccept(auth -> {
            this.auth = auth;
            this.authTime = Instant.now();
        });
    }

    public CompletableFuture<HttpResponse<String>> get(String route, Map<String, String> query) {
        return this.request(route, query, null, "GET");
    }

    public CompletableFuture<HttpResponse<String>> post(String route, byte[] rawBody) {
        return this.request(route, null, rawBody, "POST");
    }

    private CompletableFuture<HttpResponse<String>> request(String route, Map<String, String> query, byte[] rawBody, String method) {
        if (SnapperConfig.INSTANCE.termsAccepted.get() != TermsAcceptance.ACCEPTED) {
            return CompletableFuture.failedFuture(new IllegalStateException("Terms not accepted"));
        }
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append(route);
        if (query != null && !query.isEmpty()) {
            url.append("?");
            query.forEach((k, v) -> {
                if (url.charAt(url.length() - 1) != '?') {
                    url.append("&");
                }
                url.append((String)k).append("=").append((String)v);
            });
        }
        return this.request(URI.create(url.toString()), rawBody, method);
    }

    private CompletableFuture<HttpResponse<String>> request(URI url, byte[] rawBody, String method) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "application/json").header("User-Agent", "Snapper/" + ScreenshotUploading.SNAPPER_VERSION);
        if (this.auth != null) {
            builder.header("Authorization", this.auth.accessToken());
        }
        builder.method(method, rawBody != null ? HttpRequest.BodyPublishers.ofByteArray(rawBody) : HttpRequest.BodyPublishers.noBody());
        return this.client.sendAsync(builder.build(), HttpResponse.BodyHandlers.ofString());
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TermsAcceptance {
        ACCEPTED,
        DENIED,
        UNSET;

    }
}

