/*
 * Decompiled with CFR 0.152.
 */
package dev.spiritstudios.snapper.util.uploading;

import dev.spiritstudios.snapper.Snapper;
import dev.spiritstudios.snapper.SnapperConfig;
import dev.spiritstudios.snapper.gui.screen.PrivacyNoticeScreen;
import dev.spiritstudios.snapper.gui.toast.SnapperToast;
import dev.spiritstudios.snapper.util.SnapperUtil;
import dev.spiritstudios.snapper.util.uploading.AxolotlClientApi;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ScreenshotUploading {
    public static final String SNAPPER_WEB_URL = "https://snapper.spiritstudios.dev/img/%s";
    public static final String SNAPPER_VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("snapper").orElseThrow()).getMetadata().getVersion().getFriendlyString();
    private static final AxolotlClientApi API = new AxolotlClientApi();

    public static CompletableFuture<Void> upload(Path image) {
        if (SnapperUtil.isOfflineAccount()) {
            SnapperUtil.toast(SnapperToast.Type.DENY, (class_2561)class_2561.method_43471((String)"toast.snapper.upload.axolotlclient.api_disabled"), (class_2561)class_2561.method_43471((String)"toast.snapper.upload.offline"));
            return CompletableFuture.failedFuture(new IllegalStateException("Minecraft is currently running in offline mode."));
        }
        if (SnapperConfig.INSTANCE.termsAccepted.get() == AxolotlClientApi.TermsAcceptance.UNSET) {
            class_310 client = class_310.method_1551();
            CompletableFuture<Void> success = new CompletableFuture<Void>();
            client.method_1507((class_437)new PrivacyNoticeScreen(client.field_1755, v -> {
                if (v.booleanValue()) {
                    ScreenshotUploading.upload(image).thenAccept(success::complete);
                }
            }));
            return success;
        }
        if (SnapperConfig.INSTANCE.termsAccepted.get() != AxolotlClientApi.TermsAcceptance.ACCEPTED) {
            SnapperUtil.toast(SnapperToast.Type.UPLOAD, (class_2561)class_2561.method_43471((String)"toast.snapper.upload.failure"), (class_2561)class_2561.method_43471((String)"toast.snapper.upload.axolotlclient.api_disabled"));
            return CompletableFuture.failedFuture(new IllegalStateException("AxolotlClient API is disabled."));
        }
        return API.uploadImage(image).thenAccept(ScreenshotUploading::imageUploaded);
    }

    private static void imageUploaded(String imageId) {
        if (imageId == null) {
            SnapperUtil.toast(SnapperToast.Type.DENY, (class_2561)class_2561.method_43471((String)"toast.snapper.upload.failure"), (class_2561)class_2561.method_43471((String)"toast.snapper.upload.failure.generic"));
            return;
        }
        class_310 client = class_310.method_1551();
        String snapperUrl = SNAPPER_WEB_URL.formatted(imageId);
        Snapper.LOGGER.info("Uploaded screenshot to: {}", (Object)snapperUrl);
        client.field_1774.method_1455(snapperUrl);
        SnapperUtil.toast(SnapperToast.Type.UPLOAD, (class_2561)class_2561.method_43471((String)"toast.snapper.upload.success"), (class_2561)class_2561.method_43469((String)"toast.snapper.upload.success.description", (Object[])new Object[]{snapperUrl}));
    }

    public static void close() {
        API.close();
    }
}

