/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render.pipeline;

import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.pipeline.DrawModes;
import dev.deftu.omnicore.client.render.pipeline.LegacyShaderSource;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipelineBuilder;
import dev.deftu.omnicore.client.render.pipeline.ShaderSource;
import dev.deftu.omnicore.client.render.pipeline.VertexFormats;
import dev.deftu.omnicore.client.render.state.OmniManagedRenderState;
import dev.deftu.omnicore.client.render.vertex.OmniBuiltBuffer;
import dev.deftu.omnicore.client.shaders.IntUniform;
import dev.deftu.omnicore.client.shaders.MatrixUniform;
import dev.deftu.omnicore.client.shaders.OmniShader;
import dev.deftu.omnicore.client.shaders.SamplerUniform;
import dev.deftu.omnicore.client.shaders.Vec2Uniform;
import dev.deftu.omnicore.client.shaders.Vec3Uniform;
import dev.deftu.omnicore.client.shaders.Vec4Uniform;
import dev.deftu.omnicore.client.shaders.VecUniform;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\r\u0018\u0000 .2\u00020\u0001:\u0001.B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001d\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001cJ!\u0010 \u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\n\u0010\u001f\u001a\u00020\u001d\"\u00020\u001e\u00a2\u0006\u0004\b \u0010!J!\u0010 \u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\n\u0010\u001f\u001a\u00020\"\"\u00020\u0017\u00a2\u0006\u0004\b \u0010#R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010'\u001a\u0004\b(\u0010)R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010*R\u001a\u0010\t\u001a\u00020\b8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\t\u0010+\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "", "Lnet/minecraft/util/ResourceLocation;", "identifier", "Lnet/minecraft/client/renderer/vertex/VertexFormat;", "vertexFormat", "Ldev/deftu/omnicore/client/render/pipeline/ShaderSource;", "shaderSource", "Ldev/deftu/omnicore/client/render/state/OmniManagedRenderState;", "activeRenderState", "<init>", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/vertex/VertexFormat;Ldev/deftu/omnicore/client/render/pipeline/ShaderSource;Ldev/deftu/omnicore/client/render/state/OmniManagedRenderState;)V", "Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;", "builtBuffer", "", "draw$OmniCore", "(Ldev/deftu/omnicore/client/render/vertex/OmniBuiltBuffer;)V", "draw", "bind", "()V", "unbind", "", "name", "", "glId", "texture", "(Ljava/lang/String;I)V", "index", "(II)V", "", "", "values", "uniform", "(Ljava/lang/String;[F)V", "", "(Ljava/lang/String;[I)V", "Lnet/minecraft/util/ResourceLocation;", "getIdentifier", "()Lnet/minecraft/util/ResourceLocation;", "Lnet/minecraft/client/renderer/vertex/VertexFormat;", "getVertexFormat", "()Lnet/minecraft/client/renderer/vertex/VertexFormat;", "Ldev/deftu/omnicore/client/render/pipeline/ShaderSource;", "Ldev/deftu/omnicore/client/render/state/OmniManagedRenderState;", "getActiveRenderState$OmniCore", "()Ldev/deftu/omnicore/client/render/state/OmniManagedRenderState;", "Companion", "OmniCore"})
public final class OmniRenderPipeline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation identifier;
    @NotNull
    private final VertexFormat vertexFormat;
    @Nullable
    private final ShaderSource shaderSource;
    @NotNull
    private final OmniManagedRenderState activeRenderState;

    public OmniRenderPipeline(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @Nullable ShaderSource shaderSource, @NotNull OmniManagedRenderState activeRenderState) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)vertexFormat, (String)"vertexFormat");
        Intrinsics.checkNotNullParameter((Object)activeRenderState, (String)"activeRenderState");
        this.identifier = identifier;
        this.vertexFormat = vertexFormat;
        this.shaderSource = shaderSource;
        this.activeRenderState = activeRenderState;
    }

    @NotNull
    public final ResourceLocation getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final VertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    @NotNull
    public final OmniManagedRenderState getActiveRenderState$OmniCore() {
        return this.activeRenderState;
    }

    public final void draw$OmniCore(@NotNull OmniBuiltBuffer builtBuffer) {
        Intrinsics.checkNotNullParameter((Object)builtBuffer, (String)"builtBuffer");
        BufferBuilder vanillaBuiltBuffer = builtBuffer.getVanilla();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vanillaBuiltBuffer);
    }

    public final void bind() {
        block0: {
            ShaderSource shaderSource = this.shaderSource;
            if (shaderSource == null) break block0;
            shaderSource.bind(this.activeRenderState.getBlendState());
        }
    }

    public final void unbind() {
        block0: {
            ShaderSource shaderSource = this.shaderSource;
            if (shaderSource == null) break block0;
            shaderSource.unbind();
        }
    }

    public final void texture(@NotNull String name, int glId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.shaderSource instanceof LegacyShaderSource) {
            SamplerUniform samplerUniform = ((LegacyShaderSource)this.shaderSource).getShader$OmniCore().getSamplerUniformOrNull(name);
            if (samplerUniform != null) {
                samplerUniform.setValue(glId);
            }
        } else {
            throw new IllegalArgumentException("Invalid shader source type");
        }
    }

    public final void texture(int index, int glId) {
        if (this.shaderSource instanceof LegacyShaderSource) {
            SamplerUniform samplerUniform = ((LegacyShaderSource)this.shaderSource).getShader$OmniCore().getSamplerUniformOrNull("Sampler" + index);
            if (samplerUniform != null) {
                samplerUniform.setValue(glId);
            }
        } else {
            OmniTextureManager.Companion.bindTexture(index, glId);
        }
    }

    public final void uniform(@NotNull String name, float ... values) {
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                if (!(this.shaderSource instanceof LegacyShaderSource)) break block12;
                OmniShader shader = ((LegacyShaderSource)this.shaderSource).getShader$OmniCore();
                switch (values.length) {
                    case 1: {
                        VecUniform vecUniform = shader.getVecUniformOrNull(name);
                        if (vecUniform != null) {
                            vecUniform.setValue(values[0]);
                        }
                        break block13;
                    }
                    case 2: {
                        Vec2Uniform vec2Uniform = shader.getVec2UniformOrNull(name);
                        if (vec2Uniform != null) {
                            vec2Uniform.setValue(values[0], values[1]);
                        }
                        break block13;
                    }
                    case 3: {
                        Vec3Uniform vec3Uniform = shader.getVec3UniformOrNull(name);
                        if (vec3Uniform != null) {
                            vec3Uniform.setValue(values[0], values[1], values[2]);
                        }
                        break block13;
                    }
                    case 4: {
                        Vec4Uniform vec4Uniform = shader.getVec4UniformOrNull(name);
                        if (vec4Uniform != null) {
                            vec4Uniform.setValue(values[0], values[1], values[2], values[3]);
                        }
                        break block13;
                    }
                    case 9: 
                    case 16: {
                        MatrixUniform matrixUniform = shader.getMatrixUniformOrNull(name);
                        if (matrixUniform != null) {
                            matrixUniform.setValue(values);
                        }
                        break block13;
                    }
                    default: {
                        StringBuilder stringBuilder = new StringBuilder().append("Provides too many values when defining a uniform: ");
                        String string = Arrays.toString(values);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        throw new UnsupportedOperationException(stringBuilder.append(string).toString());
                    }
                }
            }
            throw new IllegalArgumentException("Invalid shader source type");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void uniform(@NotNull String name, int ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (!(this.shaderSource instanceof LegacyShaderSource)) throw new IllegalArgumentException("Invalid shader source type");
        OmniShader shader = ((LegacyShaderSource)this.shaderSource).getShader$OmniCore();
        if (values.length == 1) {
            IntUniform intUniform = shader.getIntUniformOrNull(name);
            if (intUniform == null) return;
            intUniform.setValue(values[0]);
            return;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Provides too many values when defining a uniform: ");
            String string = Arrays.toString(values);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new UnsupportedOperationException(stringBuilder.append(string).toString());
        }
    }

    @JvmStatic
    @NotNull
    public static final OmniRenderPipelineBuilder builderWithDefaultShader(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode) {
        return Companion.builderWithDefaultShader(identifier, vertexFormat, mode);
    }

    @JvmStatic
    @NotNull
    public static final OmniRenderPipelineBuilder builderWithDefaultShader(@NotNull ResourceLocation identifier, @NotNull VertexFormats vertexFormat, @NotNull DrawModes mode) {
        return Companion.builderWithDefaultShader(identifier, vertexFormat, mode);
    }

    @JvmStatic
    @NotNull
    public static final OmniRenderPipelineBuilder builderWithLegacyShader(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode, @NotNull String vertexSource, @NotNull String fragmentSource) {
        return Companion.builderWithLegacyShader(identifier, vertexFormat, mode, vertexSource, fragmentSource);
    }

    @JvmStatic
    @NotNull
    public static final OmniRenderPipelineBuilder builderWithLegacyShader(@NotNull ResourceLocation identifier, @NotNull VertexFormats vertexFormat, @NotNull DrawModes mode, @NotNull String vertexSource, @NotNull String fragmentSource) {
        return Companion.builderWithLegacyShader(identifier, vertexFormat, mode, vertexSource, fragmentSource);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\u000eJ7\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline$Companion;", "", "<init>", "()V", "Lnet/minecraft/util/ResourceLocation;", "identifier", "Lnet/minecraft/client/renderer/vertex/VertexFormat;", "vertexFormat", "Ldev/deftu/omnicore/client/render/pipeline/DrawModes;", "mode", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "builderWithDefaultShader", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/vertex/VertexFormat;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;)Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "Ldev/deftu/omnicore/client/render/pipeline/VertexFormats;", "(Lnet/minecraft/util/ResourceLocation;Ldev/deftu/omnicore/client/render/pipeline/VertexFormats;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;)Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "", "vertexSource", "fragmentSource", "builderWithLegacyShader", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/vertex/VertexFormat;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;Ljava/lang/String;Ljava/lang/String;)Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "(Lnet/minecraft/util/ResourceLocation;Ldev/deftu/omnicore/client/render/pipeline/VertexFormats;Ldev/deftu/omnicore/client/render/pipeline/DrawModes;Ljava/lang/String;Ljava/lang/String;)Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipelineBuilder;", "OmniCore"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OmniRenderPipelineBuilder builderWithDefaultShader(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)vertexFormat, (String)"vertexFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            return new OmniRenderPipelineBuilder(identifier, vertexFormat, mode, null);
        }

        @JvmStatic
        @NotNull
        public final OmniRenderPipelineBuilder builderWithDefaultShader(@NotNull ResourceLocation identifier, @NotNull VertexFormats vertexFormat, @NotNull DrawModes mode) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)((Object)vertexFormat), (String)"vertexFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            return this.builderWithDefaultShader(identifier, vertexFormat.getVanilla(), mode);
        }

        @JvmStatic
        @NotNull
        public final OmniRenderPipelineBuilder builderWithLegacyShader(@NotNull ResourceLocation identifier, @NotNull VertexFormat vertexFormat, @NotNull DrawModes mode, @NotNull String vertexSource, @NotNull String fragmentSource) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)vertexFormat, (String)"vertexFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)vertexSource, (String)"vertexSource");
            Intrinsics.checkNotNullParameter((Object)fragmentSource, (String)"fragmentSource");
            return new OmniRenderPipelineBuilder(identifier, vertexFormat, mode, new LegacyShaderSource(vertexFormat, vertexSource, fragmentSource));
        }

        @JvmStatic
        @NotNull
        public final OmniRenderPipelineBuilder builderWithLegacyShader(@NotNull ResourceLocation identifier, @NotNull VertexFormats vertexFormat, @NotNull DrawModes mode, @NotNull String vertexSource, @NotNull String fragmentSource) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)((Object)vertexFormat), (String)"vertexFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)vertexSource, (String)"vertexSource");
            Intrinsics.checkNotNullParameter((Object)fragmentSource, (String)"fragmentSource");
            return this.builderWithLegacyShader(identifier, vertexFormat.getVanilla(), mode, vertexSource, fragmentSource);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

