/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client;

import dev.deftu.omnicore.client.OmniClient;
import dev.deftu.omnicore.client.OmniClientPacketHandler;
import dev.deftu.omnicore.common.OmniPacketReceiverContext;
import dev.deftu.omnicore.common.OmniPackets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ0\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0004\b\n\u0010\u000fJ6\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0017\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001d0\u001c2\u0006\u0010\u0005\u001a\u00020\u0004H\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001c\u0010%\u001a\n $*\u0004\u0018\u00010#0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R,\u0010)\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001d0(0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R \u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001d0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Ldev/deftu/omnicore/client/OmniClientPackets;", "", "<init>", "()V", "Lnet/minecraft/util/ResourceLocation;", "id", "Ljava/util/function/Consumer;", "Lio/netty/buffer/ByteBuf;", "consumer", "", "send", "(Lnet/minecraft/util/ResourceLocation;Ljava/util/function/Consumer;)V", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "block", "(Lnet/minecraft/util/ResourceLocation;Lkotlin/jvm/functions/Function1;)V", "Ldev/deftu/omnicore/common/OmniPacketReceiverContext;", "", "Lkotlin/Function0;", "createChanneledPacketReceiver", "(Lnet/minecraft/util/ResourceLocation;Lkotlin/jvm/functions/Function1;)Lkotlin/jvm/functions/Function0;", "createGlobalPacketReceiver", "(Lkotlin/jvm/functions/Function1;)Lkotlin/jvm/functions/Function0;", "setupForgeListener", "Lnet/minecraftforge/fml/common/network/FMLNetworkEvent$ClientConnectedToServerEvent;", "event", "onClientConnectedToServer", "(Lnet/minecraftforge/fml/common/network/FMLNetworkEvent$ClientConnectedToServerEvent;)V", "", "Ljava/util/function/Predicate;", "getAllPacketReceivers$OmniCore", "(Lnet/minecraft/util/ResourceLocation;)Ljava/util/Set;", "getAllPacketReceivers", "isInitialized", "Z", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/CopyOnWriteArraySet;", "channeledPacketReceivers", "Ljava/util/concurrent/ConcurrentHashMap;", "globalPacketReceivers", "Ljava/util/concurrent/CopyOnWriteArraySet;", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nOmniClientPackets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OmniClientPackets.kt\ndev/deftu/omnicore/client/OmniClientPackets\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n72#2,2:149\n1#3:151\n*S KotlinDebug\n*F\n+ 1 OmniClientPackets.kt\ndev/deftu/omnicore/client/OmniClientPackets\n*L\n84#1:149,2\n84#1:151\n*E\n"})
public final class OmniClientPackets {
    @NotNull
    public static final OmniClientPackets INSTANCE = new OmniClientPackets();
    private static boolean isInitialized;
    private static final Logger logger;
    @NotNull
    private static final ConcurrentHashMap<ResourceLocation, CopyOnWriteArraySet<Predicate<OmniPacketReceiverContext>>> channeledPacketReceivers;
    @NotNull
    private static final CopyOnWriteArraySet<Predicate<OmniPacketReceiverContext>> globalPacketReceivers;

    private OmniClientPackets() {
    }

    @JvmStatic
    public static final void send(@NotNull ResourceLocation id, @NotNull Consumer<ByteBuf> consumer) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        NetHandlerPlayClient netHandlerPlayClient = OmniClient.getNetworkHandler();
        if (netHandlerPlayClient == null) {
            return;
        }
        NetHandlerPlayClient networkHandler = netHandlerPlayClient;
        INSTANCE.setupForgeListener();
        ByteBuf buf = Unpooled.buffer();
        consumer.accept(buf);
        CPacketCustomPayload packet = new CPacketCustomPayload(id.toString(), new PacketBuffer(buf));
        networkHandler.func_147297_a((Packet)packet);
    }

    @JvmStatic
    public static final void send(@NotNull ResourceLocation id, @NotNull Function1<? super ByteBuf, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OmniClientPackets.send(id, arg_0 -> OmniClientPackets.send$lambda$0(block, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> createChanneledPacketReceiver(@NotNull ResourceLocation id, @NotNull Function1<? super OmniPacketReceiverContext, Boolean> block) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ConcurrentMap $this$getOrPut$iv = channeledPacketReceivers;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(id);
        if (object == null) {
            boolean bl = false;
            CopyOnWriteArraySet default$iv = new CopyOnWriteArraySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(id, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        CopyOnWriteArraySet list = (CopyOnWriteArraySet)object;
        Predicate<OmniPacketReceiverContext> receiver = arg_0 -> OmniClientPackets.createChanneledPacketReceiver$lambda$2(block, arg_0);
        list.add(receiver);
        INSTANCE.setupForgeListener();
        logger.debug("Registered channeled packet receiver under '{}' at {} ({})", (Object)id, (Object)(list.size() - 1), receiver);
        return () -> OmniClientPackets.createChanneledPacketReceiver$lambda$3(id, list, receiver);
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> createGlobalPacketReceiver(@NotNull Function1<? super OmniPacketReceiverContext, Boolean> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Predicate<OmniPacketReceiverContext> receiver = arg_0 -> OmniClientPackets.createGlobalPacketReceiver$lambda$4(block, arg_0);
        globalPacketReceivers.add(receiver);
        INSTANCE.setupForgeListener();
        logger.debug("Registered global packet receiver at {} ({})", (Object)(globalPacketReceivers.size() - 1), receiver);
        return () -> OmniClientPackets.createGlobalPacketReceiver$lambda$5(receiver);
    }

    private final void setupForgeListener() {
        if (isInitialized) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        isInitialized = true;
    }

    @SubscribeEvent
    public final void onClientConnectedToServer(@NotNull FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NetworkManager networkManager = event.getManager();
        Intrinsics.checkNotNull((Object)networkManager);
        OmniPackets.setupCustomPacketHandler$OmniCore(networkManager, new OmniClientPacketHandler((Function0<? extends Map<ResourceLocation, ? extends Set<? extends Predicate<OmniPacketReceiverContext>>>>)((Function0)OmniClientPackets::onClientConnectedToServer$lambda$6), (Function0<? extends Set<? extends Predicate<OmniPacketReceiverContext>>>)((Function0)OmniClientPackets::onClientConnectedToServer$lambda$7)));
    }

    @JvmStatic
    @NotNull
    public static final Set<Predicate<OmniPacketReceiverContext>> getAllPacketReceivers$OmniCore(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CopyOnWriteArraySet<Predicate<OmniPacketReceiverContext>> copyOnWriteArraySet = channeledPacketReceivers.get(id);
        Set channeled = copyOnWriteArraySet != null ? (Set)copyOnWriteArraySet : SetsKt.emptySet();
        return SetsKt.plus((Set)channeled, (Iterable)globalPacketReceivers);
    }

    private static final void send$lambda$0(Function1 $block, ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        $block.invoke((Object)buf);
    }

    private static final boolean createChanneledPacketReceiver$lambda$2(Function1 $block, OmniPacketReceiverContext buf) {
        Intrinsics.checkNotNull((Object)((Object)buf));
        return (Boolean)$block.invoke((Object)buf);
    }

    private static final Unit createChanneledPacketReceiver$lambda$3(ResourceLocation $id, CopyOnWriteArraySet $list, Predicate $receiver) {
        Intrinsics.checkNotNull((Object)$list);
        logger.debug("Consumer removed channeled packet receiver under '{}' at {} ({})", (Object)$id, (Object)CollectionsKt.indexOf((Iterable)$list, (Object)$receiver), (Object)$receiver);
        $list.remove($receiver);
        return Unit.INSTANCE;
    }

    private static final boolean createGlobalPacketReceiver$lambda$4(Function1 $block, OmniPacketReceiverContext buf) {
        Intrinsics.checkNotNull((Object)((Object)buf));
        return (Boolean)$block.invoke((Object)buf);
    }

    private static final Unit createGlobalPacketReceiver$lambda$5(Predicate $receiver) {
        logger.debug("Consumer removed global packet receiver at {} ({})", (Object)CollectionsKt.indexOf((Iterable)globalPacketReceivers, (Object)$receiver), (Object)$receiver);
        globalPacketReceivers.remove($receiver);
        return Unit.INSTANCE;
    }

    private static final Map onClientConnectedToServer$lambda$6() {
        return channeledPacketReceivers;
    }

    private static final Set onClientConnectedToServer$lambda$7() {
        return globalPacketReceivers;
    }

    static {
        logger = LogManager.getLogger(OmniClientPackets.class);
        channeledPacketReceivers = new ConcurrentHashMap();
        globalPacketReceivers = new CopyOnWriteArraySet();
    }
}

