/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render.framebuffer;

import dev.deftu.omnicore.client.render.OmniMatrixStack;
import dev.deftu.omnicore.client.render.framebuffer.Framebuffer;
import dev.deftu.omnicore.client.render.texture.GlTexture;
import dev.deftu.omnicore.client.render.texture.GpuTexture;
import dev.deftu.omnicore.client.render.texture.ManagedTexture;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001dR$\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00028\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R$\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00028\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b#\u0010\"R$\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00028\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b$\u0010\"R$\u0010&\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020%8\u0016@RX\u0096.\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R$\u0010*\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020%8\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b*\u0010'\u001a\u0004\b+\u0010)\u00a8\u0006,"}, d2={"Ldev/deftu/omnicore/client/render/framebuffer/ManagedFramebuffer;", "Ldev/deftu/omnicore/client/render/framebuffer/Framebuffer;", "", "width", "height", "Ldev/deftu/omnicore/client/render/texture/GpuTexture$TextureFormat;", "colorFormat", "depthFormat", "<init>", "(IILdev/deftu/omnicore/client/render/texture/GpuTexture$TextureFormat;Ldev/deftu/omnicore/client/render/texture/GpuTexture$TextureFormat;)V", "", "depth", "stencil", "", "clearDepthStencil", "(DI)V", "resize", "(II)V", "", "red", "green", "blue", "alpha", "clearColor", "(FFFF)V", "close", "()V", "initialize", "checkStatus", "Ldev/deftu/omnicore/client/render/texture/GpuTexture$TextureFormat;", "value", "id", "I", "getId", "()I", "getWidth", "getHeight", "Ldev/deftu/omnicore/client/render/texture/GlTexture;", "colorTexture", "Ldev/deftu/omnicore/client/render/texture/GlTexture;", "getColorTexture", "()Ldev/deftu/omnicore/client/render/texture/GlTexture;", "depthStencilTexture", "getDepthStencilTexture", "OmniCore"})
public final class ManagedFramebuffer
implements Framebuffer {
    @NotNull
    private final GpuTexture.TextureFormat colorFormat;
    @NotNull
    private final GpuTexture.TextureFormat depthFormat;
    private int id;
    private int width;
    private int height;
    private GlTexture colorTexture;
    private GlTexture depthStencilTexture;

    public ManagedFramebuffer(int width, int height, @NotNull GpuTexture.TextureFormat colorFormat, @NotNull GpuTexture.TextureFormat depthFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorFormat), (String)"colorFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)depthFormat), (String)"depthFormat");
        this.colorFormat = colorFormat;
        this.depthFormat = depthFormat;
        this.id = -1;
        this.width = width;
        this.height = height;
        this.initialize();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public GlTexture getColorTexture() {
        GlTexture glTexture = this.colorTexture;
        if (glTexture != null) {
            return glTexture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"colorTexture");
        return null;
    }

    @NotNull
    public final GlTexture getDepthStencilTexture() {
        GlTexture glTexture = this.depthStencilTexture;
        if (glTexture != null) {
            return glTexture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"depthStencilTexture");
        return null;
    }

    public final void clearDepthStencil(double depth, int stencil) {
        this.using(() -> ManagedFramebuffer.clearDepthStencil$lambda$0(depth, stencil));
    }

    @Override
    public void resize(int width, int height) {
        if (this.getWidth() == width && this.getHeight() == height) {
            return;
        }
        this.width = width;
        this.height = height;
        this.close();
        this.initialize();
    }

    @Override
    public void clearColor(float red, float green, float blue, float alpha) {
        this.using(() -> ManagedFramebuffer.clearColor$lambda$1(red, green, blue, alpha));
    }

    @Override
    public void close() {
        if (this.depthStencilTexture != null) {
            this.getDepthStencilTexture().close();
        }
        if (this.colorTexture != null) {
            this.getColorTexture().close();
        }
        if (this.getId() != -1) {
            Framebuffer.Companion.deleteFramebuffer(this.getId());
            this.id = -1;
        }
    }

    private final void initialize() {
        this.id = Framebuffer.Companion.genFramebuffer();
        this.colorTexture = new ManagedTexture(this.getWidth(), this.getHeight(), this.colorFormat);
        this.depthStencilTexture = new ManagedTexture(this.getWidth(), this.getHeight(), this.depthFormat);
        this.using(() -> ManagedFramebuffer.initialize$lambda$2(this));
    }

    private final void checkStatus() {
        int status = GL30.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            String string;
            switch (status) {
                case 36054: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                    break;
                }
                case 36055: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                    break;
                }
                case 36059: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
                    break;
                }
                case 36060: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
                    break;
                }
                case 36061: {
                    string = "GL_FRAMEBUFFER_UNSUPPORTED";
                    break;
                }
                case 36182: {
                    string = "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
                    break;
                }
                default: {
                    string = "Unknown error";
                }
            }
            String message = string;
            StringBuilder stringBuilder = new StringBuilder().append("Framebuffer is not complete: ").append(message).append(" (");
            String string2 = Integer.toString(status, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            throw new IllegalStateException(stringBuilder.append(string2).append(')').toString().toString());
        }
    }

    @Override
    @NotNull
    public Function0<Unit> bind() {
        return Framebuffer.DefaultImpls.bind(this);
    }

    @Override
    public <T> T using(int target, @NotNull Function0<? extends T> block) {
        return Framebuffer.DefaultImpls.using(this, target, block);
    }

    @Override
    public <T> T using(@NotNull Function0<? extends T> block) {
        return Framebuffer.DefaultImpls.using(this, block);
    }

    @Override
    public <T> T usingToRender(@NotNull Function3<? super OmniMatrixStack, ? super Integer, ? super Integer, ? extends T> block) {
        return Framebuffer.DefaultImpls.usingToRender(this, block);
    }

    @Override
    public void drawColorTexture(@NotNull OmniMatrixStack matrixStack, float x, float y, float width, float height, int color) {
        Framebuffer.DefaultImpls.drawColorTexture(this, matrixStack, x, y, width, height, color);
    }

    @Override
    public void writeToFile(@NotNull File file) {
        Framebuffer.DefaultImpls.writeToFile(this, file);
    }

    private static final Unit clearDepthStencil$lambda$0(double $depth, int $stencil) {
        GL11.glClearDepth((double)$depth);
        GL11.glClearStencil((int)$stencil);
        GL11.glClear((int)256);
        return Unit.INSTANCE;
    }

    private static final Unit clearColor$lambda$1(float $red, float $green, float $blue, float $alpha) {
        GL11.glClearColor((float)$red, (float)$green, (float)$blue, (float)$alpha);
        GL11.glClear((int)16384);
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$2(ManagedFramebuffer this$0) {
        int n;
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this$0.getColorTexture().getId(), (int)0);
        switch (WhenMappings.$EnumSwitchMapping$0[this$0.depthFormat.ordinal()]) {
            case 1: {
                throw new UnsupportedOperationException("RGBA8 is not a valid depth format");
            }
            case 2: {
                n = 33306;
                break;
            }
            case 3: {
                n = 36096;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GL30.glFramebufferTexture2D((int)36160, (int)n, (int)3553, (int)this$0.getDepthStencilTexture().getId(), (int)0);
        this$0.checkStatus();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GpuTexture.TextureFormat.values().length];
            try {
                nArray[GpuTexture.TextureFormat.RGBA8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpuTexture.TextureFormat.DEPTH24_STENCIL8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpuTexture.TextureFormat.DEPTH32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

