/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client.render.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.deftu.omnicore.client.render.OmniImage;
import dev.deftu.omnicore.client.render.OmniMatrixStack;
import dev.deftu.omnicore.client.render.OmniResolution;
import dev.deftu.omnicore.client.render.OmniTextureManager;
import dev.deftu.omnicore.client.render.pipeline.DrawModes;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipeline;
import dev.deftu.omnicore.client.render.pipeline.OmniRenderPipelineBuilder;
import dev.deftu.omnicore.client.render.pipeline.RenderPassBuilder;
import dev.deftu.omnicore.client.render.pipeline.VertexFormats;
import dev.deftu.omnicore.client.render.state.OmniManagedBlendState;
import dev.deftu.omnicore.client.render.state.OmniManagedScissorState;
import dev.deftu.omnicore.client.render.texture.GlTexture;
import dev.deftu.omnicore.client.render.vertex.OmniBufferBuilder;
import dev.deftu.omnicore.client.render.vertex.OmniBuiltBuffer;
import dev.deftu.omnicore.common.OmniIdentifier;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 22\u00060\u0001j\u0002`\u0002:\u00012J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH&\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J+\u0010\u0016\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u0016\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0018Jb\u0010\u001e\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00132K\u0010\u0015\u001aG\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00028\u00000\u0019H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ?\u0010#\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010'\u001a\u00020\u00062\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b'\u0010(R\u0014\u0010+\u001a\u00020\u00038&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010\u0004\u001a\u00020\u00038&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0014\u0010\u0005\u001a\u00020\u00038&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010*R\u0014\u00101\u001a\u00020.8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00063"}, d2={"Ldev/deftu/omnicore/client/render/framebuffer/Framebuffer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "", "width", "height", "", "resize", "(II)V", "", "red", "green", "blue", "alpha", "clearColor", "(FFFF)V", "Lkotlin/Function0;", "bind", "()Lkotlin/jvm/functions/Function0;", "T", "target", "block", "using", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lkotlin/Function3;", "Ldev/deftu/omnicore/client/render/OmniMatrixStack;", "Lkotlin/ParameterName;", "name", "matrixStack", "usingToRender", "(Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "x", "y", "color", "drawColorTexture", "(Ldev/deftu/omnicore/client/render/OmniMatrixStack;FFFFI)V", "Ljava/io/File;", "file", "writeToFile", "(Ljava/io/File;)V", "getId", "()I", "id", "getWidth", "getHeight", "Ldev/deftu/omnicore/client/render/texture/GlTexture;", "getColorTexture", "()Ldev/deftu/omnicore/client/render/texture/GlTexture;", "colorTexture", "Companion", "OmniCore"})
public interface Framebuffer
extends AutoCloseable {
    @NotNull
    public static final Companion Companion = dev.deftu.omnicore.client.render.framebuffer.Framebuffer$Companion.$$INSTANCE;

    public int getId();

    public int getWidth();

    public int getHeight();

    @NotNull
    public GlTexture getColorTexture();

    public void resize(int var1, int var2);

    public void clearColor(float var1, float var2, float var3, float var4);

    @NotNull
    public Function0<Unit> bind();

    public <T> T using(int var1, @NotNull Function0<? extends T> var2);

    public <T> T using(@NotNull Function0<? extends T> var1);

    public <T> T usingToRender(@NotNull Function3<? super OmniMatrixStack, ? super Integer, ? super Integer, ? extends T> var1);

    public void drawColorTexture(@NotNull OmniMatrixStack var1, float var2, float var3, float var4, float var5, int var6);

    public void writeToFile(@NotNull File var1);

    @JvmStatic
    public static <T> T withFramebuffer(int target, int fbo, @NotNull Function0<? extends T> block) {
        return Companion.withFramebuffer(target, fbo, block);
    }

    @JvmStatic
    public static <T> T withFramebuffer(int fbo, @NotNull Function0<? extends T> block) {
        return Companion.withFramebuffer(fbo, block);
    }

    @JvmStatic
    public static int genFramebuffer() {
        return Companion.genFramebuffer();
    }

    @JvmStatic
    @NotNull
    public static Function0<Unit> bindFramebuffer(int target, int fbo) {
        return Companion.bindFramebuffer(target, fbo);
    }

    @JvmStatic
    @NotNull
    public static Function0<Unit> bindFramebuffer(int fbo) {
        return Companion.bindFramebuffer(fbo);
    }

    @JvmStatic
    @NotNull
    public static Function0<Unit> bindReadFramebuffer(int fbo) {
        return Companion.bindReadFramebuffer(fbo);
    }

    @JvmStatic
    @NotNull
    public static Function0<Unit> bindDrawFramebuffer(int fbo) {
        return Companion.bindDrawFramebuffer(fbo);
    }

    @JvmStatic
    public static void deleteFramebuffer(int fbo) {
        Companion.deleteFramebuffer(fbo);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\n\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\n\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0007\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0007\u00a2\u0006\u0004\b\n\u0010\fJ\u000f\u0010\r\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0012J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001b\u0010\u001c\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Ldev/deftu/omnicore/client/render/framebuffer/Framebuffer$Companion;", "", "<init>", "()V", "T", "", "target", "fbo", "Lkotlin/Function0;", "block", "withFramebuffer", "(IILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "genFramebuffer", "()I", "", "bindFramebuffer", "(II)Lkotlin/jvm/functions/Function0;", "(I)Lkotlin/jvm/functions/Function0;", "bindReadFramebuffer", "bindDrawFramebuffer", "deleteFramebuffer", "(I)V", "Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "PIPELINE$delegate", "Lkotlin/Lazy;", "getPIPELINE", "()Ldev/deftu/omnicore/client/render/pipeline/OmniRenderPipeline;", "PIPELINE", "OmniCore"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Lazy<OmniRenderPipeline> PIPELINE$delegate;

        private Companion() {
        }

        private final OmniRenderPipeline getPIPELINE() {
            Lazy<OmniRenderPipeline> lazy = PIPELINE$delegate;
            return (OmniRenderPipeline)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T withFramebuffer(int target, int fbo, @NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Function0<Unit> unbind = this.bindFramebuffer(target, fbo);
            try {
                Object object = block.invoke();
                return (T)object;
            }
            finally {
                unbind.invoke();
            }
        }

        @JvmStatic
        public final <T> T withFramebuffer(int fbo, @NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return this.withFramebuffer(36160, fbo, block);
        }

        @JvmStatic
        public final int genFramebuffer() {
            return GlStateManager.func_227749_p_();
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindFramebuffer(int target, int fbo) {
            int prevReadFramebuffer = GL11.glGetInteger((int)36010);
            int prevDrawFramebuffer = GL11.glGetInteger((int)36006);
            GlStateManager.func_227727_h_((int)target, (int)fbo);
            return () -> Companion.bindFramebuffer$lambda$2(prevReadFramebuffer, prevDrawFramebuffer);
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindFramebuffer(int fbo) {
            return this.bindFramebuffer(36160, fbo);
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindReadFramebuffer(int fbo) {
            return this.bindFramebuffer(36008, fbo);
        }

        @JvmStatic
        @NotNull
        public final Function0<Unit> bindDrawFramebuffer(int fbo) {
            return this.bindFramebuffer(36009, fbo);
        }

        @JvmStatic
        public final void deleteFramebuffer(int fbo) {
            GlStateManager.func_227738_l_((int)fbo);
        }

        private static final OmniRenderPipeline PIPELINE_delegate$lambda$1() {
            OmniRenderPipelineBuilder omniRenderPipelineBuilder;
            OmniRenderPipelineBuilder $this$PIPELINE_delegate_u24lambda_u241_u24lambda_u240 = omniRenderPipelineBuilder = OmniRenderPipeline.Companion.builderWithDefaultShader(OmniIdentifier.create("omnicore", "framebuffer"), VertexFormats.POSITION_TEXTURE_COLOR, DrawModes.QUADS);
            boolean bl = false;
            $this$PIPELINE_delegate_u24lambda_u241_u24lambda_u240.blendState = OmniManagedBlendState.NORMAL;
            return omniRenderPipelineBuilder.build();
        }

        private static final Unit bindFramebuffer$lambda$2(int $prevReadFramebuffer, int $prevDrawFramebuffer) {
            $$INSTANCE.bindReadFramebuffer($prevReadFramebuffer);
            $$INSTANCE.bindDrawFramebuffer($prevDrawFramebuffer);
            return Unit.INSTANCE;
        }

        static {
            $$INSTANCE = new Companion();
            PIPELINE$delegate = LazyKt.lazy(Companion::PIPELINE_delegate$lambda$1);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Function0<Unit> bind(@NotNull Framebuffer $this) {
            return Companion.bindFramebuffer($this.getId());
        }

        public static <T> T using(@NotNull Framebuffer $this, int target, @NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            if ($this.getId() == -1) {
                $this.resize($this.getWidth(), $this.getHeight());
            }
            return Companion.withFramebuffer(target, $this.getId(), block);
        }

        public static <T> T using(@NotNull Framebuffer $this, @NotNull Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return $this.using(36160, block);
        }

        public static <T> T usingToRender(@NotNull Framebuffer $this, @NotNull Function3<? super OmniMatrixStack, ? super Integer, ? super Integer, ? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return $this.using(() -> DefaultImpls.usingToRender$lambda$0($this, block));
        }

        public static void drawColorTexture(@NotNull Framebuffer $this, @NotNull OmniMatrixStack matrixStack, float x, float y, float width, float height, int color) {
            Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
            matrixStack.push();
            matrixStack.scale(1.0f, 1.0f, 50.0f);
            OmniBufferBuilder buffer = OmniBufferBuilder.Companion.create(DrawModes.QUADS, VertexFormats.POSITION_TEXTURE_COLOR);
            buffer.vertex(matrixStack, x, y + height, 0.0).texture(0.0, 0.0).color(color).next();
            buffer.vertex(matrixStack, x + width, y + height, 0.0).texture(1.0, 0.0).color(color).next();
            buffer.vertex(matrixStack, x + width, y, 0.0).texture(1.0, 1.0).color(color).next();
            buffer.vertex(matrixStack, x, y, 0.0).texture(0.0, 1.0).color(color).next();
            OmniBuiltBuffer omniBuiltBuffer = buffer.build();
            if (omniBuiltBuffer != null) {
                omniBuiltBuffer.drawWithCleanup(Companion.getPIPELINE(), (Function1<? super RenderPassBuilder, Unit>)((Function1)arg_0 -> DefaultImpls.drawColorTexture$lambda$1($this, arg_0)));
            }
            matrixStack.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void writeToFile(@NotNull Framebuffer $this, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            OmniTextureManager.Companion.bindTexture($this.getColorTexture().getId());
            AutoCloseable autoCloseable = new OmniImage($this.getWidth(), $this.getHeight());
            Throwable throwable = null;
            try {
                OmniImage image = (OmniImage)autoCloseable;
                boolean bl = false;
                OmniImage.loadFromBoundTexture$default(image, 0, 1, null);
                image.flipY();
                image.saveTo(file);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            OmniTextureManager.Companion.bindTexture(0);
        }

        private static Object usingToRender$lambda$0(Framebuffer this$0, Function3 $block) {
            OmniManagedScissorState prevScissorState = OmniManagedScissorState.Companion.active();
            OmniManagedScissorState.Companion.disable();
            GL11.glViewport((int)0, (int)0, (int)this$0.getWidth(), (int)this$0.getHeight());
            OmniMatrixStack stack = new OmniMatrixStack();
            double scale = 1.0 / OmniResolution.getScaleFactor();
            stack.scale(scale * (double)OmniResolution.getViewportWidth() / (double)this$0.getWidth(), scale * (double)OmniResolution.getViewportHeight() / (double)this$0.getHeight(), 1.0);
            Object result = $block.invoke((Object)stack, (Object)this$0.getWidth(), (Object)this$0.getHeight());
            GL11.glViewport((int)0, (int)0, (int)OmniResolution.getViewportWidth(), (int)OmniResolution.getViewportHeight());
            prevScissorState.activate();
            return result;
        }

        private static Unit drawColorTexture$lambda$1(Framebuffer this$0, RenderPassBuilder $this$drawWithCleanup) {
            Intrinsics.checkNotNullParameter((Object)$this$drawWithCleanup, (String)"$this$drawWithCleanup");
            $this$drawWithCleanup.texture(0, this$0.getColorTexture().getId());
            return Unit.INSTANCE;
        }
    }
}

