/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.client;

import dev.deftu.omnicore.client.OmniClient;
import dev.deftu.omnicore.common.OmniCustomPayloadImpl;
import dev.deftu.omnicore.common.OmniPacketReceiverContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ0\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0004\b\n\u0010\u000fJ6\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00180\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001e\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR,\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00180!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R \u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00180!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Ldev/deftu/omnicore/client/OmniClientPackets;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "id", "Ljava/util/function/Consumer;", "Lio/netty/buffer/ByteBuf;", "consumer", "", "send", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/function/Consumer;)V", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "block", "(Lnet/minecraft/resources/ResourceLocation;Lkotlin/jvm/functions/Function1;)V", "Ldev/deftu/omnicore/common/OmniPacketReceiverContext;", "", "Lkotlin/Function0;", "createChanneledPacketReceiver", "(Lnet/minecraft/resources/ResourceLocation;Lkotlin/jvm/functions/Function1;)Lkotlin/jvm/functions/Function0;", "createGlobalPacketReceiver", "(Lkotlin/jvm/functions/Function1;)Lkotlin/jvm/functions/Function0;", "", "Ljava/util/function/Predicate;", "getAllPacketReceivers$OmniCore", "(Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Set;", "getAllPacketReceivers", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/CopyOnWriteArraySet;", "channeledPacketReceivers", "Ljava/util/concurrent/ConcurrentHashMap;", "globalPacketReceivers", "Ljava/util/concurrent/CopyOnWriteArraySet;", "OmniCore"})
@SourceDebugExtension(value={"SMAP\nOmniClientPackets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OmniClientPackets.kt\ndev/deftu/omnicore/client/OmniClientPackets\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,152:1\n1#2:153\n1#2:156\n72#3,2:154\n*S KotlinDebug\n*F\n+ 1 OmniClientPackets.kt\ndev/deftu/omnicore/client/OmniClientPackets\n*L\n88#1:156\n88#1:154,2\n*E\n"})
public final class OmniClientPackets {
    @NotNull
    public static final OmniClientPackets INSTANCE = new OmniClientPackets();
    private static final Logger logger = LogManager.getLogger(OmniClientPackets.class);
    @NotNull
    private static final ConcurrentHashMap<ResourceLocation, CopyOnWriteArraySet<Predicate<OmniPacketReceiverContext>>> channeledPacketReceivers = new ConcurrentHashMap();
    @NotNull
    private static final CopyOnWriteArraySet<Predicate<OmniPacketReceiverContext>> globalPacketReceivers = new CopyOnWriteArraySet();

    private OmniClientPackets() {
    }

    @JvmStatic
    public static final void send(@NotNull ResourceLocation id, @NotNull Consumer<ByteBuf> consumer) {
        OmniCustomPayloadImpl omniCustomPayloadImpl;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ClientPacketListener networkHandler = OmniClient.getNetworkHandler();
        if (networkHandler == null) {
            logger.warn("Attempted to send packet '" + id + "' while network handler is null.");
            return;
        }
        ByteBuf buf = Unpooled.buffer();
        consumer.accept(buf);
        OmniCustomPayloadImpl it = omniCustomPayloadImpl = new OmniCustomPayloadImpl(id, consumer);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)buf);
        it.write(buf);
        CustomPacketPayload customPacketPayload = omniCustomPayloadImpl;
        ServerboundCustomPayloadPacket packet = new ServerboundCustomPayloadPacket(customPacketPayload);
        networkHandler.m_295327_((Packet)packet);
    }

    @JvmStatic
    public static final void send(@NotNull ResourceLocation id, @NotNull Function1<? super ByteBuf, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OmniClientPackets.send(id, arg_0 -> OmniClientPackets.send$lambda$1(block, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> createChanneledPacketReceiver(@NotNull ResourceLocation id, @NotNull Function1<? super OmniPacketReceiverContext, Boolean> block) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ConcurrentMap $this$getOrPut$iv = channeledPacketReceivers;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(id);
        if (object == null) {
            boolean bl = false;
            CopyOnWriteArraySet default$iv = new CopyOnWriteArraySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(id, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        CopyOnWriteArraySet list = (CopyOnWriteArraySet)object;
        Predicate<OmniPacketReceiverContext> receiver = arg_0 -> OmniClientPackets.createChanneledPacketReceiver$lambda$3(block, arg_0);
        list.add(receiver);
        logger.debug("Registered channeled packet receiver under '{}' at {} ({})", (Object)id, (Object)(list.size() - 1), receiver);
        return () -> OmniClientPackets.createChanneledPacketReceiver$lambda$4(id, list, receiver);
    }

    @JvmStatic
    @NotNull
    public static final Function0<Unit> createGlobalPacketReceiver(@NotNull Function1<? super OmniPacketReceiverContext, Boolean> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Predicate<OmniPacketReceiverContext> receiver = arg_0 -> OmniClientPackets.createGlobalPacketReceiver$lambda$5(block, arg_0);
        globalPacketReceivers.add(receiver);
        logger.debug("Registered global packet receiver at {} ({})", (Object)(globalPacketReceivers.size() - 1), receiver);
        return () -> OmniClientPackets.createGlobalPacketReceiver$lambda$6(receiver);
    }

    @JvmStatic
    @NotNull
    public static final Set<Predicate<OmniPacketReceiverContext>> getAllPacketReceivers$OmniCore(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CopyOnWriteArraySet<Predicate<OmniPacketReceiverContext>> copyOnWriteArraySet = channeledPacketReceivers.get(id);
        Set channeled = copyOnWriteArraySet != null ? (Set)copyOnWriteArraySet : SetsKt.emptySet();
        return SetsKt.plus((Set)channeled, (Iterable)globalPacketReceivers);
    }

    private static final void send$lambda$1(Function1 $block, ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        $block.invoke((Object)buf);
    }

    private static final boolean createChanneledPacketReceiver$lambda$3(Function1 $block, OmniPacketReceiverContext buf) {
        Intrinsics.checkNotNull((Object)((Object)buf));
        return (Boolean)$block.invoke((Object)buf);
    }

    private static final Unit createChanneledPacketReceiver$lambda$4(ResourceLocation $id, CopyOnWriteArraySet $list, Predicate $receiver) {
        Intrinsics.checkNotNull((Object)$list);
        logger.debug("Consumer removed channeled packet receiver under '{}' at {} ({})", (Object)$id, (Object)CollectionsKt.indexOf((Iterable)$list, (Object)$receiver), (Object)$receiver);
        $list.remove($receiver);
        return Unit.INSTANCE;
    }

    private static final boolean createGlobalPacketReceiver$lambda$5(Function1 $block, OmniPacketReceiverContext buf) {
        Intrinsics.checkNotNull((Object)((Object)buf));
        return (Boolean)$block.invoke((Object)buf);
    }

    private static final Unit createGlobalPacketReceiver$lambda$6(Predicate $receiver) {
        logger.debug("Consumer removed global packet receiver at {} ({})", (Object)CollectionsKt.indexOf((Iterable)globalPacketReceivers, (Object)$receiver), (Object)$receiver);
        globalPacketReceivers.remove($receiver);
        return Unit.INSTANCE;
    }
}

