/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.omnicore.common;

import com.mojang.brigadier.StringReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002 !B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0011R\u0014\u0010\u0017\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0011R\u0014\u0010\u0019\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0011R\u0014\u0010\u001a\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0011R\u0014\u0010\u001d\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0011R\u0014\u0010\u001e\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0011R\u0014\u0010\u001f\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0011\u00a8\u0006\""}, d2={"Ldev/deftu/omnicore/common/OmniNbt;", "", "<init>", "()V", "", "value", "Lnet/minecraft/nbt/CompoundTag;", "parseCompound", "(Ljava/lang/String;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/nbt/Tag;", "parseElement", "(Ljava/lang/String;)Lnet/minecraft/nbt/Tag;", "", "type", "getTypeName", "(I)Ljava/lang/String;", "TYPE_END", "I", "TYPE_BYTE", "TYPE_SHORT", "TYPE_INT", "TYPE_LONG", "TYPE_FLOAT", "TYPE_DOUBLE", "TYPE_BYTE_ARRAY", "TYPE_STRING", "TYPE_LIST", "TYPE_COMPOUND", "TYPE_INT_ARRAY", "TYPE_LONG_ARRAY", "TYPE_NUMBER", "MAX_DEPTH", "Compound", "List", "OmniCore"})
public final class OmniNbt {
    @NotNull
    public static final OmniNbt INSTANCE = new OmniNbt();
    public static final int TYPE_END = 0;
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_DOUBLE = 6;
    public static final int TYPE_BYTE_ARRAY = 7;
    public static final int TYPE_STRING = 8;
    public static final int TYPE_LIST = 9;
    public static final int TYPE_COMPOUND = 10;
    public static final int TYPE_INT_ARRAY = 11;
    public static final int TYPE_LONG_ARRAY = 12;
    public static final int TYPE_NUMBER = 99;
    public static final int MAX_DEPTH = 512;

    private OmniNbt() {
    }

    @JvmStatic
    @NotNull
    public static final CompoundTag parseCompound(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CompoundTag compoundTag = new TagParser(new StringReader(value)).m_129373_();
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"readStruct(...)");
        return compoundTag;
    }

    @JvmStatic
    @NotNull
    public static final Tag parseElement(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Tag tag = new TagParser(new StringReader(value)).m_129371_();
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"readValue(...)");
        return tag;
    }

    @JvmStatic
    @NotNull
    public static final String getTypeName(int type) {
        return switch (type) {
            case 0 -> "End";
            case 1 -> "Byte";
            case 2 -> "Short";
            case 3 -> "Int";
            case 4 -> "Long";
            case 5 -> "Float";
            case 6 -> "Double";
            case 7 -> "ByteArray";
            case 8 -> "String";
            case 9 -> "List";
            case 10 -> "Compound";
            case 11 -> "IntArray";
            case 12 -> "LongArray";
            default -> "Unknown(" + type + ")";
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010!\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J'\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b#\u0010$J'\u0010&\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'J'\u0010)\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020(H\u0007\u00a2\u0006\u0004\b)\u0010*J-\u0010,\u001a\u00028\u0000\"\u0004\b\u0000\u0010+2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b,\u0010-J'\u00101\u001a\u0002002\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010/\u001a\u00020.H\u0007\u00a2\u0006\u0004\b1\u00102J\u0017\u00103\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b3\u00104J\u001f\u00106\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b6\u00107J!\u00109\u001a\u0004\u0018\u00010.2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b9\u0010:J\u001f\u0010<\u001a\u00020;2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b<\u0010=J\u001f\u0010>\u001a\u00020;2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b>\u0010=J\u0017\u0010?\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010B\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\bB\u0010CJ\u001f\u0010F\u001a\u0002002\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010E\u001a\u00020DH\u0007\u00a2\u0006\u0004\bF\u0010GJ\u0017\u0010J\u001a\u00020\u00042\u0006\u0010I\u001a\u00020HH\u0007\u00a2\u0006\u0004\bJ\u0010KJ\u0017\u0010L\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\bL\u0010MJ\u0017\u0010O\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\bO\u0010PJ!\u0010R\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010Q\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\bR\u0010SJ+\u0010V\u001a\u00020;2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0TH\u0007\u00a2\u0006\u0004\bV\u0010W\u00a8\u0006X"}, d2={"Ldev/deftu/omnicore/common/OmniNbt$Compound;", "", "<init>", "()V", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "key", "", "default", "getByteOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;B)B", "", "getShortOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;S)S", "", "getIntOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;I)I", "", "getLongOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;J)J", "", "getFloatOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;F)F", "", "getDoubleOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;D)D", "", "getByteArrayOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;[B)[B", "getStringOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Lnet/minecraft/nbt/ListTag;", "getListOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;Lnet/minecraft/nbt/ListTag;)Lnet/minecraft/nbt/ListTag;", "getCompoundOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;", "", "getIntArrayOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;[I)[I", "", "getLongArrayOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;[J)[J", "T", "getOrDefault", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "Lnet/minecraft/nbt/Tag;", "value", "", "putIfAbsent", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;Lnet/minecraft/nbt/Tag;)V", "deepCopy", "(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;", "other", "merge", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;", "path", "getByPath", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;)Lnet/minecraft/nbt/Tag;", "", "containsPath", "(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;)Z", "removeByPath", "toByteArray", "(Lnet/minecraft/nbt/CompoundTag;)[B", "bytes", "fromByteArray", "([B)Lnet/minecraft/nbt/CompoundTag;", "Ljava/io/OutputStream;", "out", "writeToStream", "(Lnet/minecraft/nbt/CompoundTag;Ljava/io/OutputStream;)V", "Ljava/io/InputStream;", "input", "fromStream", "(Ljava/io/InputStream;)Lnet/minecraft/nbt/CompoundTag;", "toBase64", "(Lnet/minecraft/nbt/CompoundTag;)Ljava/lang/String;", "base64", "fromBase64", "(Ljava/lang/String;)Lnet/minecraft/nbt/CompoundTag;", "indent", "prettify", "(Lnet/minecraft/nbt/CompoundTag;I)Ljava/lang/String;", "", "requiredKeys", "validate", "(Lnet/minecraft/nbt/CompoundTag;Ljava/util/Map;)Z", "OmniCore"})
    public static final class Compound {
        @NotNull
        public static final Compound INSTANCE = new Compound();

        private Compound() {
        }

        @JvmStatic
        public static final byte getByteOrDefault(@NotNull CompoundTag compound, @NotNull String key, byte by) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.m_128425_(key, 1) ? compound.m_128445_(key) : by;
        }

        @JvmStatic
        public static final short getShortOrDefault(@NotNull CompoundTag compound, @NotNull String key, short s) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.m_128425_(key, 2) ? compound.m_128448_(key) : s;
        }

        @JvmStatic
        public static final int getIntOrDefault(@NotNull CompoundTag compound, @NotNull String key, int n) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.m_128425_(key, 3) ? compound.m_128451_(key) : n;
        }

        @JvmStatic
        public static final long getLongOrDefault(@NotNull CompoundTag compound, @NotNull String key, long l) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.m_128425_(key, 4) ? compound.m_128454_(key) : l;
        }

        @JvmStatic
        public static final float getFloatOrDefault(@NotNull CompoundTag compound, @NotNull String key, float f) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.m_128425_(key, 5) ? compound.m_128457_(key) : f;
        }

        @JvmStatic
        public static final double getDoubleOrDefault(@NotNull CompoundTag compound, @NotNull String key, double d) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return compound.m_128425_(key, 6) ? compound.m_128459_(key) : d;
        }

        @JvmStatic
        @NotNull
        public static final byte[] getByteArrayOrDefault(@NotNull CompoundTag compound, @NotNull String key, @NotNull byte[] byArray) {
            byte[] byArray2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"default");
            if (compound.m_128425_(key, 7)) {
                byte[] byArray3 = compound.m_128463_(key);
                Intrinsics.checkNotNull((Object)byArray3);
                byArray2 = byArray3;
            } else {
                byArray2 = byArray;
            }
            return byArray2;
        }

        @JvmStatic
        @NotNull
        public static final String getStringOrDefault(@NotNull CompoundTag compound, @NotNull String key, @NotNull String string) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)string, (String)"default");
            if (compound.m_128425_(key, 8)) {
                String string3 = compound.m_128461_(key);
                Intrinsics.checkNotNull((Object)string3);
                string2 = string3;
            } else {
                string2 = string;
            }
            return string2;
        }

        @JvmStatic
        @NotNull
        public static final ListTag getListOrDefault(@NotNull CompoundTag compound, @NotNull String key, @NotNull ListTag listTag) {
            ListTag listTag2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)listTag, (String)"default");
            if (compound.m_128425_(key, 9)) {
                ListTag listTag3 = compound.m_128437_(key, 10);
                Intrinsics.checkNotNull((Object)listTag3);
                listTag2 = listTag3;
            } else {
                listTag2 = listTag;
            }
            return listTag2;
        }

        @JvmStatic
        @NotNull
        public static final CompoundTag getCompoundOrDefault(@NotNull CompoundTag compound, @NotNull String key, @NotNull CompoundTag compoundTag) {
            CompoundTag compoundTag2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"default");
            if (compound.m_128425_(key, 10)) {
                CompoundTag compoundTag3 = compound.m_128469_(key);
                Intrinsics.checkNotNull((Object)compoundTag3);
                compoundTag2 = compoundTag3;
            } else {
                compoundTag2 = compoundTag;
            }
            return compoundTag2;
        }

        @JvmStatic
        @NotNull
        public static final int[] getIntArrayOrDefault(@NotNull CompoundTag compound, @NotNull String key, @NotNull int[] nArray) {
            int[] nArray2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"default");
            if (compound.m_128425_(key, 11)) {
                int[] nArray3 = compound.m_128465_(key);
                Intrinsics.checkNotNull((Object)nArray3);
                nArray2 = nArray3;
            } else {
                nArray2 = nArray;
            }
            return nArray2;
        }

        @JvmStatic
        @NotNull
        public static final long[] getLongArrayOrDefault(@NotNull CompoundTag compound, @NotNull String key, @NotNull long[] lArray) {
            long[] lArray2;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)lArray, (String)"default");
            if (compound.m_128425_(key, 12)) {
                long[] lArray3 = compound.m_128467_(key);
                Intrinsics.checkNotNull((Object)lArray3);
                lArray2 = lArray3;
            } else {
                lArray2 = lArray;
            }
            return lArray2;
        }

        @JvmStatic
        public static final <T> T getOrDefault(@NotNull CompoundTag compound, @NotNull String key, T t) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            T t2 = t;
            if (t2 instanceof Byte) {
                object = Compound.getByteOrDefault(compound, key, ((Number)t).byteValue());
            } else if (t2 instanceof Short) {
                object = Compound.getShortOrDefault(compound, key, ((Number)t).shortValue());
            } else if (t2 instanceof Integer) {
                object = Compound.getIntOrDefault(compound, key, ((Number)t).intValue());
            } else if (t2 instanceof Long) {
                object = Compound.getLongOrDefault(compound, key, ((Number)t).longValue());
            } else if (t2 instanceof Float) {
                object = Float.valueOf(Compound.getFloatOrDefault(compound, key, ((Number)t).floatValue()));
            } else if (t2 instanceof Double) {
                object = Compound.getDoubleOrDefault(compound, key, ((Number)t).doubleValue());
            } else if (t2 instanceof byte[]) {
                object = Compound.getByteArrayOrDefault(compound, key, (byte[])t);
            } else if (t2 instanceof String) {
                object = Compound.getStringOrDefault(compound, key, (String)t);
            } else if (t2 instanceof ListTag) {
                object = Compound.getListOrDefault(compound, key, (ListTag)t);
            } else if (t2 instanceof CompoundTag) {
                object = Compound.getCompoundOrDefault(compound, key, (CompoundTag)t);
            } else if (t2 instanceof int[]) {
                object = Compound.getIntArrayOrDefault(compound, key, (int[])t);
            } else if (t2 instanceof long[]) {
                object = Compound.getLongArrayOrDefault(compound, key, (long[])t);
            } else {
                T t3 = t;
                Intrinsics.checkNotNull(t3);
                throw new IllegalArgumentException("Unsupported type: " + t3.getClass());
            }
            return (T)object;
        }

        @JvmStatic
        public static final void putIfAbsent(@NotNull CompoundTag compound, @NotNull String key, @NotNull Tag value) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (!compound.m_128441_(key)) {
                compound.m_128365_(key, value);
            }
        }

        @JvmStatic
        @NotNull
        public static final CompoundTag deepCopy(@NotNull CompoundTag compound) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            CompoundTag compoundTag = compound.m_6426_();
            Intrinsics.checkNotNull((Object)compoundTag, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            return compoundTag;
        }

        @JvmStatic
        @NotNull
        public static final CompoundTag merge(@NotNull CompoundTag compound, @NotNull CompoundTag other) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            for (String key : other.m_128431_()) {
                Tag otherValue = other.m_128423_(key);
                Tag thisValue = compound.m_128423_(key);
                if (thisValue instanceof CompoundTag && otherValue instanceof CompoundTag) {
                    Compound.merge((CompoundTag)thisValue, (CompoundTag)otherValue);
                    continue;
                }
                if (otherValue == null) continue;
                compound.m_128365_(key, otherValue);
            }
            return compound;
        }

        @JvmStatic
        @Nullable
        public static final Tag getByPath(@NotNull CompoundTag compound, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Tag current = (Tag)compound;
            char[] cArray = new char[]{'.'};
            for (String part : StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                if (!(current instanceof CompoundTag)) {
                    return null;
                }
                current = ((CompoundTag)current).m_128423_(part);
            }
            return current;
        }

        @JvmStatic
        public static final boolean containsPath(@NotNull CompoundTag compound, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return Compound.getByPath(compound, path) != null;
        }

        @JvmStatic
        public static final boolean removeByPath(@NotNull CompoundTag compound, @NotNull String path) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            char[] cArray = new char[]{'.'};
            java.util.List parts = StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            String last = (String)CollectionsKt.last((java.util.List)parts);
            Tag parent = Compound.getByPath(compound, CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((java.util.List)parts, (int)1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
            if (parent instanceof CompoundTag && ((CompoundTag)parent).m_128441_(last)) {
                ((CompoundTag)parent).m_128473_(last);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public static final byte[] toByteArray(@NotNull CompoundTag compound) {
            ByteArrayOutputStream byteArrayOutputStream;
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            ByteArrayOutputStream $this$toByteArray_u24lambda_u240 = byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = false;
            NbtIo.m_128947_((CompoundTag)compound, (OutputStream)$this$toByteArray_u24lambda_u240);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            return byArray;
        }

        @JvmStatic
        @NotNull
        public static final CompoundTag fromByteArray(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            CompoundTag compoundTag = NbtIo.m_128939_((InputStream)new ByteArrayInputStream(bytes));
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"readCompressed(...)");
            return compoundTag;
        }

        @JvmStatic
        public static final void writeToStream(@NotNull CompoundTag compound, @NotNull OutputStream out) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            NbtIo.m_128947_((CompoundTag)compound, (OutputStream)out);
        }

        @JvmStatic
        @NotNull
        public static final CompoundTag fromStream(@NotNull InputStream input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            CompoundTag compoundTag = NbtIo.m_128939_((InputStream)input);
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"readCompressed(...)");
            return compoundTag;
        }

        @JvmStatic
        @NotNull
        public static final String toBase64(@NotNull CompoundTag compound) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            String string = Base64.getEncoder().encodeToString(Compound.toByteArray(compound));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
            return string;
        }

        @JvmStatic
        @NotNull
        public static final CompoundTag fromBase64(@NotNull String base64) {
            Intrinsics.checkNotNullParameter((Object)base64, (String)"base64");
            byte[] bytes = Base64.getDecoder().decode(base64);
            Intrinsics.checkNotNull((Object)bytes);
            return Compound.fromByteArray(bytes);
        }

        @JvmStatic
        @NotNull
        public static final String prettify(@NotNull CompoundTag compound, int indent) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            String indentStr = StringsKt.repeat((CharSequence)" ", (int)indent);
            StringBuilder sb = new StringBuilder("{\n");
            for (String key : compound.m_128431_()) {
                Tag value = compound.m_128423_(key);
                sb.append(indentStr).append("  ").append(key).append(": ");
                StringBuilder stringBuilder = value instanceof CompoundTag ? sb.append(Compound.prettify((CompoundTag)value, indent + 2)) : sb.append(String.valueOf(value));
                sb.append("\n");
            }
            sb.append(indentStr).append("}");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public static /* synthetic */ String prettify$default(CompoundTag compoundTag, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return Compound.prettify(compoundTag, n);
        }

        @JvmStatic
        public static final boolean validate(@NotNull CompoundTag compound, @NotNull Map<String, Integer> requiredKeys) {
            Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
            Intrinsics.checkNotNullParameter(requiredKeys, (String)"requiredKeys");
            for (Map.Entry<String, Integer> entry : requiredKeys.entrySet()) {
                int expectedType;
                String key = entry.getKey();
                if (compound.m_128425_(key, expectedType = ((Number)entry.getValue()).intValue())) continue;
                return false;
            }
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ+\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J+\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000eH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J+\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190\u000eH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u0018J-\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190\u000eH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Ldev/deftu/omnicore/common/OmniNbt$List;", "", "<init>", "()V", "Lnet/minecraft/nbt/ListTag;", "list", "Lnet/minecraft/nbt/Tag;", "element", "", "add", "(Lnet/minecraft/nbt/ListTag;Lnet/minecraft/nbt/Tag;)V", "", "size", "(Lnet/minecraft/nbt/ListTag;)I", "Lkotlin/Function1;", "Lnet/minecraft/nbt/CompoundTag;", "action", "forEachCompound", "(Lnet/minecraft/nbt/ListTag;Lkotlin/jvm/functions/Function1;)V", "index", "getCompoundOrNull", "(Lnet/minecraft/nbt/ListTag;I)Lnet/minecraft/nbt/CompoundTag;", "transform", "mapCompounds", "(Lnet/minecraft/nbt/ListTag;Lkotlin/jvm/functions/Function1;)Lnet/minecraft/nbt/ListTag;", "", "predicate", "filterCompounds", "findCompound", "(Lnet/minecraft/nbt/ListTag;Lkotlin/jvm/functions/Function1;)Lnet/minecraft/nbt/CompoundTag;", "OmniCore"})
    public static final class List {
        @NotNull
        public static final List INSTANCE = new List();

        private List() {
        }

        @JvmStatic
        public static final void add(@NotNull ListTag list, @NotNull Tag element) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            list.add((Object)element);
        }

        @JvmStatic
        public static final int size(@NotNull ListTag list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            return list.size();
        }

        @JvmStatic
        public static final void forEachCompound(@NotNull ListTag list, @NotNull Function1<? super CompoundTag, Unit> action) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            int n = List.size(list);
            for (int i = 0; i < n; ++i) {
                Tag element = list.get(i);
                if (!(element instanceof CompoundTag)) continue;
                action.invoke((Object)element);
            }
        }

        @JvmStatic
        @Nullable
        public static final CompoundTag getCompoundOrNull(@NotNull ListTag list, int index) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Tag element = list.get(index);
            return element instanceof CompoundTag ? (CompoundTag)element : null;
        }

        @JvmStatic
        @NotNull
        public static final ListTag mapCompounds(@NotNull ListTag list, @NotNull Function1<? super CompoundTag, ? extends Tag> transform) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter(transform, (String)"transform");
            ListTag result = new ListTag();
            List.forEachCompound(list, (Function1<? super CompoundTag, Unit>)((Function1)arg_0 -> List.mapCompounds$lambda$0(result, transform, arg_0)));
            return result;
        }

        @JvmStatic
        @NotNull
        public static final ListTag filterCompounds(@NotNull ListTag list, @NotNull Function1<? super CompoundTag, Boolean> predicate) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            ListTag result = new ListTag();
            List.forEachCompound(list, (Function1<? super CompoundTag, Unit>)((Function1)arg_0 -> List.filterCompounds$lambda$1(predicate, result, arg_0)));
            return result;
        }

        @JvmStatic
        @Nullable
        public static final CompoundTag findCompound(@NotNull ListTag list, @NotNull Function1<? super CompoundTag, Boolean> predicate) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            int n = List.size(list);
            for (int i = 0; i < n; ++i) {
                Tag element = list.get(i);
                if (!(element instanceof CompoundTag) || !((Boolean)predicate.invoke((Object)element)).booleanValue()) continue;
                return (CompoundTag)element;
            }
            return null;
        }

        private static final Unit mapCompounds$lambda$0(ListTag $result, Function1 $transform, CompoundTag it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            List.add($result, (Tag)$transform.invoke((Object)it));
            return Unit.INSTANCE;
        }

        private static final Unit filterCompounds$lambda$1(Function1 $predicate, ListTag $result, CompoundTag it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (((Boolean)$predicate.invoke((Object)it)).booleanValue()) {
                List.add($result, (Tag)it);
            }
            return Unit.INSTANCE;
        }
    }
}

